/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.authentication;

import java.net.URI;
import java.util.Map;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.dmfs.httpessentials.httpurlconnection.HttpUrlConnectionExecutor;
import org.dmfs.oauth2.client.BasicOAuth2AuthorizationProvider;
import org.dmfs.oauth2.client.BasicOAuth2Client;
import org.dmfs.oauth2.client.BasicOAuth2ClientCredentials;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2AuthorizationProvider;
import org.dmfs.oauth2.client.OAuth2Client;
import org.dmfs.oauth2.client.OAuth2ClientCredentials;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.grants.ClientCredentialsGrant;
import org.dmfs.oauth2.client.scope.BasicScope;
import org.dmfs.oauth2.client.scope.EmptyScope;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.uris.EmptyUri;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.Duration;
import org.entur.gbfs.authentication.RequestAuthenticationException;
import org.entur.gbfs.authentication.RequestAuthenticator;

public class Oauth2ClientCredentialsGrantRequestAuthenticator
implements RequestAuthenticator {
    private final HttpRequestExecutor executor = new HttpUrlConnectionExecutor();
    private final OAuth2Client client;
    private final OAuth2Scope scope;
    private OAuth2AccessToken token;

    public Oauth2ClientCredentialsGrantRequestAuthenticator(URI tokenUrl, String clientId, String clientPassword) {
        this(tokenUrl, clientId, clientPassword, null);
    }

    public Oauth2ClientCredentialsGrantRequestAuthenticator(URI tokenUrl, String clientId, String clientPassword, String scope) {
        BasicOAuth2AuthorizationProvider provider = new BasicOAuth2AuthorizationProvider(null, tokenUrl, new Duration(1, 0, 3600));
        BasicOAuth2ClientCredentials credentials = new BasicOAuth2ClientCredentials(clientId, clientPassword);
        this.client = new BasicOAuth2Client((OAuth2AuthorizationProvider)provider, (OAuth2ClientCredentials)credentials, (Uri)EmptyUri.INSTANCE);
        this.scope = scope == null ? EmptyScope.INSTANCE : new BasicScope(new String[]{scope});
    }

    @Override
    public synchronized void authenticateRequest(Map<String, String> httpHeaders) throws RequestAuthenticationException {
        try {
            if (this.token == null || this.token.expirationDate().before(DateTime.now())) {
                this.token = new ClientCredentialsGrant(this.client, this.scope).accessToken(this.executor);
            }
            httpHeaders.put("Authorization", String.format("Bearer %s", this.token.accessToken()));
        }
        catch (Exception e) {
            throw new RequestAuthenticationException(e);
        }
    }
}

