/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.loader.v2;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.entur.gbfs.authentication.RequestAuthenticator;
import org.entur.gbfs.loader.BaseGbfsLoader;
import org.entur.gbfs.loader.GbfsFeed;
import org.entur.gbfs.loader.LanguageNotInFeedException;
import org.entur.gbfs.v2_3.gbfs.GBFS;
import org.entur.gbfs.v2_3.gbfs.GBFSFeedName;
import org.entur.gbfs.v2_3.gbfs.GBFSFeeds;

public class GbfsV2Loader
extends BaseGbfsLoader<GBFSFeedName, GBFS> {
    private final String languageCode;

    public GbfsV2Loader(String url) {
        this(url, new HashMap<String, String>(), null);
    }

    public GbfsV2Loader(String url, String languageCode) {
        this(url, new HashMap<String, String>(), languageCode);
    }

    public GbfsV2Loader(String url, Map<String, String> httpHeaders, String languageCode) {
        this(url, httpHeaders, languageCode, null, null);
    }

    public GbfsV2Loader(String url, String languageCode, RequestAuthenticator requestAuthenticator) {
        this(url, new HashMap<String, String>(), languageCode, requestAuthenticator, null);
    }

    public GbfsV2Loader(String url, String languageCode, RequestAuthenticator requestAuthenticator, Long timeoutConnection) {
        this(url, new HashMap<String, String>(), languageCode, requestAuthenticator, timeoutConnection);
    }

    public GbfsV2Loader(String url, Map<String, String> httpHeaders, String languageCode, RequestAuthenticator requestAuthenticator, Long timeoutConnection) {
        super(url, httpHeaders, requestAuthenticator, timeoutConnection, GBFS.class);
        this.languageCode = languageCode;
        this.init();
    }

    @Override
    protected List<GbfsFeed<GBFSFeedName, ?>> getFeeds() {
        GBFSFeeds feeds;
        GBFSFeeds gBFSFeeds = feeds = this.languageCode == null ? (GBFSFeeds)((GBFS)this.getDiscoveryFeed()).getFeedsData().values().iterator().next() : (GBFSFeeds)((GBFS)this.getDiscoveryFeed()).getFeedsData().get(this.languageCode);
        if (feeds == null) {
            throw new LanguageNotInFeedException("Language " + this.languageCode + " does not exist in feed");
        }
        return feeds.getFeeds().stream().map(feed -> new GbfsFeed(feed.getName(), feed.getName().implementingClass(), feed.getUrl())).collect(Collectors.toList());
    }
}

