/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import org.entur.gbfs.GbfsDelivery;
import org.entur.gbfs.GbfsLoader;
import org.entur.gbfs.GbfsSubscriptionOptions;
import org.entur.gbfs.v2_3.free_bike_status.GBFSFreeBikeStatus;
import org.entur.gbfs.v2_3.gbfs.GBFSFeedName;
import org.entur.gbfs.v2_3.gbfs_versions.GBFSGbfsVersions;
import org.entur.gbfs.v2_3.geofencing_zones.GBFSGeofencingZones;
import org.entur.gbfs.v2_3.station_information.GBFSStationInformation;
import org.entur.gbfs.v2_3.station_status.GBFSStationStatus;
import org.entur.gbfs.v2_3.system_alerts.GBFSSystemAlerts;
import org.entur.gbfs.v2_3.system_calendar.GBFSSystemCalendar;
import org.entur.gbfs.v2_3.system_hours.GBFSSystemHours;
import org.entur.gbfs.v2_3.system_information.GBFSSystemInformation;
import org.entur.gbfs.v2_3.system_pricing_plans.GBFSSystemPricingPlans;
import org.entur.gbfs.v2_3.system_regions.GBFSSystemRegions;
import org.entur.gbfs.v2_3.vehicle_types.GBFSVehicleTypes;
import org.entur.gbfs.validation.GbfsValidator;
import org.entur.gbfs.validation.GbfsValidatorFactory;
import org.entur.gbfs.validation.model.ValidationResult;

public class GbfsSubscription {
    private final GbfsSubscriptionOptions subscriptionOptions;
    private final Consumer<GbfsDelivery> consumer;
    private GbfsLoader loader;

    public GbfsSubscription(GbfsSubscriptionOptions subscriptionOptions, Consumer<GbfsDelivery> consumer) {
        this.subscriptionOptions = subscriptionOptions;
        this.consumer = consumer;
    }

    public void init() {
        this.loader = new GbfsLoader(this.subscriptionOptions.getDiscoveryURI().toString(), this.subscriptionOptions.getHeaders(), this.subscriptionOptions.getLanguageCode(), this.subscriptionOptions.getRequestAuthenticator(), this.subscriptionOptions.getTimeout());
    }

    public boolean getSetupComplete() {
        return this.loader.getSetupComplete().get();
    }

    public void update() {
        if (this.loader.update()) {
            GbfsDelivery delivery = new GbfsDelivery();
            delivery.setDiscovery(this.loader.getDiscoveryFeed());
            delivery.setVersion(this.loader.getFeed(GBFSGbfsVersions.class));
            delivery.setSystemInformation(this.loader.getFeed(GBFSSystemInformation.class));
            delivery.setVehicleTypes(this.loader.getFeed(GBFSVehicleTypes.class));
            delivery.setSystemRegions(this.loader.getFeed(GBFSSystemRegions.class));
            delivery.setStationInformation(this.loader.getFeed(GBFSStationInformation.class));
            delivery.setStationStatus(this.loader.getFeed(GBFSStationStatus.class));
            delivery.setFreeBikeStatus(this.loader.getFeed(GBFSFreeBikeStatus.class));
            delivery.setSystemAlerts(this.loader.getFeed(GBFSSystemAlerts.class));
            delivery.setSystemCalendar(this.loader.getFeed(GBFSSystemCalendar.class));
            delivery.setSystemHours(this.loader.getFeed(GBFSSystemHours.class));
            delivery.setSystemPricingPlans(this.loader.getFeed(GBFSSystemPricingPlans.class));
            delivery.setGeofencingZones(this.loader.getFeed(GBFSGeofencingZones.class));
            if (this.subscriptionOptions.isEnableValidation()) {
                delivery.setValidationResult(this.validateFeeds());
            }
            this.consumer.accept(delivery);
        }
    }

    private ValidationResult validateFeeds() {
        HashMap feeds = new HashMap();
        Arrays.stream(GBFSFeedName.values()).forEach(feedName -> {
            byte[] rawFeed = this.loader.getRawFeed((GBFSFeedName)feedName);
            if (rawFeed != null) {
                feeds.put(feedName.value(), new ByteArrayInputStream(this.loader.getRawFeed((GBFSFeedName)feedName)));
            }
        });
        GbfsValidator validator = GbfsValidatorFactory.getGbfsJsonValidator();
        return validator.validate(feeds);
    }
}

