/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import org.entur.gbfs.GbfsDelivery;
import org.entur.gbfs.GbfsSubscription;
import org.entur.gbfs.GbfsSubscriptionOptions;

public class GbfsSubscriptionManager {
    private final Map<String, GbfsSubscription> subscriptions = new ConcurrentHashMap<String, GbfsSubscription>();
    private ForkJoinPool customThreadPool;

    public GbfsSubscriptionManager() {
    }

    public GbfsSubscriptionManager(ForkJoinPool customThreadPool) {
        this.customThreadPool = customThreadPool;
    }

    public String subscribe(GbfsSubscriptionOptions options, Consumer<GbfsDelivery> consumer) {
        String id = UUID.randomUUID().toString();
        GbfsSubscription subscription = new GbfsSubscription(options, consumer);
        subscription.init();
        if (subscription.getSetupComplete()) {
            this.subscriptions.put(id, subscription);
            return id;
        }
        return null;
    }

    public void update() {
        Optional.ofNullable(this.customThreadPool).orElse(ForkJoinPool.commonPool()).execute(() -> this.subscriptions.values().parallelStream().forEach(GbfsSubscription::update));
    }

    public void unsubscribe(String identifier) {
        this.subscriptions.remove(identifier);
    }
}

