/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v2_2.vehicle_types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"vehicle_type_id", "form_factor", "propulsion_type", "max_range_meters", "name"})
public class GBFSVehicleType
implements Serializable {
    @JsonProperty(value="vehicle_type_id")
    @JsonPropertyDescription(value="Unique identifier of a vehicle type.")
    private String vehicleTypeId;
    @JsonProperty(value="form_factor")
    @JsonPropertyDescription(value="The vehicle's general form factor.")
    private FormFactor formFactor;
    @JsonProperty(value="propulsion_type")
    @JsonPropertyDescription(value="The primary propulsion type of the vehicle.")
    private PropulsionType propulsionType;
    @JsonProperty(value="max_range_meters")
    @JsonPropertyDescription(value="The furthest distance in meters that the vehicle can travel without recharging or refueling when it has the maximum amount of energy potential.")
    private Double maxRangeMeters;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The public name of this vehicle type.")
    private String name;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = -5988171373006168420L;

    @JsonProperty(value="vehicle_type_id")
    public String getVehicleTypeId() {
        return this.vehicleTypeId;
    }

    @JsonProperty(value="vehicle_type_id")
    public void setVehicleTypeId(String vehicleTypeId) {
        this.vehicleTypeId = vehicleTypeId;
    }

    public GBFSVehicleType withVehicleTypeId(String vehicleTypeId) {
        this.vehicleTypeId = vehicleTypeId;
        return this;
    }

    @JsonProperty(value="form_factor")
    public FormFactor getFormFactor() {
        return this.formFactor;
    }

    @JsonProperty(value="form_factor")
    public void setFormFactor(FormFactor formFactor) {
        this.formFactor = formFactor;
    }

    public GBFSVehicleType withFormFactor(FormFactor formFactor) {
        this.formFactor = formFactor;
        return this;
    }

    @JsonProperty(value="propulsion_type")
    public PropulsionType getPropulsionType() {
        return this.propulsionType;
    }

    @JsonProperty(value="propulsion_type")
    public void setPropulsionType(PropulsionType propulsionType) {
        this.propulsionType = propulsionType;
    }

    public GBFSVehicleType withPropulsionType(PropulsionType propulsionType) {
        this.propulsionType = propulsionType;
        return this;
    }

    @JsonProperty(value="max_range_meters")
    public Double getMaxRangeMeters() {
        return this.maxRangeMeters;
    }

    @JsonProperty(value="max_range_meters")
    public void setMaxRangeMeters(Double maxRangeMeters) {
        this.maxRangeMeters = maxRangeMeters;
    }

    public GBFSVehicleType withMaxRangeMeters(Double maxRangeMeters) {
        this.maxRangeMeters = maxRangeMeters;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public GBFSVehicleType withName(String name) {
        this.name = name;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSVehicleType withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSVehicleType.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("vehicleTypeId");
        sb.append('=');
        sb.append(this.vehicleTypeId == null ? "<null>" : this.vehicleTypeId);
        sb.append(',');
        sb.append("formFactor");
        sb.append('=');
        sb.append(this.formFactor == null ? "<null>" : this.formFactor);
        sb.append(',');
        sb.append("propulsionType");
        sb.append('=');
        sb.append(this.propulsionType == null ? "<null>" : this.propulsionType);
        sb.append(',');
        sb.append("maxRangeMeters");
        sb.append('=');
        sb.append(this.maxRangeMeters == null ? "<null>" : this.maxRangeMeters);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.vehicleTypeId == null ? 0 : this.vehicleTypeId.hashCode());
        result = result * 31 + (this.propulsionType == null ? 0 : this.propulsionType.hashCode());
        result = result * 31 + (this.formFactor == null ? 0 : this.formFactor.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.maxRangeMeters == null ? 0 : this.maxRangeMeters.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSVehicleType)) {
            return false;
        }
        GBFSVehicleType rhs = (GBFSVehicleType)other;
        return (this.vehicleTypeId == rhs.vehicleTypeId || this.vehicleTypeId != null && this.vehicleTypeId.equals(rhs.vehicleTypeId)) && (this.propulsionType == rhs.propulsionType || this.propulsionType != null && this.propulsionType.equals((Object)rhs.propulsionType)) && (this.formFactor == rhs.formFactor || this.formFactor != null && this.formFactor.equals((Object)rhs.formFactor)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.maxRangeMeters == rhs.maxRangeMeters || this.maxRangeMeters != null && this.maxRangeMeters.equals(rhs.maxRangeMeters));
    }

    public static enum FormFactor {
        BICYCLE("bicycle"),
        CAR("car"),
        MOPED("moped"),
        OTHER("other"),
        SCOOTER("scooter");

        private final String value;
        private static final Map<String, FormFactor> CONSTANTS;

        private FormFactor(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static FormFactor fromValue(String value) {
            FormFactor constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, FormFactor>();
            for (FormFactor c : FormFactor.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum PropulsionType {
        HUMAN("human"),
        ELECTRIC_ASSIST("electric_assist"),
        ELECTRIC("electric"),
        COMBUSTION("combustion");

        private final String value;
        private static final Map<String, PropulsionType> CONSTANTS;

        private PropulsionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PropulsionType fromValue(String value) {
            PropulsionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PropulsionType>();
            for (PropulsionType c : PropulsionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

