/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v3_0.manifest;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.entur.gbfs.v3_0.manifest.GBFSVersion;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"system_id", "versions"})
public class GBFSDataset
implements Serializable {
    @JsonProperty(value="system_id")
    @JsonPropertyDescription(value="The system_id from system_information.json for the corresponding data set(s).")
    private String systemId;
    @JsonProperty(value="versions")
    @JsonPropertyDescription(value="Contains one object, as defined below, for each of the available versions of a feed. The array MUST be sorted by increasing MAJOR and MINOR version number.")
    private List<GBFSVersion> versions;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = 6834857849163510782L;

    @JsonProperty(value="system_id")
    public String getSystemId() {
        return this.systemId;
    }

    @JsonProperty(value="system_id")
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public GBFSDataset withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    @JsonProperty(value="versions")
    public List<GBFSVersion> getVersions() {
        return this.versions;
    }

    @JsonProperty(value="versions")
    public void setVersions(List<GBFSVersion> versions) {
        this.versions = versions;
    }

    public GBFSDataset withVersions(List<GBFSVersion> versions) {
        this.versions = versions;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSDataset withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSDataset.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("systemId");
        sb.append('=');
        sb.append(this.systemId == null ? "<null>" : this.systemId);
        sb.append(',');
        sb.append("versions");
        sb.append('=');
        sb.append(this.versions == null ? "<null>" : this.versions);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.systemId == null ? 0 : this.systemId.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.versions == null ? 0 : this.versions.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSDataset)) {
            return false;
        }
        GBFSDataset rhs = (GBFSDataset)other;
        return (this.systemId == rhs.systemId || this.systemId != null && this.systemId.equals(rhs.systemId)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.versions == rhs.versions || this.versions != null && this.versions.equals(rhs.versions));
    }
}

