/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v2_3.vehicle_types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.entur.gbfs.v2_3.vehicle_types.GBFSEcoLabel;
import org.entur.gbfs.v2_3.vehicle_types.GBFSVehicleAssets;
import org.entur.gbfs.v2_3.vehicle_types.VehicleAccessory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"vehicle_type_id", "form_factor", "rider_capacity", "cargo_volume_capacity", "cargo_load_capacity", "propulsion_type", "eco_label", "max_range_meters", "name", "vehicle_accessories", "g_CO2_km", "vehicle_image", "make", "model", "color", "wheel_count", "max_permitted_speed", "rated_power", "default_reserve_time", "return_constraint", "vehicle_assets", "default_pricing_plan_id", "pricing_plan_ids"})
public class GBFSVehicleType
implements Serializable {
    @JsonProperty(value="vehicle_type_id")
    @JsonPropertyDescription(value="Unique identifier of a vehicle type.")
    private String vehicleTypeId;
    @JsonProperty(value="form_factor")
    @JsonPropertyDescription(value="The vehicle's general form factor.")
    private FormFactor formFactor;
    @JsonProperty(value="rider_capacity")
    @JsonPropertyDescription(value="The number of riders (driver included) the vehicle can legally accommodate")
    private Integer riderCapacity;
    @JsonProperty(value="cargo_volume_capacity")
    @JsonPropertyDescription(value="Cargo volume available in the vehicle, expressed in liters.")
    private Integer cargoVolumeCapacity;
    @JsonProperty(value="cargo_load_capacity")
    @JsonPropertyDescription(value="The capacity of the vehicle cargo space (excluding passengers), expressed in kilograms.")
    private Integer cargoLoadCapacity;
    @JsonProperty(value="propulsion_type")
    @JsonPropertyDescription(value="The primary propulsion type of the vehicle. Updated in v2.3 to represent car-sharing")
    private PropulsionType propulsionType;
    @JsonProperty(value="eco_label")
    @JsonPropertyDescription(value="Vehicle air quality certificate. added in v2.3.")
    private List<GBFSEcoLabel> ecoLabel;
    @JsonProperty(value="max_range_meters")
    @JsonPropertyDescription(value="The furthest distance in meters that the vehicle can travel without recharging or refueling when it has the maximum amount of energy potential.")
    private Double maxRangeMeters;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The public name of this vehicle type.")
    private String name;
    @JsonProperty(value="vehicle_accessories")
    @JsonPropertyDescription(value="Description of accessories available in the vehicle.")
    private List<VehicleAccessory> vehicleAccessories;
    @JsonProperty(value="g_CO2_km")
    @JsonPropertyDescription(value="Maximum quantity of CO2, in grams, emitted per kilometer, according to the WLTP. Added in v2.3")
    private Integer gCO2Km;
    @JsonProperty(value="vehicle_image")
    @JsonPropertyDescription(value="URL to an image that would assist the user in identifying the vehicle. JPEG or PNG. Added in v2.3")
    private String vehicleImage;
    @JsonProperty(value="make")
    @JsonPropertyDescription(value="The name of the vehicle manufacturer. Added in v2.3")
    private String make;
    @JsonProperty(value="model")
    @JsonPropertyDescription(value="The name of the vehicle model. Added in v2.3")
    private String model;
    @JsonProperty(value="color")
    @JsonPropertyDescription(value="The color of the vehicle. Added in v2.3")
    private String color;
    @JsonProperty(value="wheel_count")
    @JsonPropertyDescription(value="Number of wheels this vehicle type has. Added in v2.3")
    private Integer wheelCount;
    @JsonProperty(value="max_permitted_speed")
    @JsonPropertyDescription(value="The maximum speed in kilometers per hour this vehicle is permitted to reach in accordance with local permit and regulations. Added in v2.3")
    private Integer maxPermittedSpeed;
    @JsonProperty(value="rated_power")
    @JsonPropertyDescription(value="The rated power of the motor for this vehicle type in watts. Added in v2.3")
    private Integer ratedPower;
    @JsonProperty(value="default_reserve_time")
    @JsonPropertyDescription(value="Maximum time in minutes that a vehicle can be reserved before a rental begins added in v2.3-RC.")
    private Integer defaultReserveTime;
    @JsonProperty(value="return_constraint")
    @JsonPropertyDescription(value="The conditions for returning the vehicle at the end of the trip. Added in v2.3-RC as return_type, and updated to return_constraint in v2.3.")
    private ReturnConstraint returnConstraint;
    @JsonProperty(value="vehicle_assets")
    @JsonPropertyDescription(value="An object where each key defines one of the items listed below added in v2.3-RC.")
    private GBFSVehicleAssets vehicleAssets;
    @JsonProperty(value="default_pricing_plan_id")
    @JsonPropertyDescription(value="A plan_id as defined in system_pricing_plans.json added in v2.3-RC.")
    private String defaultPricingPlanId;
    @JsonProperty(value="pricing_plan_ids")
    @JsonPropertyDescription(value="Array of all pricing plan IDs as defined in system_pricing_plans.json added in v2.3-RC.")
    private List<String> pricingPlanIds;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = -5569594407587368732L;

    @JsonProperty(value="vehicle_type_id")
    public String getVehicleTypeId() {
        return this.vehicleTypeId;
    }

    @JsonProperty(value="vehicle_type_id")
    public void setVehicleTypeId(String vehicleTypeId) {
        this.vehicleTypeId = vehicleTypeId;
    }

    public GBFSVehicleType withVehicleTypeId(String vehicleTypeId) {
        this.vehicleTypeId = vehicleTypeId;
        return this;
    }

    @JsonProperty(value="form_factor")
    public FormFactor getFormFactor() {
        return this.formFactor;
    }

    @JsonProperty(value="form_factor")
    public void setFormFactor(FormFactor formFactor) {
        this.formFactor = formFactor;
    }

    public GBFSVehicleType withFormFactor(FormFactor formFactor) {
        this.formFactor = formFactor;
        return this;
    }

    @JsonProperty(value="rider_capacity")
    public Integer getRiderCapacity() {
        return this.riderCapacity;
    }

    @JsonProperty(value="rider_capacity")
    public void setRiderCapacity(Integer riderCapacity) {
        this.riderCapacity = riderCapacity;
    }

    public GBFSVehicleType withRiderCapacity(Integer riderCapacity) {
        this.riderCapacity = riderCapacity;
        return this;
    }

    @JsonProperty(value="cargo_volume_capacity")
    public Integer getCargoVolumeCapacity() {
        return this.cargoVolumeCapacity;
    }

    @JsonProperty(value="cargo_volume_capacity")
    public void setCargoVolumeCapacity(Integer cargoVolumeCapacity) {
        this.cargoVolumeCapacity = cargoVolumeCapacity;
    }

    public GBFSVehicleType withCargoVolumeCapacity(Integer cargoVolumeCapacity) {
        this.cargoVolumeCapacity = cargoVolumeCapacity;
        return this;
    }

    @JsonProperty(value="cargo_load_capacity")
    public Integer getCargoLoadCapacity() {
        return this.cargoLoadCapacity;
    }

    @JsonProperty(value="cargo_load_capacity")
    public void setCargoLoadCapacity(Integer cargoLoadCapacity) {
        this.cargoLoadCapacity = cargoLoadCapacity;
    }

    public GBFSVehicleType withCargoLoadCapacity(Integer cargoLoadCapacity) {
        this.cargoLoadCapacity = cargoLoadCapacity;
        return this;
    }

    @JsonProperty(value="propulsion_type")
    public PropulsionType getPropulsionType() {
        return this.propulsionType;
    }

    @JsonProperty(value="propulsion_type")
    public void setPropulsionType(PropulsionType propulsionType) {
        this.propulsionType = propulsionType;
    }

    public GBFSVehicleType withPropulsionType(PropulsionType propulsionType) {
        this.propulsionType = propulsionType;
        return this;
    }

    @JsonProperty(value="eco_label")
    public List<GBFSEcoLabel> getEcoLabel() {
        return this.ecoLabel;
    }

    @JsonProperty(value="eco_label")
    public void setEcoLabel(List<GBFSEcoLabel> ecoLabel) {
        this.ecoLabel = ecoLabel;
    }

    public GBFSVehicleType withEcoLabel(List<GBFSEcoLabel> ecoLabel) {
        this.ecoLabel = ecoLabel;
        return this;
    }

    @JsonProperty(value="max_range_meters")
    public Double getMaxRangeMeters() {
        return this.maxRangeMeters;
    }

    @JsonProperty(value="max_range_meters")
    public void setMaxRangeMeters(Double maxRangeMeters) {
        this.maxRangeMeters = maxRangeMeters;
    }

    public GBFSVehicleType withMaxRangeMeters(Double maxRangeMeters) {
        this.maxRangeMeters = maxRangeMeters;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public GBFSVehicleType withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="vehicle_accessories")
    public List<VehicleAccessory> getVehicleAccessories() {
        return this.vehicleAccessories;
    }

    @JsonProperty(value="vehicle_accessories")
    public void setVehicleAccessories(List<VehicleAccessory> vehicleAccessories) {
        this.vehicleAccessories = vehicleAccessories;
    }

    public GBFSVehicleType withVehicleAccessories(List<VehicleAccessory> vehicleAccessories) {
        this.vehicleAccessories = vehicleAccessories;
        return this;
    }

    @JsonProperty(value="g_CO2_km")
    public Integer getgCO2Km() {
        return this.gCO2Km;
    }

    @JsonProperty(value="g_CO2_km")
    public void setgCO2Km(Integer gCO2Km) {
        this.gCO2Km = gCO2Km;
    }

    public GBFSVehicleType withgCO2Km(Integer gCO2Km) {
        this.gCO2Km = gCO2Km;
        return this;
    }

    @JsonProperty(value="vehicle_image")
    public String getVehicleImage() {
        return this.vehicleImage;
    }

    @JsonProperty(value="vehicle_image")
    public void setVehicleImage(String vehicleImage) {
        this.vehicleImage = vehicleImage;
    }

    public GBFSVehicleType withVehicleImage(String vehicleImage) {
        this.vehicleImage = vehicleImage;
        return this;
    }

    @JsonProperty(value="make")
    public String getMake() {
        return this.make;
    }

    @JsonProperty(value="make")
    public void setMake(String make) {
        this.make = make;
    }

    public GBFSVehicleType withMake(String make) {
        this.make = make;
        return this;
    }

    @JsonProperty(value="model")
    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="model")
    public void setModel(String model) {
        this.model = model;
    }

    public GBFSVehicleType withModel(String model) {
        this.model = model;
        return this;
    }

    @JsonProperty(value="color")
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    public void setColor(String color) {
        this.color = color;
    }

    public GBFSVehicleType withColor(String color) {
        this.color = color;
        return this;
    }

    @JsonProperty(value="wheel_count")
    public Integer getWheelCount() {
        return this.wheelCount;
    }

    @JsonProperty(value="wheel_count")
    public void setWheelCount(Integer wheelCount) {
        this.wheelCount = wheelCount;
    }

    public GBFSVehicleType withWheelCount(Integer wheelCount) {
        this.wheelCount = wheelCount;
        return this;
    }

    @JsonProperty(value="max_permitted_speed")
    public Integer getMaxPermittedSpeed() {
        return this.maxPermittedSpeed;
    }

    @JsonProperty(value="max_permitted_speed")
    public void setMaxPermittedSpeed(Integer maxPermittedSpeed) {
        this.maxPermittedSpeed = maxPermittedSpeed;
    }

    public GBFSVehicleType withMaxPermittedSpeed(Integer maxPermittedSpeed) {
        this.maxPermittedSpeed = maxPermittedSpeed;
        return this;
    }

    @JsonProperty(value="rated_power")
    public Integer getRatedPower() {
        return this.ratedPower;
    }

    @JsonProperty(value="rated_power")
    public void setRatedPower(Integer ratedPower) {
        this.ratedPower = ratedPower;
    }

    public GBFSVehicleType withRatedPower(Integer ratedPower) {
        this.ratedPower = ratedPower;
        return this;
    }

    @JsonProperty(value="default_reserve_time")
    public Integer getDefaultReserveTime() {
        return this.defaultReserveTime;
    }

    @JsonProperty(value="default_reserve_time")
    public void setDefaultReserveTime(Integer defaultReserveTime) {
        this.defaultReserveTime = defaultReserveTime;
    }

    public GBFSVehicleType withDefaultReserveTime(Integer defaultReserveTime) {
        this.defaultReserveTime = defaultReserveTime;
        return this;
    }

    @JsonProperty(value="return_constraint")
    public ReturnConstraint getReturnConstraint() {
        return this.returnConstraint;
    }

    @JsonProperty(value="return_constraint")
    public void setReturnConstraint(ReturnConstraint returnConstraint) {
        this.returnConstraint = returnConstraint;
    }

    public GBFSVehicleType withReturnConstraint(ReturnConstraint returnConstraint) {
        this.returnConstraint = returnConstraint;
        return this;
    }

    @JsonProperty(value="vehicle_assets")
    public GBFSVehicleAssets getVehicleAssets() {
        return this.vehicleAssets;
    }

    @JsonProperty(value="vehicle_assets")
    public void setVehicleAssets(GBFSVehicleAssets vehicleAssets) {
        this.vehicleAssets = vehicleAssets;
    }

    public GBFSVehicleType withVehicleAssets(GBFSVehicleAssets vehicleAssets) {
        this.vehicleAssets = vehicleAssets;
        return this;
    }

    @JsonProperty(value="default_pricing_plan_id")
    public String getDefaultPricingPlanId() {
        return this.defaultPricingPlanId;
    }

    @JsonProperty(value="default_pricing_plan_id")
    public void setDefaultPricingPlanId(String defaultPricingPlanId) {
        this.defaultPricingPlanId = defaultPricingPlanId;
    }

    public GBFSVehicleType withDefaultPricingPlanId(String defaultPricingPlanId) {
        this.defaultPricingPlanId = defaultPricingPlanId;
        return this;
    }

    @JsonProperty(value="pricing_plan_ids")
    public List<String> getPricingPlanIds() {
        return this.pricingPlanIds;
    }

    @JsonProperty(value="pricing_plan_ids")
    public void setPricingPlanIds(List<String> pricingPlanIds) {
        this.pricingPlanIds = pricingPlanIds;
    }

    public GBFSVehicleType withPricingPlanIds(List<String> pricingPlanIds) {
        this.pricingPlanIds = pricingPlanIds;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSVehicleType withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSVehicleType.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("vehicleTypeId");
        sb.append('=');
        sb.append(this.vehicleTypeId == null ? "<null>" : this.vehicleTypeId);
        sb.append(',');
        sb.append("formFactor");
        sb.append('=');
        sb.append(this.formFactor == null ? "<null>" : this.formFactor);
        sb.append(',');
        sb.append("riderCapacity");
        sb.append('=');
        sb.append(this.riderCapacity == null ? "<null>" : this.riderCapacity);
        sb.append(',');
        sb.append("cargoVolumeCapacity");
        sb.append('=');
        sb.append(this.cargoVolumeCapacity == null ? "<null>" : this.cargoVolumeCapacity);
        sb.append(',');
        sb.append("cargoLoadCapacity");
        sb.append('=');
        sb.append(this.cargoLoadCapacity == null ? "<null>" : this.cargoLoadCapacity);
        sb.append(',');
        sb.append("propulsionType");
        sb.append('=');
        sb.append(this.propulsionType == null ? "<null>" : this.propulsionType);
        sb.append(',');
        sb.append("ecoLabel");
        sb.append('=');
        sb.append(this.ecoLabel == null ? "<null>" : this.ecoLabel);
        sb.append(',');
        sb.append("maxRangeMeters");
        sb.append('=');
        sb.append(this.maxRangeMeters == null ? "<null>" : this.maxRangeMeters);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("vehicleAccessories");
        sb.append('=');
        sb.append(this.vehicleAccessories == null ? "<null>" : this.vehicleAccessories);
        sb.append(',');
        sb.append("gCO2Km");
        sb.append('=');
        sb.append(this.gCO2Km == null ? "<null>" : this.gCO2Km);
        sb.append(',');
        sb.append("vehicleImage");
        sb.append('=');
        sb.append(this.vehicleImage == null ? "<null>" : this.vehicleImage);
        sb.append(',');
        sb.append("make");
        sb.append('=');
        sb.append(this.make == null ? "<null>" : this.make);
        sb.append(',');
        sb.append("model");
        sb.append('=');
        sb.append(this.model == null ? "<null>" : this.model);
        sb.append(',');
        sb.append("color");
        sb.append('=');
        sb.append(this.color == null ? "<null>" : this.color);
        sb.append(',');
        sb.append("wheelCount");
        sb.append('=');
        sb.append(this.wheelCount == null ? "<null>" : this.wheelCount);
        sb.append(',');
        sb.append("maxPermittedSpeed");
        sb.append('=');
        sb.append(this.maxPermittedSpeed == null ? "<null>" : this.maxPermittedSpeed);
        sb.append(',');
        sb.append("ratedPower");
        sb.append('=');
        sb.append(this.ratedPower == null ? "<null>" : this.ratedPower);
        sb.append(',');
        sb.append("defaultReserveTime");
        sb.append('=');
        sb.append(this.defaultReserveTime == null ? "<null>" : this.defaultReserveTime);
        sb.append(',');
        sb.append("returnConstraint");
        sb.append('=');
        sb.append(this.returnConstraint == null ? "<null>" : this.returnConstraint);
        sb.append(',');
        sb.append("vehicleAssets");
        sb.append('=');
        sb.append(this.vehicleAssets == null ? "<null>" : this.vehicleAssets);
        sb.append(',');
        sb.append("defaultPricingPlanId");
        sb.append('=');
        sb.append(this.defaultPricingPlanId == null ? "<null>" : this.defaultPricingPlanId);
        sb.append(',');
        sb.append("pricingPlanIds");
        sb.append('=');
        sb.append(this.pricingPlanIds == null ? "<null>" : this.pricingPlanIds);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.vehicleTypeId == null ? 0 : this.vehicleTypeId.hashCode());
        result = result * 31 + (this.vehicleAccessories == null ? 0 : this.vehicleAccessories.hashCode());
        result = result * 31 + (this.color == null ? 0 : this.color.hashCode());
        result = result * 31 + (this.ecoLabel == null ? 0 : this.ecoLabel.hashCode());
        result = result * 31 + (this.vehicleImage == null ? 0 : this.vehicleImage.hashCode());
        result = result * 31 + (this.formFactor == null ? 0 : this.formFactor.hashCode());
        result = result * 31 + (this.defaultPricingPlanId == null ? 0 : this.defaultPricingPlanId.hashCode());
        result = result * 31 + (this.maxPermittedSpeed == null ? 0 : this.maxPermittedSpeed.hashCode());
        result = result * 31 + (this.maxRangeMeters == null ? 0 : this.maxRangeMeters.hashCode());
        result = result * 31 + (this.vehicleAssets == null ? 0 : this.vehicleAssets.hashCode());
        result = result * 31 + (this.cargoVolumeCapacity == null ? 0 : this.cargoVolumeCapacity.hashCode());
        result = result * 31 + (this.propulsionType == null ? 0 : this.propulsionType.hashCode());
        result = result * 31 + (this.gCO2Km == null ? 0 : this.gCO2Km.hashCode());
        result = result * 31 + (this.riderCapacity == null ? 0 : this.riderCapacity.hashCode());
        result = result * 31 + (this.model == null ? 0 : this.model.hashCode());
        result = result * 31 + (this.make == null ? 0 : this.make.hashCode());
        result = result * 31 + (this.cargoLoadCapacity == null ? 0 : this.cargoLoadCapacity.hashCode());
        result = result * 31 + (this.ratedPower == null ? 0 : this.ratedPower.hashCode());
        result = result * 31 + (this.defaultReserveTime == null ? 0 : this.defaultReserveTime.hashCode());
        result = result * 31 + (this.returnConstraint == null ? 0 : this.returnConstraint.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.wheelCount == null ? 0 : this.wheelCount.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.pricingPlanIds == null ? 0 : this.pricingPlanIds.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSVehicleType)) {
            return false;
        }
        GBFSVehicleType rhs = (GBFSVehicleType)other;
        return (this.vehicleTypeId == rhs.vehicleTypeId || this.vehicleTypeId != null && this.vehicleTypeId.equals(rhs.vehicleTypeId)) && (this.vehicleAccessories == rhs.vehicleAccessories || this.vehicleAccessories != null && this.vehicleAccessories.equals(rhs.vehicleAccessories)) && (this.color == rhs.color || this.color != null && this.color.equals(rhs.color)) && (this.ecoLabel == rhs.ecoLabel || this.ecoLabel != null && this.ecoLabel.equals(rhs.ecoLabel)) && (this.vehicleImage == rhs.vehicleImage || this.vehicleImage != null && this.vehicleImage.equals(rhs.vehicleImage)) && (this.formFactor == rhs.formFactor || this.formFactor != null && this.formFactor.equals((Object)rhs.formFactor)) && (this.defaultPricingPlanId == rhs.defaultPricingPlanId || this.defaultPricingPlanId != null && this.defaultPricingPlanId.equals(rhs.defaultPricingPlanId)) && (this.maxPermittedSpeed == rhs.maxPermittedSpeed || this.maxPermittedSpeed != null && this.maxPermittedSpeed.equals(rhs.maxPermittedSpeed)) && (this.maxRangeMeters == rhs.maxRangeMeters || this.maxRangeMeters != null && this.maxRangeMeters.equals(rhs.maxRangeMeters)) && (this.vehicleAssets == rhs.vehicleAssets || this.vehicleAssets != null && this.vehicleAssets.equals(rhs.vehicleAssets)) && (this.cargoVolumeCapacity == rhs.cargoVolumeCapacity || this.cargoVolumeCapacity != null && this.cargoVolumeCapacity.equals(rhs.cargoVolumeCapacity)) && (this.propulsionType == rhs.propulsionType || this.propulsionType != null && this.propulsionType.equals((Object)rhs.propulsionType)) && (this.gCO2Km == rhs.gCO2Km || this.gCO2Km != null && this.gCO2Km.equals(rhs.gCO2Km)) && (this.riderCapacity == rhs.riderCapacity || this.riderCapacity != null && this.riderCapacity.equals(rhs.riderCapacity)) && (this.model == rhs.model || this.model != null && this.model.equals(rhs.model)) && (this.make == rhs.make || this.make != null && this.make.equals(rhs.make)) && (this.cargoLoadCapacity == rhs.cargoLoadCapacity || this.cargoLoadCapacity != null && this.cargoLoadCapacity.equals(rhs.cargoLoadCapacity)) && (this.ratedPower == rhs.ratedPower || this.ratedPower != null && this.ratedPower.equals(rhs.ratedPower)) && (this.defaultReserveTime == rhs.defaultReserveTime || this.defaultReserveTime != null && this.defaultReserveTime.equals(rhs.defaultReserveTime)) && (this.returnConstraint == rhs.returnConstraint || this.returnConstraint != null && this.returnConstraint.equals((Object)rhs.returnConstraint)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.wheelCount == rhs.wheelCount || this.wheelCount != null && this.wheelCount.equals(rhs.wheelCount)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.pricingPlanIds == rhs.pricingPlanIds || this.pricingPlanIds != null && this.pricingPlanIds.equals(rhs.pricingPlanIds));
    }

    public static enum FormFactor {
        BICYCLE("bicycle"),
        CARGO_BICYCLE("cargo_bicycle"),
        CAR("car"),
        MOPED("moped"),
        SCOOTER_STANDING("scooter_standing"),
        SCOOTER_SEATED("scooter_seated"),
        OTHER("other"),
        SCOOTER("scooter");

        private final String value;
        private static final Map<String, FormFactor> CONSTANTS;

        private FormFactor(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static FormFactor fromValue(String value) {
            FormFactor constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, FormFactor>();
            for (FormFactor c : FormFactor.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum PropulsionType {
        HUMAN("human"),
        ELECTRIC_ASSIST("electric_assist"),
        ELECTRIC("electric"),
        COMBUSTION("combustion"),
        COMBUSTION_DIESEL("combustion_diesel"),
        HYBRID("hybrid"),
        PLUG_IN_HYBRID("plug_in_hybrid"),
        HYDROGEN_FUEL_CELL("hydrogen_fuel_cell");

        private final String value;
        private static final Map<String, PropulsionType> CONSTANTS;

        private PropulsionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PropulsionType fromValue(String value) {
            PropulsionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PropulsionType>();
            for (PropulsionType c : PropulsionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ReturnConstraint {
        FREE_FLOATING("free_floating"),
        ROUNDTRIP_STATION("roundtrip_station"),
        ANY_STATION("any_station"),
        HYBRID("hybrid");

        private final String value;
        private static final Map<String, ReturnConstraint> CONSTANTS;

        private ReturnConstraint(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ReturnConstraint fromValue(String value) {
            ReturnConstraint constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ReturnConstraint>();
            for (ReturnConstraint c : ReturnConstraint.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

