/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v2_3.system_information;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.entur.gbfs.v2_3.system_information.GBFSBrandAssets;
import org.entur.gbfs.v2_3.system_information.GBFSRentalApps;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"system_id", "language", "name", "short_name", "operator", "url", "purchase_url", "start_date", "phone_number", "email", "feed_contact_email", "timezone", "license_url", "brand_assets", "terms_url", "terms_last_updated", "privacy_url", "privacy_last_updated", "rental_apps"})
public class GBFSData
implements Serializable {
    @JsonProperty(value="system_id")
    @JsonPropertyDescription(value="Identifier for this vehicle share system. This should be globally unique (even between different systems).")
    private String systemId;
    @JsonProperty(value="language")
    @JsonPropertyDescription(value="The language that will be used throughout the rest of the files. It must match the value in the gbfs.json file.")
    private String language;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the system to be displayed to customers.")
    private String name;
    @JsonProperty(value="short_name")
    @JsonPropertyDescription(value="Optional abbreviation for a system.")
    private String shortName;
    @JsonProperty(value="operator")
    @JsonPropertyDescription(value="Name of the operator")
    private String operator;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="The URL of the vehicle share system.")
    private String url;
    @JsonProperty(value="purchase_url")
    @JsonPropertyDescription(value="URL where a customer can purchase a membership.")
    private String purchaseUrl;
    @JsonProperty(value="start_date")
    @JsonPropertyDescription(value="Date that the system began operations.")
    private String startDate;
    @JsonProperty(value="phone_number")
    @JsonPropertyDescription(value="A single voice telephone number for the specified system that presents the telephone number as typical for the system's service area.")
    private String phoneNumber;
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="Email address actively monitored by the operator's customer service department.")
    private String email;
    @JsonProperty(value="feed_contact_email")
    @JsonPropertyDescription(value="A single contact email address for consumers of this feed to report technical issues (added in v1.1).")
    private String feedContactEmail;
    @JsonProperty(value="timezone")
    @JsonPropertyDescription(value="The time zone where the system is located.")
    private Timezone timezone;
    @JsonProperty(value="license_url")
    @JsonPropertyDescription(value="A fully qualified URL of a page that defines the license terms for the GBFS data for this system.")
    private String licenseUrl;
    @JsonProperty(value="brand_assets")
    @JsonPropertyDescription(value="An object where each key defines one of the items listed below (added in v2.3-RC).")
    private GBFSBrandAssets brandAssets;
    @JsonProperty(value="terms_url")
    @JsonPropertyDescription(value="A fully qualified URL pointing to the terms of service (added in v2.3-RC)")
    private String termsUrl;
    @JsonProperty(value="terms_last_updated")
    @JsonPropertyDescription(value="The date that the terms of service provided at terms_url were last updated (added in v2.3-RC)")
    private String termsLastUpdated;
    @JsonProperty(value="privacy_url")
    @JsonPropertyDescription(value="A fully qualified URL pointing to the privacy policy for the service (added in v2.3-RC).")
    private String privacyUrl;
    @JsonProperty(value="privacy_last_updated")
    @JsonPropertyDescription(value="The date that the privacy policy provided at privacy_url was last updated (added in v2.3-RC).")
    private String privacyLastUpdated;
    @JsonProperty(value="rental_apps")
    @JsonPropertyDescription(value="Contains rental app information in the android and ios JSON objects (added in v1.1).")
    private GBFSRentalApps rentalApps;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = 570701561262727921L;

    @JsonProperty(value="system_id")
    public String getSystemId() {
        return this.systemId;
    }

    @JsonProperty(value="system_id")
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public GBFSData withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    public GBFSData withLanguage(String language) {
        this.language = language;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public GBFSData withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="short_name")
    public String getShortName() {
        return this.shortName;
    }

    @JsonProperty(value="short_name")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public GBFSData withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty(value="operator")
    public String getOperator() {
        return this.operator;
    }

    @JsonProperty(value="operator")
    public void setOperator(String operator) {
        this.operator = operator;
    }

    public GBFSData withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    public GBFSData withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty(value="purchase_url")
    public String getPurchaseUrl() {
        return this.purchaseUrl;
    }

    @JsonProperty(value="purchase_url")
    public void setPurchaseUrl(String purchaseUrl) {
        this.purchaseUrl = purchaseUrl;
    }

    public GBFSData withPurchaseUrl(String purchaseUrl) {
        this.purchaseUrl = purchaseUrl;
        return this;
    }

    @JsonProperty(value="start_date")
    public String getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="start_date")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public GBFSData withStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty(value="phone_number")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phone_number")
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public GBFSData withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    public GBFSData withEmail(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="feed_contact_email")
    public String getFeedContactEmail() {
        return this.feedContactEmail;
    }

    @JsonProperty(value="feed_contact_email")
    public void setFeedContactEmail(String feedContactEmail) {
        this.feedContactEmail = feedContactEmail;
    }

    public GBFSData withFeedContactEmail(String feedContactEmail) {
        this.feedContactEmail = feedContactEmail;
        return this;
    }

    @JsonProperty(value="timezone")
    public Timezone getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="timezone")
    public void setTimezone(Timezone timezone) {
        this.timezone = timezone;
    }

    public GBFSData withTimezone(Timezone timezone) {
        this.timezone = timezone;
        return this;
    }

    @JsonProperty(value="license_url")
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    @JsonProperty(value="license_url")
    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public GBFSData withLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
        return this;
    }

    @JsonProperty(value="brand_assets")
    public GBFSBrandAssets getBrandAssets() {
        return this.brandAssets;
    }

    @JsonProperty(value="brand_assets")
    public void setBrandAssets(GBFSBrandAssets brandAssets) {
        this.brandAssets = brandAssets;
    }

    public GBFSData withBrandAssets(GBFSBrandAssets brandAssets) {
        this.brandAssets = brandAssets;
        return this;
    }

    @JsonProperty(value="terms_url")
    public String getTermsUrl() {
        return this.termsUrl;
    }

    @JsonProperty(value="terms_url")
    public void setTermsUrl(String termsUrl) {
        this.termsUrl = termsUrl;
    }

    public GBFSData withTermsUrl(String termsUrl) {
        this.termsUrl = termsUrl;
        return this;
    }

    @JsonProperty(value="terms_last_updated")
    public String getTermsLastUpdated() {
        return this.termsLastUpdated;
    }

    @JsonProperty(value="terms_last_updated")
    public void setTermsLastUpdated(String termsLastUpdated) {
        this.termsLastUpdated = termsLastUpdated;
    }

    public GBFSData withTermsLastUpdated(String termsLastUpdated) {
        this.termsLastUpdated = termsLastUpdated;
        return this;
    }

    @JsonProperty(value="privacy_url")
    public String getPrivacyUrl() {
        return this.privacyUrl;
    }

    @JsonProperty(value="privacy_url")
    public void setPrivacyUrl(String privacyUrl) {
        this.privacyUrl = privacyUrl;
    }

    public GBFSData withPrivacyUrl(String privacyUrl) {
        this.privacyUrl = privacyUrl;
        return this;
    }

    @JsonProperty(value="privacy_last_updated")
    public String getPrivacyLastUpdated() {
        return this.privacyLastUpdated;
    }

    @JsonProperty(value="privacy_last_updated")
    public void setPrivacyLastUpdated(String privacyLastUpdated) {
        this.privacyLastUpdated = privacyLastUpdated;
    }

    public GBFSData withPrivacyLastUpdated(String privacyLastUpdated) {
        this.privacyLastUpdated = privacyLastUpdated;
        return this;
    }

    @JsonProperty(value="rental_apps")
    public GBFSRentalApps getRentalApps() {
        return this.rentalApps;
    }

    @JsonProperty(value="rental_apps")
    public void setRentalApps(GBFSRentalApps rentalApps) {
        this.rentalApps = rentalApps;
    }

    public GBFSData withRentalApps(GBFSRentalApps rentalApps) {
        this.rentalApps = rentalApps;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSData withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("systemId");
        sb.append('=');
        sb.append(this.systemId == null ? "<null>" : this.systemId);
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(this.language == null ? "<null>" : this.language);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(this.shortName == null ? "<null>" : this.shortName);
        sb.append(',');
        sb.append("operator");
        sb.append('=');
        sb.append(this.operator == null ? "<null>" : this.operator);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("purchaseUrl");
        sb.append('=');
        sb.append(this.purchaseUrl == null ? "<null>" : this.purchaseUrl);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("phoneNumber");
        sb.append('=');
        sb.append(this.phoneNumber == null ? "<null>" : this.phoneNumber);
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        sb.append("feedContactEmail");
        sb.append('=');
        sb.append(this.feedContactEmail == null ? "<null>" : this.feedContactEmail);
        sb.append(',');
        sb.append("timezone");
        sb.append('=');
        sb.append(this.timezone == null ? "<null>" : this.timezone);
        sb.append(',');
        sb.append("licenseUrl");
        sb.append('=');
        sb.append(this.licenseUrl == null ? "<null>" : this.licenseUrl);
        sb.append(',');
        sb.append("brandAssets");
        sb.append('=');
        sb.append(this.brandAssets == null ? "<null>" : this.brandAssets);
        sb.append(',');
        sb.append("termsUrl");
        sb.append('=');
        sb.append(this.termsUrl == null ? "<null>" : this.termsUrl);
        sb.append(',');
        sb.append("termsLastUpdated");
        sb.append('=');
        sb.append(this.termsLastUpdated == null ? "<null>" : this.termsLastUpdated);
        sb.append(',');
        sb.append("privacyUrl");
        sb.append('=');
        sb.append(this.privacyUrl == null ? "<null>" : this.privacyUrl);
        sb.append(',');
        sb.append("privacyLastUpdated");
        sb.append('=');
        sb.append(this.privacyLastUpdated == null ? "<null>" : this.privacyLastUpdated);
        sb.append(',');
        sb.append("rentalApps");
        sb.append('=');
        sb.append(this.rentalApps == null ? "<null>" : this.rentalApps);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.privacyUrl == null ? 0 : this.privacyUrl.hashCode());
        result = result * 31 + (this.licenseUrl == null ? 0 : this.licenseUrl.hashCode());
        result = result * 31 + (this.systemId == null ? 0 : this.systemId.hashCode());
        result = result * 31 + (this.privacyLastUpdated == null ? 0 : this.privacyLastUpdated.hashCode());
        result = result * 31 + (this.timezone == null ? 0 : this.timezone.hashCode());
        result = result * 31 + (this.rentalApps == null ? 0 : this.rentalApps.hashCode());
        result = result * 31 + (this.language == null ? 0 : this.language.hashCode());
        result = result * 31 + (this.operator == null ? 0 : this.operator.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        result = result * 31 + (this.purchaseUrl == null ? 0 : this.purchaseUrl.hashCode());
        result = result * 31 + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        result = result * 31 + (this.termsUrl == null ? 0 : this.termsUrl.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.feedContactEmail == null ? 0 : this.feedContactEmail.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.shortName == null ? 0 : this.shortName.hashCode());
        result = result * 31 + (this.termsLastUpdated == null ? 0 : this.termsLastUpdated.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        result = result * 31 + (this.brandAssets == null ? 0 : this.brandAssets.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSData)) {
            return false;
        }
        GBFSData rhs = (GBFSData)other;
        return (this.privacyUrl == rhs.privacyUrl || this.privacyUrl != null && this.privacyUrl.equals(rhs.privacyUrl)) && (this.licenseUrl == rhs.licenseUrl || this.licenseUrl != null && this.licenseUrl.equals(rhs.licenseUrl)) && (this.systemId == rhs.systemId || this.systemId != null && this.systemId.equals(rhs.systemId)) && (this.privacyLastUpdated == rhs.privacyLastUpdated || this.privacyLastUpdated != null && this.privacyLastUpdated.equals(rhs.privacyLastUpdated)) && (this.timezone == rhs.timezone || this.timezone != null && this.timezone.equals((Object)rhs.timezone)) && (this.rentalApps == rhs.rentalApps || this.rentalApps != null && this.rentalApps.equals(rhs.rentalApps)) && (this.language == rhs.language || this.language != null && this.language.equals(rhs.language)) && (this.operator == rhs.operator || this.operator != null && this.operator.equals(rhs.operator)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url)) && (this.purchaseUrl == rhs.purchaseUrl || this.purchaseUrl != null && this.purchaseUrl.equals(rhs.purchaseUrl)) && (this.phoneNumber == rhs.phoneNumber || this.phoneNumber != null && this.phoneNumber.equals(rhs.phoneNumber)) && (this.termsUrl == rhs.termsUrl || this.termsUrl != null && this.termsUrl.equals(rhs.termsUrl)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.feedContactEmail == rhs.feedContactEmail || this.feedContactEmail != null && this.feedContactEmail.equals(rhs.feedContactEmail)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.shortName == rhs.shortName || this.shortName != null && this.shortName.equals(rhs.shortName)) && (this.termsLastUpdated == rhs.termsLastUpdated || this.termsLastUpdated != null && this.termsLastUpdated.equals(rhs.termsLastUpdated)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate)) && (this.email == rhs.email || this.email != null && this.email.equals(rhs.email)) && (this.brandAssets == rhs.brandAssets || this.brandAssets != null && this.brandAssets.equals(rhs.brandAssets));
    }

    public static enum Timezone {
        AFRICA_ABIDJAN("Africa/Abidjan"),
        AFRICA_ALGIERS("Africa/Algiers"),
        AFRICA_BISSAU("Africa/Bissau"),
        AFRICA_CAIRO("Africa/Cairo"),
        AFRICA_CASABLANCA("Africa/Casablanca"),
        AFRICA_CEUTA("Africa/Ceuta"),
        AFRICA_EL_AAIUN("Africa/El_Aaiun"),
        AFRICA_JOHANNESBURG("Africa/Johannesburg"),
        AFRICA_JUBA("Africa/Juba"),
        AFRICA_KHARTOUM("Africa/Khartoum"),
        AFRICA_LAGOS("Africa/Lagos"),
        AFRICA_MAPUTO("Africa/Maputo"),
        AFRICA_MONROVIA("Africa/Monrovia"),
        AFRICA_NAIROBI("Africa/Nairobi"),
        AFRICA_NDJAMENA("Africa/Ndjamena"),
        AFRICA_SAO_TOME("Africa/Sao_Tome"),
        AFRICA_TRIPOLI("Africa/Tripoli"),
        AFRICA_TUNIS("Africa/Tunis"),
        AFRICA_WINDHOEK("Africa/Windhoek"),
        AMERICA_ADAK("America/Adak"),
        AMERICA_ANCHORAGE("America/Anchorage"),
        AMERICA_ARAGUAINA("America/Araguaina"),
        AMERICA_ARGENTINA_BUENOS_AIRES("America/Argentina/Buenos_Aires"),
        AMERICA_ARGENTINA_CATAMARCA("America/Argentina/Catamarca"),
        AMERICA_ARGENTINA_CORDOBA("America/Argentina/Cordoba"),
        AMERICA_ARGENTINA_JUJUY("America/Argentina/Jujuy"),
        AMERICA_ARGENTINA_LA_RIOJA("America/Argentina/La_Rioja"),
        AMERICA_ARGENTINA_MENDOZA("America/Argentina/Mendoza"),
        AMERICA_ARGENTINA_RIO_GALLEGOS("America/Argentina/Rio_Gallegos"),
        AMERICA_ARGENTINA_SALTA("America/Argentina/Salta"),
        AMERICA_ARGENTINA_SAN_JUAN("America/Argentina/San_Juan"),
        AMERICA_ARGENTINA_SAN_LUIS("America/Argentina/San_Luis"),
        AMERICA_ARGENTINA_TUCUMAN("America/Argentina/Tucuman"),
        AMERICA_ARGENTINA_USHUAIA("America/Argentina/Ushuaia"),
        AMERICA_ASUNCION("America/Asuncion"),
        AMERICA_BAHIA("America/Bahia"),
        AMERICA_BAHIA_BANDERAS("America/Bahia_Banderas"),
        AMERICA_BARBADOS("America/Barbados"),
        AMERICA_BELEM("America/Belem"),
        AMERICA_BELIZE("America/Belize"),
        AMERICA_BOA_VISTA("America/Boa_Vista"),
        AMERICA_BOGOTA("America/Bogota"),
        AMERICA_BOISE("America/Boise"),
        AMERICA_CAMBRIDGE_BAY("America/Cambridge_Bay"),
        AMERICA_CAMPO_GRANDE("America/Campo_Grande"),
        AMERICA_CANCUN("America/Cancun"),
        AMERICA_CARACAS("America/Caracas"),
        AMERICA_CAYENNE("America/Cayenne"),
        AMERICA_CHICAGO("America/Chicago"),
        AMERICA_CHIHUAHUA("America/Chihuahua"),
        AMERICA_COSTA_RICA("America/Costa_Rica"),
        AMERICA_CUIABA("America/Cuiaba"),
        AMERICA_DANMARKSHAVN("America/Danmarkshavn"),
        AMERICA_DAWSON("America/Dawson"),
        AMERICA_DAWSON_CREEK("America/Dawson_Creek"),
        AMERICA_DENVER("America/Denver"),
        AMERICA_DETROIT("America/Detroit"),
        AMERICA_EDMONTON("America/Edmonton"),
        AMERICA_EIRUNEPE("America/Eirunepe"),
        AMERICA_EL_SALVADOR("America/El_Salvador"),
        AMERICA_FORT_NELSON("America/Fort_Nelson"),
        AMERICA_FORTALEZA("America/Fortaleza"),
        AMERICA_GLACE_BAY("America/Glace_Bay"),
        AMERICA_GOOSE_BAY("America/Goose_Bay"),
        AMERICA_GRAND_TURK("America/Grand_Turk"),
        AMERICA_GUATEMALA("America/Guatemala"),
        AMERICA_GUAYAQUIL("America/Guayaquil"),
        AMERICA_GUYANA("America/Guyana"),
        AMERICA_HALIFAX("America/Halifax"),
        AMERICA_HAVANA("America/Havana"),
        AMERICA_HERMOSILLO("America/Hermosillo"),
        AMERICA_INDIANA_INDIANAPOLIS("America/Indiana/Indianapolis"),
        AMERICA_INDIANA_KNOX("America/Indiana/Knox"),
        AMERICA_INDIANA_MARENGO("America/Indiana/Marengo"),
        AMERICA_INDIANA_PETERSBURG("America/Indiana/Petersburg"),
        AMERICA_INDIANA_TELL_CITY("America/Indiana/Tell_City"),
        AMERICA_INDIANA_VEVAY("America/Indiana/Vevay"),
        AMERICA_INDIANA_VINCENNES("America/Indiana/Vincennes"),
        AMERICA_INDIANA_WINAMAC("America/Indiana/Winamac"),
        AMERICA_INUVIK("America/Inuvik"),
        AMERICA_IQALUIT("America/Iqaluit"),
        AMERICA_JAMAICA("America/Jamaica"),
        AMERICA_JUNEAU("America/Juneau"),
        AMERICA_KENTUCKY_LOUISVILLE("America/Kentucky/Louisville"),
        AMERICA_KENTUCKY_MONTICELLO("America/Kentucky/Monticello"),
        AMERICA_LA_PAZ("America/La_Paz"),
        AMERICA_LIMA("America/Lima"),
        AMERICA_LOS_ANGELES("America/Los_Angeles"),
        AMERICA_MACEIO("America/Maceio"),
        AMERICA_MANAGUA("America/Managua"),
        AMERICA_MANAUS("America/Manaus"),
        AMERICA_MARTINIQUE("America/Martinique"),
        AMERICA_MATAMOROS("America/Matamoros"),
        AMERICA_MAZATLAN("America/Mazatlan"),
        AMERICA_MENOMINEE("America/Menominee"),
        AMERICA_MERIDA("America/Merida"),
        AMERICA_METLAKATLA("America/Metlakatla"),
        AMERICA_MEXICO_CITY("America/Mexico_City"),
        AMERICA_MIQUELON("America/Miquelon"),
        AMERICA_MONCTON("America/Moncton"),
        AMERICA_MONTERREY("America/Monterrey"),
        AMERICA_MONTEVIDEO("America/Montevideo"),
        AMERICA_NEW_YORK("America/New_York"),
        AMERICA_NIPIGON("America/Nipigon"),
        AMERICA_NOME("America/Nome"),
        AMERICA_NORONHA("America/Noronha"),
        AMERICA_NORTH_DAKOTA_BEULAH("America/North_Dakota/Beulah"),
        AMERICA_NORTH_DAKOTA_CENTER("America/North_Dakota/Center"),
        AMERICA_NORTH_DAKOTA_NEW_SALEM("America/North_Dakota/New_Salem"),
        AMERICA_NUUK("America/Nuuk"),
        AMERICA_OJINAGA("America/Ojinaga"),
        AMERICA_PANAMA("America/Panama"),
        AMERICA_PANGNIRTUNG("America/Pangnirtung"),
        AMERICA_PARAMARIBO("America/Paramaribo"),
        AMERICA_PHOENIX("America/Phoenix"),
        AMERICA_PORT_AU_PRINCE("America/Port-au-Prince"),
        AMERICA_PORTO_VELHO("America/Porto_Velho"),
        AMERICA_PUERTO_RICO("America/Puerto_Rico"),
        AMERICA_PUNTA_ARENAS("America/Punta_Arenas"),
        AMERICA_RAINY_RIVER("America/Rainy_River"),
        AMERICA_RANKIN_INLET("America/Rankin_Inlet"),
        AMERICA_RECIFE("America/Recife"),
        AMERICA_REGINA("America/Regina"),
        AMERICA_RESOLUTE("America/Resolute"),
        AMERICA_RIO_BRANCO("America/Rio_Branco"),
        AMERICA_SANTAREM("America/Santarem"),
        AMERICA_SANTIAGO("America/Santiago"),
        AMERICA_SANTO_DOMINGO("America/Santo_Domingo"),
        AMERICA_SAO_PAULO("America/Sao_Paulo"),
        AMERICA_SCORESBYSUND("America/Scoresbysund"),
        AMERICA_SITKA("America/Sitka"),
        AMERICA_ST_JOHNS("America/St_Johns"),
        AMERICA_SWIFT_CURRENT("America/Swift_Current"),
        AMERICA_TEGUCIGALPA("America/Tegucigalpa"),
        AMERICA_THULE("America/Thule"),
        AMERICA_THUNDER_BAY("America/Thunder_Bay"),
        AMERICA_TIJUANA("America/Tijuana"),
        AMERICA_TORONTO("America/Toronto"),
        AMERICA_VANCOUVER("America/Vancouver"),
        AMERICA_WHITEHORSE("America/Whitehorse"),
        AMERICA_WINNIPEG("America/Winnipeg"),
        AMERICA_YAKUTAT("America/Yakutat"),
        AMERICA_YELLOWKNIFE("America/Yellowknife"),
        ANTARCTICA_CASEY("Antarctica/Casey"),
        ANTARCTICA_DAVIS("Antarctica/Davis"),
        ANTARCTICA_MACQUARIE("Antarctica/Macquarie"),
        ANTARCTICA_MAWSON("Antarctica/Mawson"),
        ANTARCTICA_PALMER("Antarctica/Palmer"),
        ANTARCTICA_ROTHERA("Antarctica/Rothera"),
        ANTARCTICA_TROLL("Antarctica/Troll"),
        ANTARCTICA_VOSTOK("Antarctica/Vostok"),
        ASIA_ALMATY("Asia/Almaty"),
        ASIA_AMMAN("Asia/Amman"),
        ASIA_ANADYR("Asia/Anadyr"),
        ASIA_AQTAU("Asia/Aqtau"),
        ASIA_AQTOBE("Asia/Aqtobe"),
        ASIA_ASHGABAT("Asia/Ashgabat"),
        ASIA_ATYRAU("Asia/Atyrau"),
        ASIA_BAGHDAD("Asia/Baghdad"),
        ASIA_BAKU("Asia/Baku"),
        ASIA_BANGKOK("Asia/Bangkok"),
        ASIA_BARNAUL("Asia/Barnaul"),
        ASIA_BEIRUT("Asia/Beirut"),
        ASIA_BISHKEK("Asia/Bishkek"),
        ASIA_BRUNEI("Asia/Brunei"),
        ASIA_CHITA("Asia/Chita"),
        ASIA_CHOIBALSAN("Asia/Choibalsan"),
        ASIA_COLOMBO("Asia/Colombo"),
        ASIA_DAMASCUS("Asia/Damascus"),
        ASIA_DHAKA("Asia/Dhaka"),
        ASIA_DILI("Asia/Dili"),
        ASIA_DUBAI("Asia/Dubai"),
        ASIA_DUSHANBE("Asia/Dushanbe"),
        ASIA_FAMAGUSTA("Asia/Famagusta"),
        ASIA_GAZA("Asia/Gaza"),
        ASIA_HEBRON("Asia/Hebron"),
        ASIA_HO_CHI_MINH("Asia/Ho_Chi_Minh"),
        ASIA_HONG_KONG("Asia/Hong_Kong"),
        ASIA_HOVD("Asia/Hovd"),
        ASIA_IRKUTSK("Asia/Irkutsk"),
        ASIA_JAKARTA("Asia/Jakarta"),
        ASIA_JAYAPURA("Asia/Jayapura"),
        ASIA_JERUSALEM("Asia/Jerusalem"),
        ASIA_KABUL("Asia/Kabul"),
        ASIA_KAMCHATKA("Asia/Kamchatka"),
        ASIA_KARACHI("Asia/Karachi"),
        ASIA_KATHMANDU("Asia/Kathmandu"),
        ASIA_KHANDYGA("Asia/Khandyga"),
        ASIA_KOLKATA("Asia/Kolkata"),
        ASIA_KRASNOYARSK("Asia/Krasnoyarsk"),
        ASIA_KUALA_LUMPUR("Asia/Kuala_Lumpur"),
        ASIA_KUCHING("Asia/Kuching"),
        ASIA_MACAU("Asia/Macau"),
        ASIA_MAGADAN("Asia/Magadan"),
        ASIA_MAKASSAR("Asia/Makassar"),
        ASIA_MANILA("Asia/Manila"),
        ASIA_NICOSIA("Asia/Nicosia"),
        ASIA_NOVOKUZNETSK("Asia/Novokuznetsk"),
        ASIA_NOVOSIBIRSK("Asia/Novosibirsk"),
        ASIA_OMSK("Asia/Omsk"),
        ASIA_ORAL("Asia/Oral"),
        ASIA_PONTIANAK("Asia/Pontianak"),
        ASIA_PYONGYANG("Asia/Pyongyang"),
        ASIA_QATAR("Asia/Qatar"),
        ASIA_QOSTANAY("Asia/Qostanay"),
        ASIA_QYZYLORDA("Asia/Qyzylorda"),
        ASIA_RIYADH("Asia/Riyadh"),
        ASIA_SAKHALIN("Asia/Sakhalin"),
        ASIA_SAMARKAND("Asia/Samarkand"),
        ASIA_SEOUL("Asia/Seoul"),
        ASIA_SHANGHAI("Asia/Shanghai"),
        ASIA_SINGAPORE("Asia/Singapore"),
        ASIA_SREDNEKOLYMSK("Asia/Srednekolymsk"),
        ASIA_TAIPEI("Asia/Taipei"),
        ASIA_TASHKENT("Asia/Tashkent"),
        ASIA_TBILISI("Asia/Tbilisi"),
        ASIA_TEHRAN("Asia/Tehran"),
        ASIA_THIMPHU("Asia/Thimphu"),
        ASIA_TOKYO("Asia/Tokyo"),
        ASIA_TOMSK("Asia/Tomsk"),
        ASIA_ULAANBAATAR("Asia/Ulaanbaatar"),
        ASIA_URUMQI("Asia/Urumqi"),
        ASIA_UST_NERA("Asia/Ust-Nera"),
        ASIA_VLADIVOSTOK("Asia/Vladivostok"),
        ASIA_YAKUTSK("Asia/Yakutsk"),
        ASIA_YANGON("Asia/Yangon"),
        ASIA_YEKATERINBURG("Asia/Yekaterinburg"),
        ASIA_YEREVAN("Asia/Yerevan"),
        ATLANTIC_AZORES("Atlantic/Azores"),
        ATLANTIC_BERMUDA("Atlantic/Bermuda"),
        ATLANTIC_CANARY("Atlantic/Canary"),
        ATLANTIC_CAPE_VERDE("Atlantic/Cape_Verde"),
        ATLANTIC_FAROE("Atlantic/Faroe"),
        ATLANTIC_MADEIRA("Atlantic/Madeira"),
        ATLANTIC_REYKJAVIK("Atlantic/Reykjavik"),
        ATLANTIC_SOUTH_GEORGIA("Atlantic/South_Georgia"),
        ATLANTIC_STANLEY("Atlantic/Stanley"),
        AUSTRALIA_ADELAIDE("Australia/Adelaide"),
        AUSTRALIA_BRISBANE("Australia/Brisbane"),
        AUSTRALIA_BROKEN_HILL("Australia/Broken_Hill"),
        AUSTRALIA_DARWIN("Australia/Darwin"),
        AUSTRALIA_EUCLA("Australia/Eucla"),
        AUSTRALIA_HOBART("Australia/Hobart"),
        AUSTRALIA_LINDEMAN("Australia/Lindeman"),
        AUSTRALIA_LORD_HOWE("Australia/Lord_Howe"),
        AUSTRALIA_MELBOURNE("Australia/Melbourne"),
        AUSTRALIA_PERTH("Australia/Perth"),
        AUSTRALIA_SYDNEY("Australia/Sydney"),
        CET("CET"),
        CST_6_CDT("CST6CDT"),
        EET("EET"),
        EST("EST"),
        EST_5_EDT("EST5EDT"),
        ETC_GMT("Etc/GMT"),
        ETC_GMT_1("Etc/GMT-1"),
        ETC_GMT_10("Etc/GMT-10"),
        ETC_GMT_11("Etc/GMT-11"),
        ETC_GMT_12("Etc/GMT-12"),
        ETC_GMT_13("Etc/GMT-13"),
        ETC_GMT_14("Etc/GMT-14"),
        ETC_GMT_2("Etc/GMT-2"),
        ETC_GMT_3("Etc/GMT-3"),
        ETC_GMT_4("Etc/GMT-4"),
        ETC_GMT_5("Etc/GMT-5"),
        ETC_GMT_6("Etc/GMT-6"),
        ETC_GMT_7("Etc/GMT-7"),
        ETC_GMT_8("Etc/GMT-8"),
        ETC_GMT_9("Etc/GMT-9"),
        ETC_GMT_1_("Etc/GMT+1"),
        ETC_GMT_10_("Etc/GMT+10"),
        ETC_GMT_11_("Etc/GMT+11"),
        ETC_GMT_12_("Etc/GMT+12"),
        ETC_GMT_2_("Etc/GMT+2"),
        ETC_GMT_3_("Etc/GMT+3"),
        ETC_GMT_4_("Etc/GMT+4"),
        ETC_GMT_5_("Etc/GMT+5"),
        ETC_GMT_6_("Etc/GMT+6"),
        ETC_GMT_7_("Etc/GMT+7"),
        ETC_GMT_8_("Etc/GMT+8"),
        ETC_GMT_9_("Etc/GMT+9"),
        ETC_UTC("Etc/UTC"),
        EUROPE_AMSTERDAM("Europe/Amsterdam"),
        EUROPE_ANDORRA("Europe/Andorra"),
        EUROPE_ASTRAKHAN("Europe/Astrakhan"),
        EUROPE_ATHENS("Europe/Athens"),
        EUROPE_BELGRADE("Europe/Belgrade"),
        EUROPE_BERLIN("Europe/Berlin"),
        EUROPE_BRUSSELS("Europe/Brussels"),
        EUROPE_BUCHAREST("Europe/Bucharest"),
        EUROPE_BUDAPEST("Europe/Budapest"),
        EUROPE_CHISINAU("Europe/Chisinau"),
        EUROPE_COPENHAGEN("Europe/Copenhagen"),
        EUROPE_DUBLIN("Europe/Dublin"),
        EUROPE_GIBRALTAR("Europe/Gibraltar"),
        EUROPE_HELSINKI("Europe/Helsinki"),
        EUROPE_ISTANBUL("Europe/Istanbul"),
        EUROPE_KALININGRAD("Europe/Kaliningrad"),
        EUROPE_KIEV("Europe/Kiev"),
        EUROPE_KIROV("Europe/Kirov"),
        EUROPE_LISBON("Europe/Lisbon"),
        EUROPE_LONDON("Europe/London"),
        EUROPE_LUXEMBOURG("Europe/Luxembourg"),
        EUROPE_MADRID("Europe/Madrid"),
        EUROPE_MALTA("Europe/Malta"),
        EUROPE_MINSK("Europe/Minsk"),
        EUROPE_MONACO("Europe/Monaco"),
        EUROPE_MOSCOW("Europe/Moscow"),
        EUROPE_OSLO("Europe/Oslo"),
        EUROPE_PARIS("Europe/Paris"),
        EUROPE_PRAGUE("Europe/Prague"),
        EUROPE_RIGA("Europe/Riga"),
        EUROPE_ROME("Europe/Rome"),
        EUROPE_SAMARA("Europe/Samara"),
        EUROPE_SARATOV("Europe/Saratov"),
        EUROPE_SIMFEROPOL("Europe/Simferopol"),
        EUROPE_SOFIA("Europe/Sofia"),
        EUROPE_STOCKHOLM("Europe/Stockholm"),
        EUROPE_TALLINN("Europe/Tallinn"),
        EUROPE_TIRANE("Europe/Tirane"),
        EUROPE_ULYANOVSK("Europe/Ulyanovsk"),
        EUROPE_UZHGOROD("Europe/Uzhgorod"),
        EUROPE_VIENNA("Europe/Vienna"),
        EUROPE_VILNIUS("Europe/Vilnius"),
        EUROPE_VOLGOGRAD("Europe/Volgograd"),
        EUROPE_WARSAW("Europe/Warsaw"),
        EUROPE_ZAPOROZHYE("Europe/Zaporozhye"),
        EUROPE_ZURICH("Europe/Zurich"),
        HST("HST"),
        INDIAN_CHAGOS("Indian/Chagos"),
        INDIAN_CHRISTMAS("Indian/Christmas"),
        INDIAN_COCOS("Indian/Cocos"),
        INDIAN_KERGUELEN("Indian/Kerguelen"),
        INDIAN_MAHE("Indian/Mahe"),
        INDIAN_MALDIVES("Indian/Maldives"),
        INDIAN_MAURITIUS("Indian/Mauritius"),
        INDIAN_REUNION("Indian/Reunion"),
        MET("MET"),
        MST("MST"),
        MST_7_MDT("MST7MDT"),
        PACIFIC_APIA("Pacific/Apia"),
        PACIFIC_AUCKLAND("Pacific/Auckland"),
        PACIFIC_BOUGAINVILLE("Pacific/Bougainville"),
        PACIFIC_CHATHAM("Pacific/Chatham"),
        PACIFIC_CHUUK("Pacific/Chuuk"),
        PACIFIC_EASTER("Pacific/Easter"),
        PACIFIC_EFATE("Pacific/Efate"),
        PACIFIC_FAKAOFO("Pacific/Fakaofo"),
        PACIFIC_FIJI("Pacific/Fiji"),
        PACIFIC_FUNAFUTI("Pacific/Funafuti"),
        PACIFIC_GALAPAGOS("Pacific/Galapagos"),
        PACIFIC_GAMBIER("Pacific/Gambier"),
        PACIFIC_GUADALCANAL("Pacific/Guadalcanal"),
        PACIFIC_GUAM("Pacific/Guam"),
        PACIFIC_HONOLULU("Pacific/Honolulu"),
        PACIFIC_KANTON("Pacific/Kanton"),
        PACIFIC_KIRITIMATI("Pacific/Kiritimati"),
        PACIFIC_KOSRAE("Pacific/Kosrae"),
        PACIFIC_KWAJALEIN("Pacific/Kwajalein"),
        PACIFIC_MAJURO("Pacific/Majuro"),
        PACIFIC_MARQUESAS("Pacific/Marquesas"),
        PACIFIC_NAURU("Pacific/Nauru"),
        PACIFIC_NIUE("Pacific/Niue"),
        PACIFIC_NORFOLK("Pacific/Norfolk"),
        PACIFIC_NOUMEA("Pacific/Noumea"),
        PACIFIC_PAGO_PAGO("Pacific/Pago_Pago"),
        PACIFIC_PALAU("Pacific/Palau"),
        PACIFIC_PITCAIRN("Pacific/Pitcairn"),
        PACIFIC_POHNPEI("Pacific/Pohnpei"),
        PACIFIC_PORT_MORESBY("Pacific/Port_Moresby"),
        PACIFIC_RAROTONGA("Pacific/Rarotonga"),
        PACIFIC_TAHITI("Pacific/Tahiti"),
        PACIFIC_TARAWA("Pacific/Tarawa"),
        PACIFIC_TONGATAPU("Pacific/Tongatapu"),
        PACIFIC_WAKE("Pacific/Wake"),
        PACIFIC_WALLIS("Pacific/Wallis"),
        PST_8_PDT("PST8PDT"),
        WET("WET");

        private final String value;
        private static final Map<String, Timezone> CONSTANTS;

        private Timezone(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Timezone fromValue(String value) {
            Timezone constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Timezone>();
            for (Timezone c : Timezone.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

