/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v3_0_RC.station_information;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum RentalMethod {
    KEY("key"),
    CREDITCARD("creditcard"),
    PAYPASS("paypass"),
    APPLEPAY("applepay"),
    ANDROIDPAY("androidpay"),
    TRANSITCARD("transitcard"),
    ACCOUNTNUMBER("accountnumber"),
    PHONE("phone");

    private final String value;
    private static final Map<String, RentalMethod> CONSTANTS;

    private RentalMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static RentalMethod fromValue(String value) {
        RentalMethod constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, RentalMethod>();
        for (RentalMethod c : RentalMethod.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

