/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v3_0_RC2.gbfs_versions;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "url"})
public class GBFSVersion
implements Serializable {
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="The semantic version of the feed in the form X.Y")
    private Version version;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="URL of the corresponding gbfs.json endpoint")
    private String url;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = -8127445686350467874L;

    @JsonProperty(value="version")
    public Version getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Version version) {
        this.version = version;
    }

    public GBFSVersion withVersion(Version version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    public GBFSVersion withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSVersion withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSVersion.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSVersion)) {
            return false;
        }
        GBFSVersion rhs = (GBFSVersion)other;
        return (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.version == rhs.version || this.version != null && this.version.equals((Object)rhs.version)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url));
    }

    public static enum Version {
        _1_0("1.0"),
        _1_1("1.1"),
        _2_0("2.0"),
        _2_1("2.1"),
        _2_2("2.2"),
        _2_3("2.3"),
        _3_0_RC("3.0-RC"),
        _3_0_RC_2("3.0-RC2"),
        _3_0("3.0");

        private final String value;
        private static final Map<String, Version> CONSTANTS;

        private Version(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Version fromValue(String value) {
            Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Version>();
            for (Version c : Version.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

