/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v2_2.system_information;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.entur.gbfs.v2_2.system_information.GBFSData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"last_updated", "ttl", "version", "data"})
public class GBFSSystemInformation
implements Serializable {
    @JsonProperty(value="last_updated")
    @JsonPropertyDescription(value="Last time the data in the feed was updated in POSIX time.")
    private Integer lastUpdated;
    @JsonProperty(value="ttl")
    @JsonPropertyDescription(value="Number of seconds before the data in the feed will be updated again (0 if the data should always be refreshed).")
    private Integer ttl;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="GBFS version number to which the feed conforms, according to the versioning framework (added in v1.1).")
    private Version version;
    @JsonProperty(value="data")
    @JsonPropertyDescription(value="Response data in the form of name:value pairs.")
    private GBFSData data;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private static final long serialVersionUID = 2559332396818245129L;

    @JsonProperty(value="last_updated")
    public Integer getLastUpdated() {
        return this.lastUpdated;
    }

    @JsonProperty(value="last_updated")
    public void setLastUpdated(Integer lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="ttl")
    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    @JsonProperty(value="version")
    public Version getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Version version) {
        this.version = version;
    }

    @JsonProperty(value="data")
    public GBFSData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(GBFSData data) {
        this.data = data;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSSystemInformation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(this.lastUpdated == null ? "<null>" : this.lastUpdated);
        sb.append(',');
        sb.append("ttl");
        sb.append('=');
        sb.append(this.ttl == null ? "<null>" : this.ttl);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(this.data == null ? "<null>" : this.data);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.lastUpdated == null ? 0 : this.lastUpdated.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        result = result * 31 + (this.ttl == null ? 0 : this.ttl.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSSystemInformation)) {
            return false;
        }
        GBFSSystemInformation rhs = (GBFSSystemInformation)other;
        return (this.lastUpdated == rhs.lastUpdated || this.lastUpdated != null && this.lastUpdated.equals(rhs.lastUpdated)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.data == rhs.data || this.data != null && this.data.equals(rhs.data)) && (this.ttl == rhs.ttl || this.ttl != null && this.ttl.equals(rhs.ttl)) && (this.version == rhs.version || this.version != null && this.version.equals((Object)rhs.version));
    }

    public static enum Version {
        _1_1_RC("1.1-RC"),
        _1_1("1.1"),
        _2_0("2.0"),
        _2_1_RC("2.1-RC"),
        _2_1_RC_2("2.1-RC2"),
        _2_1("2.1"),
        _2_2("2.2");

        private final String value;
        private static final Map<String, Version> CONSTANTS;

        private Version(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Version fromValue(String value) {
            Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Version>();
            for (Version c : Version.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

