/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v2_2.station_status;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"bike_id", "is_reserved", "is_disabled", "vehicle_type_id", "current_range_meters"})
public class GBFSVehicle
implements Serializable {
    @JsonProperty(value="bike_id")
    @JsonPropertyDescription(value="Rotated identifier of a vehicle (added in v2.1-RC).")
    private String bikeId;
    @JsonProperty(value="is_reserved")
    @JsonPropertyDescription(value="Is the vehicle currently reserved for someone else? (added in v2.1-RC)")
    private Boolean isReserved;
    @JsonProperty(value="is_disabled")
    @JsonPropertyDescription(value="Is the vehicle currently disabled (broken)? (added in v2.1-RC)")
    private Boolean isDisabled;
    @JsonProperty(value="vehicle_type_id")
    @JsonPropertyDescription(value="The vehicle_type_id of this vehicle as described in vehicle_types.json (added in v2.1-RC).")
    private String vehicleTypeId;
    @JsonProperty(value="current_range_meters")
    @JsonPropertyDescription(value="The furthest distance in meters that the vehicle can travel without recharging or refueling with the vehicle's current charge or fuel (added in v2.1-RC).")
    private Double currentRangeMeters;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private static final long serialVersionUID = -8264138815603369239L;

    @JsonProperty(value="bike_id")
    public String getBikeId() {
        return this.bikeId;
    }

    @JsonProperty(value="bike_id")
    public void setBikeId(String bikeId) {
        this.bikeId = bikeId;
    }

    @JsonProperty(value="is_reserved")
    public Boolean getIsReserved() {
        return this.isReserved;
    }

    @JsonProperty(value="is_reserved")
    public void setIsReserved(Boolean isReserved) {
        this.isReserved = isReserved;
    }

    @JsonProperty(value="is_disabled")
    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    @JsonProperty(value="is_disabled")
    public void setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    @JsonProperty(value="vehicle_type_id")
    public String getVehicleTypeId() {
        return this.vehicleTypeId;
    }

    @JsonProperty(value="vehicle_type_id")
    public void setVehicleTypeId(String vehicleTypeId) {
        this.vehicleTypeId = vehicleTypeId;
    }

    @JsonProperty(value="current_range_meters")
    public Double getCurrentRangeMeters() {
        return this.currentRangeMeters;
    }

    @JsonProperty(value="current_range_meters")
    public void setCurrentRangeMeters(Double currentRangeMeters) {
        this.currentRangeMeters = currentRangeMeters;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSVehicle.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("bikeId");
        sb.append('=');
        sb.append(this.bikeId == null ? "<null>" : this.bikeId);
        sb.append(',');
        sb.append("isReserved");
        sb.append('=');
        sb.append(this.isReserved == null ? "<null>" : this.isReserved);
        sb.append(',');
        sb.append("isDisabled");
        sb.append('=');
        sb.append(this.isDisabled == null ? "<null>" : this.isDisabled);
        sb.append(',');
        sb.append("vehicleTypeId");
        sb.append('=');
        sb.append(this.vehicleTypeId == null ? "<null>" : this.vehicleTypeId);
        sb.append(',');
        sb.append("currentRangeMeters");
        sb.append('=');
        sb.append(this.currentRangeMeters == null ? "<null>" : this.currentRangeMeters);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.vehicleTypeId == null ? 0 : this.vehicleTypeId.hashCode());
        result = result * 31 + (this.isReserved == null ? 0 : this.isReserved.hashCode());
        result = result * 31 + (this.currentRangeMeters == null ? 0 : this.currentRangeMeters.hashCode());
        result = result * 31 + (this.bikeId == null ? 0 : this.bikeId.hashCode());
        result = result * 31 + (this.isDisabled == null ? 0 : this.isDisabled.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSVehicle)) {
            return false;
        }
        GBFSVehicle rhs = (GBFSVehicle)other;
        return (this.vehicleTypeId == rhs.vehicleTypeId || this.vehicleTypeId != null && this.vehicleTypeId.equals(rhs.vehicleTypeId)) && (this.isReserved == rhs.isReserved || this.isReserved != null && this.isReserved.equals(rhs.isReserved)) && (this.currentRangeMeters == rhs.currentRangeMeters || this.currentRangeMeters != null && this.currentRangeMeters.equals(rhs.currentRangeMeters)) && (this.bikeId == rhs.bikeId || this.bikeId != null && this.bikeId.equals(rhs.bikeId)) && (this.isDisabled == rhs.isDisabled || this.isDisabled != null && this.isDisabled.equals(rhs.isDisabled)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }
}

