/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v2_2.station_status;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.entur.gbfs.v2_2.station_status.GBFSVehicle;
import org.entur.gbfs.v2_2.station_status.GBFSVehicleDocksAvailable;
import org.entur.gbfs.v2_2.station_status.GBFSVehicleTypesAvailable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"station_id", "num_bikes_available", "vehicle_types_available", "num_bikes_disabled", "num_docks_available", "num_docks_disabled", "is_installed", "is_renting", "is_returning", "last_reported", "vehicle_docks_available", "vehicles"})
public class GBFSStation
implements Serializable {
    @JsonProperty(value="station_id")
    @JsonPropertyDescription(value="Identifier of a station.")
    private String stationId;
    @JsonProperty(value="num_bikes_available")
    @JsonPropertyDescription(value="Number of vehicles of any type physically available for rental at the station.")
    private Double numBikesAvailable;
    @JsonProperty(value="vehicle_types_available")
    @JsonPropertyDescription(value="Array of objects displaying the total number of each vehicle type at the station (added in v2.1-RC).")
    private List<GBFSVehicleTypesAvailable> vehicleTypesAvailable = new ArrayList<GBFSVehicleTypesAvailable>();
    @JsonProperty(value="num_bikes_disabled")
    @JsonPropertyDescription(value="Number of disabled vehicles of any type at the station.")
    private Double numBikesDisabled;
    @JsonProperty(value="num_docks_available")
    @JsonPropertyDescription(value="Number of functional docks physically at the station.")
    private Double numDocksAvailable;
    @JsonProperty(value="num_docks_disabled")
    @JsonPropertyDescription(value="Number of empty but disabled docks at the station.")
    private Double numDocksDisabled;
    @JsonProperty(value="is_installed")
    @JsonPropertyDescription(value="Is the station currently on the street?")
    private Boolean isInstalled;
    @JsonProperty(value="is_renting")
    @JsonPropertyDescription(value="Is the station currently renting vehicles?")
    private Boolean isRenting;
    @JsonProperty(value="is_returning")
    @JsonPropertyDescription(value="Is the station accepting vehicle returns?")
    private Boolean isReturning;
    @JsonProperty(value="last_reported")
    @JsonPropertyDescription(value="The last time this station reported its status to the operator's backend in POSIX time.")
    private Double lastReported;
    @JsonProperty(value="vehicle_docks_available")
    @JsonPropertyDescription(value="Object displaying available docks by vehicle type (added in v2.1-RC).")
    private List<GBFSVehicleDocksAvailable> vehicleDocksAvailable = new ArrayList<GBFSVehicleDocksAvailable>();
    @JsonProperty(value="vehicles")
    @JsonPropertyDescription(value="Array of objects containing data about a specific vehicle that is present at the docking station (added in v2.1-RC).")
    private List<GBFSVehicle> vehicles = new ArrayList<GBFSVehicle>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private static final long serialVersionUID = -8763367138742206130L;

    @JsonProperty(value="station_id")
    public String getStationId() {
        return this.stationId;
    }

    @JsonProperty(value="station_id")
    public void setStationId(String stationId) {
        this.stationId = stationId;
    }

    @JsonProperty(value="num_bikes_available")
    public Double getNumBikesAvailable() {
        return this.numBikesAvailable;
    }

    @JsonProperty(value="num_bikes_available")
    public void setNumBikesAvailable(Double numBikesAvailable) {
        this.numBikesAvailable = numBikesAvailable;
    }

    @JsonProperty(value="vehicle_types_available")
    public List<GBFSVehicleTypesAvailable> getVehicleTypesAvailable() {
        return this.vehicleTypesAvailable;
    }

    @JsonProperty(value="vehicle_types_available")
    public void setVehicleTypesAvailable(List<GBFSVehicleTypesAvailable> vehicleTypesAvailable) {
        this.vehicleTypesAvailable = vehicleTypesAvailable;
    }

    @JsonProperty(value="num_bikes_disabled")
    public Double getNumBikesDisabled() {
        return this.numBikesDisabled;
    }

    @JsonProperty(value="num_bikes_disabled")
    public void setNumBikesDisabled(Double numBikesDisabled) {
        this.numBikesDisabled = numBikesDisabled;
    }

    @JsonProperty(value="num_docks_available")
    public Double getNumDocksAvailable() {
        return this.numDocksAvailable;
    }

    @JsonProperty(value="num_docks_available")
    public void setNumDocksAvailable(Double numDocksAvailable) {
        this.numDocksAvailable = numDocksAvailable;
    }

    @JsonProperty(value="num_docks_disabled")
    public Double getNumDocksDisabled() {
        return this.numDocksDisabled;
    }

    @JsonProperty(value="num_docks_disabled")
    public void setNumDocksDisabled(Double numDocksDisabled) {
        this.numDocksDisabled = numDocksDisabled;
    }

    @JsonProperty(value="is_installed")
    public Boolean getIsInstalled() {
        return this.isInstalled;
    }

    @JsonProperty(value="is_installed")
    public void setIsInstalled(Boolean isInstalled) {
        this.isInstalled = isInstalled;
    }

    @JsonProperty(value="is_renting")
    public Boolean getIsRenting() {
        return this.isRenting;
    }

    @JsonProperty(value="is_renting")
    public void setIsRenting(Boolean isRenting) {
        this.isRenting = isRenting;
    }

    @JsonProperty(value="is_returning")
    public Boolean getIsReturning() {
        return this.isReturning;
    }

    @JsonProperty(value="is_returning")
    public void setIsReturning(Boolean isReturning) {
        this.isReturning = isReturning;
    }

    @JsonProperty(value="last_reported")
    public Double getLastReported() {
        return this.lastReported;
    }

    @JsonProperty(value="last_reported")
    public void setLastReported(Double lastReported) {
        this.lastReported = lastReported;
    }

    @JsonProperty(value="vehicle_docks_available")
    public List<GBFSVehicleDocksAvailable> getVehicleDocksAvailable() {
        return this.vehicleDocksAvailable;
    }

    @JsonProperty(value="vehicle_docks_available")
    public void setVehicleDocksAvailable(List<GBFSVehicleDocksAvailable> vehicleDocksAvailable) {
        this.vehicleDocksAvailable = vehicleDocksAvailable;
    }

    @JsonProperty(value="vehicles")
    public List<GBFSVehicle> getVehicles() {
        return this.vehicles;
    }

    @JsonProperty(value="vehicles")
    public void setVehicles(List<GBFSVehicle> vehicles) {
        this.vehicles = vehicles;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSStation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("stationId");
        sb.append('=');
        sb.append(this.stationId == null ? "<null>" : this.stationId);
        sb.append(',');
        sb.append("numBikesAvailable");
        sb.append('=');
        sb.append(this.numBikesAvailable == null ? "<null>" : this.numBikesAvailable);
        sb.append(',');
        sb.append("vehicleTypesAvailable");
        sb.append('=');
        sb.append(this.vehicleTypesAvailable == null ? "<null>" : this.vehicleTypesAvailable);
        sb.append(',');
        sb.append("numBikesDisabled");
        sb.append('=');
        sb.append(this.numBikesDisabled == null ? "<null>" : this.numBikesDisabled);
        sb.append(',');
        sb.append("numDocksAvailable");
        sb.append('=');
        sb.append(this.numDocksAvailable == null ? "<null>" : this.numDocksAvailable);
        sb.append(',');
        sb.append("numDocksDisabled");
        sb.append('=');
        sb.append(this.numDocksDisabled == null ? "<null>" : this.numDocksDisabled);
        sb.append(',');
        sb.append("isInstalled");
        sb.append('=');
        sb.append(this.isInstalled == null ? "<null>" : this.isInstalled);
        sb.append(',');
        sb.append("isRenting");
        sb.append('=');
        sb.append(this.isRenting == null ? "<null>" : this.isRenting);
        sb.append(',');
        sb.append("isReturning");
        sb.append('=');
        sb.append(this.isReturning == null ? "<null>" : this.isReturning);
        sb.append(',');
        sb.append("lastReported");
        sb.append('=');
        sb.append(this.lastReported == null ? "<null>" : this.lastReported);
        sb.append(',');
        sb.append("vehicleDocksAvailable");
        sb.append('=');
        sb.append(this.vehicleDocksAvailable == null ? "<null>" : this.vehicleDocksAvailable);
        sb.append(',');
        sb.append("vehicles");
        sb.append('=');
        sb.append(this.vehicles == null ? "<null>" : this.vehicles);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.numDocksAvailable == null ? 0 : this.numDocksAvailable.hashCode());
        result = result * 31 + (this.isInstalled == null ? 0 : this.isInstalled.hashCode());
        result = result * 31 + (this.isReturning == null ? 0 : this.isReturning.hashCode());
        result = result * 31 + (this.vehicles == null ? 0 : this.vehicles.hashCode());
        result = result * 31 + (this.isRenting == null ? 0 : this.isRenting.hashCode());
        result = result * 31 + (this.numDocksDisabled == null ? 0 : this.numDocksDisabled.hashCode());
        result = result * 31 + (this.vehicleTypesAvailable == null ? 0 : this.vehicleTypesAvailable.hashCode());
        result = result * 31 + (this.numBikesAvailable == null ? 0 : this.numBikesAvailable.hashCode());
        result = result * 31 + (this.lastReported == null ? 0 : this.lastReported.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.vehicleDocksAvailable == null ? 0 : this.vehicleDocksAvailable.hashCode());
        result = result * 31 + (this.stationId == null ? 0 : this.stationId.hashCode());
        result = result * 31 + (this.numBikesDisabled == null ? 0 : this.numBikesDisabled.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSStation)) {
            return false;
        }
        GBFSStation rhs = (GBFSStation)other;
        return (this.numDocksAvailable == rhs.numDocksAvailable || this.numDocksAvailable != null && this.numDocksAvailable.equals(rhs.numDocksAvailable)) && (this.isInstalled == rhs.isInstalled || this.isInstalled != null && this.isInstalled.equals(rhs.isInstalled)) && (this.isReturning == rhs.isReturning || this.isReturning != null && this.isReturning.equals(rhs.isReturning)) && (this.vehicles == rhs.vehicles || this.vehicles != null && this.vehicles.equals(rhs.vehicles)) && (this.isRenting == rhs.isRenting || this.isRenting != null && this.isRenting.equals(rhs.isRenting)) && (this.numDocksDisabled == rhs.numDocksDisabled || this.numDocksDisabled != null && this.numDocksDisabled.equals(rhs.numDocksDisabled)) && (this.vehicleTypesAvailable == rhs.vehicleTypesAvailable || this.vehicleTypesAvailable != null && this.vehicleTypesAvailable.equals(rhs.vehicleTypesAvailable)) && (this.numBikesAvailable == rhs.numBikesAvailable || this.numBikesAvailable != null && this.numBikesAvailable.equals(rhs.numBikesAvailable)) && (this.lastReported == rhs.lastReported || this.lastReported != null && this.lastReported.equals(rhs.lastReported)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.vehicleDocksAvailable == rhs.vehicleDocksAvailable || this.vehicleDocksAvailable != null && this.vehicleDocksAvailable.equals(rhs.vehicleDocksAvailable)) && (this.stationId == rhs.stationId || this.stationId != null && this.stationId.equals(rhs.stationId)) && (this.numBikesDisabled == rhs.numBikesDisabled || this.numBikesDisabled != null && this.numBikesDisabled.equals(rhs.numBikesDisabled));
    }
}

