/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v2_2.geofencing_zones;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"vehicle_type_id", "ride_allowed", "ride_through_allowed", "maximum_speed_kph"})
public class GBFSRule
implements Serializable {
    @JsonProperty(value="vehicle_type_id")
    @JsonPropertyDescription(value="Array of vehicle type IDs for which these restrictions apply.")
    private List<String> vehicleTypeId = new ArrayList<String>();
    @JsonProperty(value="ride_allowed")
    @JsonPropertyDescription(value="Is the undocked ride allowed to stat and end in this zone?")
    private Boolean rideAllowed;
    @JsonProperty(value="ride_through_allowed")
    @JsonPropertyDescription(value="Is the ride allowed to travel through this zone?")
    private Boolean rideThroughAllowed;
    @JsonProperty(value="maximum_speed_kph")
    @JsonPropertyDescription(value="What is the maximum speed allowed, in kilometers per hour?")
    private Double maximumSpeedKph;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private static final long serialVersionUID = 1649301677772151197L;

    @JsonProperty(value="vehicle_type_id")
    public List<String> getVehicleTypeId() {
        return this.vehicleTypeId;
    }

    @JsonProperty(value="vehicle_type_id")
    public void setVehicleTypeId(List<String> vehicleTypeId) {
        this.vehicleTypeId = vehicleTypeId;
    }

    @JsonProperty(value="ride_allowed")
    public Boolean getRideAllowed() {
        return this.rideAllowed;
    }

    @JsonProperty(value="ride_allowed")
    public void setRideAllowed(Boolean rideAllowed) {
        this.rideAllowed = rideAllowed;
    }

    @JsonProperty(value="ride_through_allowed")
    public Boolean getRideThroughAllowed() {
        return this.rideThroughAllowed;
    }

    @JsonProperty(value="ride_through_allowed")
    public void setRideThroughAllowed(Boolean rideThroughAllowed) {
        this.rideThroughAllowed = rideThroughAllowed;
    }

    @JsonProperty(value="maximum_speed_kph")
    public Double getMaximumSpeedKph() {
        return this.maximumSpeedKph;
    }

    @JsonProperty(value="maximum_speed_kph")
    public void setMaximumSpeedKph(Double maximumSpeedKph) {
        this.maximumSpeedKph = maximumSpeedKph;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSRule.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("vehicleTypeId");
        sb.append('=');
        sb.append(this.vehicleTypeId == null ? "<null>" : this.vehicleTypeId);
        sb.append(',');
        sb.append("rideAllowed");
        sb.append('=');
        sb.append(this.rideAllowed == null ? "<null>" : this.rideAllowed);
        sb.append(',');
        sb.append("rideThroughAllowed");
        sb.append('=');
        sb.append(this.rideThroughAllowed == null ? "<null>" : this.rideThroughAllowed);
        sb.append(',');
        sb.append("maximumSpeedKph");
        sb.append('=');
        sb.append(this.maximumSpeedKph == null ? "<null>" : this.maximumSpeedKph);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.maximumSpeedKph == null ? 0 : this.maximumSpeedKph.hashCode());
        result = result * 31 + (this.vehicleTypeId == null ? 0 : this.vehicleTypeId.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.rideThroughAllowed == null ? 0 : this.rideThroughAllowed.hashCode());
        result = result * 31 + (this.rideAllowed == null ? 0 : this.rideAllowed.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSRule)) {
            return false;
        }
        GBFSRule rhs = (GBFSRule)other;
        return (this.maximumSpeedKph == rhs.maximumSpeedKph || this.maximumSpeedKph != null && this.maximumSpeedKph.equals(rhs.maximumSpeedKph)) && (this.vehicleTypeId == rhs.vehicleTypeId || this.vehicleTypeId != null && this.vehicleTypeId.equals(rhs.vehicleTypeId)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.rideThroughAllowed == rhs.rideThroughAllowed || this.rideThroughAllowed != null && this.rideThroughAllowed.equals(rhs.rideThroughAllowed)) && (this.rideAllowed == rhs.rideAllowed || this.rideAllowed != null && this.rideAllowed.equals(rhs.rideAllowed));
    }
}

