/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v2_2.geofencing_zones;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.entur.gbfs.v2_2.geofencing_zones.GBFSRule;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "start", "end", "rules"})
public class GBFSProperties
implements Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Public name of the geofencing zone.")
    private String name;
    @JsonProperty(value="start")
    @JsonPropertyDescription(value="Start time of the geofencing zone in POSIX time.")
    private Double start;
    @JsonProperty(value="end")
    @JsonPropertyDescription(value="End time of the geofencing zone in POSIX time.")
    private Double end;
    @JsonProperty(value="rules")
    @JsonPropertyDescription(value="Array that contains one object per rule.")
    private List<GBFSRule> rules = new ArrayList<GBFSRule>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private static final long serialVersionUID = 1637485991730752573L;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="start")
    public Double getStart() {
        return this.start;
    }

    @JsonProperty(value="start")
    public void setStart(Double start) {
        this.start = start;
    }

    @JsonProperty(value="end")
    public Double getEnd() {
        return this.end;
    }

    @JsonProperty(value="end")
    public void setEnd(Double end) {
        this.end = end;
    }

    @JsonProperty(value="rules")
    public List<GBFSRule> getRules() {
        return this.rules;
    }

    @JsonProperty(value="rules")
    public void setRules(List<GBFSRule> rules) {
        this.rules = rules;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSProperties.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("start");
        sb.append('=');
        sb.append(this.start == null ? "<null>" : this.start);
        sb.append(',');
        sb.append("end");
        sb.append('=');
        sb.append(this.end == null ? "<null>" : this.end);
        sb.append(',');
        sb.append("rules");
        sb.append('=');
        sb.append(this.rules == null ? "<null>" : this.rules);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.start == null ? 0 : this.start.hashCode());
        result = result * 31 + (this.end == null ? 0 : this.end.hashCode());
        result = result * 31 + (this.rules == null ? 0 : this.rules.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSProperties)) {
            return false;
        }
        GBFSProperties rhs = (GBFSProperties)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.start == rhs.start || this.start != null && this.start.equals(rhs.start)) && (this.end == rhs.end || this.end != null && this.end.equals(rhs.end)) && (this.rules == rhs.rules || this.rules != null && this.rules.equals(rhs.rules)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }
}

