/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v2_2.free_bike_status;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.entur.gbfs.v2_2.free_bike_status.GBFSRentalUris;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"bike_id", "lat", "lon", "is_reserved", "is_disabled", "rental_uris", "vehicle_type_id", "last_reported", "current_range_meters", "station_id", "pricing_plan_id"})
public class GBFSBike
implements Serializable {
    @JsonProperty(value="bike_id")
    @JsonPropertyDescription(value="Rotating (as of v2.0) identifier of a vehicle.")
    private String bikeId;
    @JsonProperty(value="lat")
    @JsonPropertyDescription(value="The latitude of the vehicle.")
    private Double lat;
    @JsonProperty(value="lon")
    @JsonPropertyDescription(value="The longitude of the vehicle.")
    private Double lon;
    @JsonProperty(value="is_reserved")
    @JsonPropertyDescription(value="Is the vehicle currently reserved?")
    private Boolean isReserved;
    @JsonProperty(value="is_disabled")
    @JsonPropertyDescription(value="Is the vehicle currently disabled (broken)?")
    private Boolean isDisabled;
    @JsonProperty(value="rental_uris")
    @JsonPropertyDescription(value="Contains rental uris for Android, iOS, and web in the android, ios, and web fields (added in v1.1).")
    private GBFSRentalUris rentalUris;
    @JsonProperty(value="vehicle_type_id")
    @JsonPropertyDescription(value="The vehicle_type_id of this vehicle (added in v2.1-RC).")
    private String vehicleTypeId;
    @JsonProperty(value="last_reported")
    @JsonPropertyDescription(value="The last time this vehicle reported its status to the operator's backend in POSIX time (added in v2.1-RC).")
    private Double lastReported;
    @JsonProperty(value="current_range_meters")
    @JsonPropertyDescription(value="The furthest distance in meters that the vehicle can travel without recharging or refueling with the vehicle's current charge or fuel (added in v2.1-RC).")
    private Double currentRangeMeters;
    @JsonProperty(value="station_id")
    @JsonPropertyDescription(value="Identifier referencing the station_id if the vehicle is currently at a station (added in v2.1-RC2).")
    private String stationId;
    @JsonProperty(value="pricing_plan_id")
    @JsonPropertyDescription(value="The plan_id of the pricing plan this vehicle is eligible for (added in v2.1-RC2).")
    private String pricingPlanId;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private static final long serialVersionUID = 3252641205034944081L;

    @JsonProperty(value="bike_id")
    public String getBikeId() {
        return this.bikeId;
    }

    @JsonProperty(value="bike_id")
    public void setBikeId(String bikeId) {
        this.bikeId = bikeId;
    }

    @JsonProperty(value="lat")
    public Double getLat() {
        return this.lat;
    }

    @JsonProperty(value="lat")
    public void setLat(Double lat) {
        this.lat = lat;
    }

    @JsonProperty(value="lon")
    public Double getLon() {
        return this.lon;
    }

    @JsonProperty(value="lon")
    public void setLon(Double lon) {
        this.lon = lon;
    }

    @JsonProperty(value="is_reserved")
    public Boolean getIsReserved() {
        return this.isReserved;
    }

    @JsonProperty(value="is_reserved")
    public void setIsReserved(Boolean isReserved) {
        this.isReserved = isReserved;
    }

    @JsonProperty(value="is_disabled")
    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    @JsonProperty(value="is_disabled")
    public void setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    @JsonProperty(value="rental_uris")
    public GBFSRentalUris getRentalUris() {
        return this.rentalUris;
    }

    @JsonProperty(value="rental_uris")
    public void setRentalUris(GBFSRentalUris rentalUris) {
        this.rentalUris = rentalUris;
    }

    @JsonProperty(value="vehicle_type_id")
    public String getVehicleTypeId() {
        return this.vehicleTypeId;
    }

    @JsonProperty(value="vehicle_type_id")
    public void setVehicleTypeId(String vehicleTypeId) {
        this.vehicleTypeId = vehicleTypeId;
    }

    @JsonProperty(value="last_reported")
    public Double getLastReported() {
        return this.lastReported;
    }

    @JsonProperty(value="last_reported")
    public void setLastReported(Double lastReported) {
        this.lastReported = lastReported;
    }

    @JsonProperty(value="current_range_meters")
    public Double getCurrentRangeMeters() {
        return this.currentRangeMeters;
    }

    @JsonProperty(value="current_range_meters")
    public void setCurrentRangeMeters(Double currentRangeMeters) {
        this.currentRangeMeters = currentRangeMeters;
    }

    @JsonProperty(value="station_id")
    public String getStationId() {
        return this.stationId;
    }

    @JsonProperty(value="station_id")
    public void setStationId(String stationId) {
        this.stationId = stationId;
    }

    @JsonProperty(value="pricing_plan_id")
    public String getPricingPlanId() {
        return this.pricingPlanId;
    }

    @JsonProperty(value="pricing_plan_id")
    public void setPricingPlanId(String pricingPlanId) {
        this.pricingPlanId = pricingPlanId;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSBike.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("bikeId");
        sb.append('=');
        sb.append(this.bikeId == null ? "<null>" : this.bikeId);
        sb.append(',');
        sb.append("lat");
        sb.append('=');
        sb.append(this.lat == null ? "<null>" : this.lat);
        sb.append(',');
        sb.append("lon");
        sb.append('=');
        sb.append(this.lon == null ? "<null>" : this.lon);
        sb.append(',');
        sb.append("isReserved");
        sb.append('=');
        sb.append(this.isReserved == null ? "<null>" : this.isReserved);
        sb.append(',');
        sb.append("isDisabled");
        sb.append('=');
        sb.append(this.isDisabled == null ? "<null>" : this.isDisabled);
        sb.append(',');
        sb.append("rentalUris");
        sb.append('=');
        sb.append(this.rentalUris == null ? "<null>" : this.rentalUris);
        sb.append(',');
        sb.append("vehicleTypeId");
        sb.append('=');
        sb.append(this.vehicleTypeId == null ? "<null>" : this.vehicleTypeId);
        sb.append(',');
        sb.append("lastReported");
        sb.append('=');
        sb.append(this.lastReported == null ? "<null>" : this.lastReported);
        sb.append(',');
        sb.append("currentRangeMeters");
        sb.append('=');
        sb.append(this.currentRangeMeters == null ? "<null>" : this.currentRangeMeters);
        sb.append(',');
        sb.append("stationId");
        sb.append('=');
        sb.append(this.stationId == null ? "<null>" : this.stationId);
        sb.append(',');
        sb.append("pricingPlanId");
        sb.append('=');
        sb.append(this.pricingPlanId == null ? "<null>" : this.pricingPlanId);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.vehicleTypeId == null ? 0 : this.vehicleTypeId.hashCode());
        result = result * 31 + (this.rentalUris == null ? 0 : this.rentalUris.hashCode());
        result = result * 31 + (this.isReserved == null ? 0 : this.isReserved.hashCode());
        result = result * 31 + (this.bikeId == null ? 0 : this.bikeId.hashCode());
        result = result * 31 + (this.lon == null ? 0 : this.lon.hashCode());
        result = result * 31 + (this.pricingPlanId == null ? 0 : this.pricingPlanId.hashCode());
        result = result * 31 + (this.lastReported == null ? 0 : this.lastReported.hashCode());
        result = result * 31 + (this.currentRangeMeters == null ? 0 : this.currentRangeMeters.hashCode());
        result = result * 31 + (this.isDisabled == null ? 0 : this.isDisabled.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.lat == null ? 0 : this.lat.hashCode());
        result = result * 31 + (this.stationId == null ? 0 : this.stationId.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSBike)) {
            return false;
        }
        GBFSBike rhs = (GBFSBike)other;
        return (this.vehicleTypeId == rhs.vehicleTypeId || this.vehicleTypeId != null && this.vehicleTypeId.equals(rhs.vehicleTypeId)) && (this.rentalUris == rhs.rentalUris || this.rentalUris != null && this.rentalUris.equals(rhs.rentalUris)) && (this.isReserved == rhs.isReserved || this.isReserved != null && this.isReserved.equals(rhs.isReserved)) && (this.bikeId == rhs.bikeId || this.bikeId != null && this.bikeId.equals(rhs.bikeId)) && (this.lon == rhs.lon || this.lon != null && this.lon.equals(rhs.lon)) && (this.pricingPlanId == rhs.pricingPlanId || this.pricingPlanId != null && this.pricingPlanId.equals(rhs.pricingPlanId)) && (this.lastReported == rhs.lastReported || this.lastReported != null && this.lastReported.equals(rhs.lastReported)) && (this.currentRangeMeters == rhs.currentRangeMeters || this.currentRangeMeters != null && this.currentRangeMeters.equals(rhs.currentRangeMeters)) && (this.isDisabled == rhs.isDisabled || this.isDisabled != null && this.isDisabled.equals(rhs.isDisabled)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.lat == rhs.lat || this.lat != null && this.lat.equals(rhs.lat)) && (this.stationId == rhs.stationId || this.stationId != null && this.stationId.equals(rhs.stationId));
    }
}

