/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.rocketmq.message;

import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.commanding.CommandOptions;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.messaging.ReplyMessage;
import org.enodeframework.queue.MessageTypeCode;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.SendMessageResult;
import org.enodeframework.queue.SendReplyService;
import org.enodeframework.queue.reply.GenericReplyMessage;
import org.enodeframework.rocketmq.message.RocketMQProducerHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/enodeframework/rocketmq/message/RocketMQSendReplyService;", "Lorg/enodeframework/queue/SendReplyService;", "producerHolder", "Lorg/enodeframework/rocketmq/message/RocketMQProducerHolder;", "commandOptions", "Lorg/enodeframework/commanding/CommandOptions;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "(Lorg/enodeframework/rocketmq/message/RocketMQProducerHolder;Lorg/enodeframework/commanding/CommandOptions;Lorg/enodeframework/common/serializing/SerializeService;)V", "buildQueueMessage", "Lorg/enodeframework/queue/QueueMessage;", "replyMessage", "Lorg/enodeframework/messaging/ReplyMessage;", "send", "Ljava/util/concurrent/CompletableFuture;", "Lorg/enodeframework/queue/SendMessageResult;", "message", "enode-rocketmq"})
public final class RocketMQSendReplyService
implements SendReplyService {
    @NotNull
    private final RocketMQProducerHolder producerHolder;
    @NotNull
    private final CommandOptions commandOptions;
    @NotNull
    private final SerializeService serializeService;

    public RocketMQSendReplyService(@NotNull RocketMQProducerHolder producerHolder, @NotNull CommandOptions commandOptions, @NotNull SerializeService serializeService) {
        Intrinsics.checkNotNullParameter((Object)producerHolder, (String)"producerHolder");
        Intrinsics.checkNotNullParameter((Object)commandOptions, (String)"commandOptions");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        this.producerHolder = producerHolder;
        this.commandOptions = commandOptions;
        this.serializeService = serializeService;
    }

    @NotNull
    public CompletableFuture<SendMessageResult> send(@NotNull ReplyMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.producerHolder.send(this.buildQueueMessage(message));
    }

    private final QueueMessage buildQueueMessage(ReplyMessage replyMessage) {
        GenericReplyMessage message = replyMessage.asGenericReplyMessage();
        QueueMessage queueMessage = replyMessage.asPartQueueMessage();
        queueMessage.setTopic(this.commandOptions.getReplyTopic());
        queueMessage.setTag(replyMessage.getAddress());
        queueMessage.setBody(this.serializeService.serializeBytes((Object)message));
        queueMessage.setType(MessageTypeCode.ReplyMessage.getValue());
        return queueMessage;
    }
}

