/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.rocketmq.message;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;
import org.enodeframework.queue.MessageHandler;
import org.enodeframework.queue.MessageHandlerHolder;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.rocketmq.message.RocketMQMessageListenerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/enodeframework/rocketmq/message/RocketMQMessageOrderlyListener;", "Lorg/apache/rocketmq/client/consumer/listener/MessageListenerOrderly;", "messageHandlerHolder", "Lorg/enodeframework/queue/MessageHandlerHolder;", "(Lorg/enodeframework/queue/MessageHandlerHolder;)V", "consumeMessage", "Lorg/apache/rocketmq/client/consumer/listener/ConsumeOrderlyStatus;", "msgs", "", "Lorg/apache/rocketmq/common/message/MessageExt;", "context", "Lorg/apache/rocketmq/client/consumer/listener/ConsumeOrderlyContext;", "enode-rocketmq"})
public final class RocketMQMessageOrderlyListener
implements MessageListenerOrderly {
    @NotNull
    private final MessageHandlerHolder messageHandlerHolder;

    public RocketMQMessageOrderlyListener(@NotNull MessageHandlerHolder messageHandlerHolder) {
        Intrinsics.checkNotNullParameter((Object)messageHandlerHolder, (String)"messageHandlerHolder");
        this.messageHandlerHolder = messageHandlerHolder;
    }

    @NotNull
    public ConsumeOrderlyStatus consumeMessage(@NotNull List<? extends MessageExt> msgs, @NotNull ConsumeOrderlyContext context) {
        Intrinsics.checkNotNullParameter(msgs, (String)"msgs");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CountDownLatch latch = new CountDownLatch(msgs.size());
        msgs.forEach(arg_0 -> RocketMQMessageOrderlyListener.consumeMessage$lambda$1(this, latch, arg_0));
        latch.await();
        return ConsumeOrderlyStatus.SUCCESS;
    }

    private static final void consumeMessage$lambda$1$lambda$0(CountDownLatch $latch, QueueMessage it) {
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $latch.countDown();
    }

    private static final void consumeMessage$lambda$1(RocketMQMessageOrderlyListener this$0, CountDownLatch $latch, MessageExt msg) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        QueueMessage queueMessage = RocketMQMessageListenerKt.access$covertToQueueMessage(msg);
        MessageHandler messageHandler = this$0.messageHandlerHolder.chooseMessageHandler(queueMessage.getType());
        messageHandler.handle(queueMessage, arg_0 -> RocketMQMessageOrderlyListener.consumeMessage$lambda$1$lambda$0($latch, arg_0));
    }
}

