/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.mysql;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.eventing.AggregateEventAppendResult;
import org.enodeframework.eventing.BatchAggregateEventAppendResult;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EventAppendResult;
import org.enodeframework.eventing.EventSerializer;
import org.enodeframework.eventing.EventStore;
import org.enodeframework.eventing.EventStoreOptions;
import org.enodeframework.mysql.MySQLAddDomainEventsHandler;
import org.enodeframework.mysql.MySQLEventStore;
import org.enodeframework.mysql.MySQLFindDomainEventsHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 &2\u00020\u0001:\u0001&B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J \u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J \u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J \u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J \u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J4\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0018H\u0002J4\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/enodeframework/mysql/MySQLEventStore;", "Lorg/enodeframework/eventing/EventStore;", "sqlClient", "Lio/vertx/mysqlclient/MySQLPool;", "options", "Lorg/enodeframework/eventing/EventStoreOptions;", "eventSerializer", "Lorg/enodeframework/eventing/EventSerializer;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "(Lio/vertx/mysqlclient/MySQLPool;Lorg/enodeframework/eventing/EventStoreOptions;Lorg/enodeframework/eventing/EventSerializer;Lorg/enodeframework/common/serializing/SerializeService;)V", "batchAppendAggregateEvents", "Ljava/util/concurrent/CompletableFuture;", "Lorg/enodeframework/eventing/AggregateEventAppendResult;", "aggregateRootId", "", "eventStreamList", "", "Lorg/enodeframework/eventing/DomainEventStream;", "batchAppendAggregateEventsAsync", "", "batchAggregateEventAppendResult", "Lorg/enodeframework/eventing/BatchAggregateEventAppendResult;", "retryTimes", "", "batchAppendAsync", "Lorg/enodeframework/eventing/EventAppendResult;", "eventStreams", "findAsync", "version", "commandId", "findByCommandId", "findByVersion", "queryAggregateEvents", "aggregateRootTypeName", "minVersion", "maxVersion", "queryAggregateEventsAsync", "Companion", "enode-mysql"})
@SourceDebugExtension(value={"SMAP\nMySQLEventStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MySQLEventStore.kt\norg/enodeframework/mysql/MySQLEventStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,135:1\n1477#2:136\n1502#2,3:137\n1505#2,3:147\n1549#2:150\n1620#2,3:151\n372#3,7:140\n*S KotlinDebug\n*F\n+ 1 MySQLEventStore.kt\norg/enodeframework/mysql/MySQLEventStore\n*L\n29#1:136\n29#1:137,3\n29#1:147,3\n65#1:150\n65#1:151,3\n29#1:140,7\n*E\n"})
public final class MySQLEventStore
implements EventStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MySQLPool sqlClient;
    @NotNull
    private final EventStoreOptions options;
    @NotNull
    private final EventSerializer eventSerializer;
    @NotNull
    private final SerializeService serializeService;
    @NotNull
    private static final String INSERT_EVENT_SQL = "INSERT INTO %s (aggregate_root_id, aggregate_root_type_name, command_id, version, events, create_at) VALUES (?, ?, ?, ?, ?, ?)";
    @NotNull
    private static final String SELECT_MANY_BY_VERSION_SQL = "SELECT * FROM %s WHERE aggregate_root_id = ? AND version >= ? AND version <= ? ORDER BY version ASC";
    @NotNull
    private static final String SELECT_ONE_BY_VERSION_SQL = "SELECT * FROM %s WHERE aggregate_root_id = ? AND version = ?";
    @NotNull
    private static final String SELECT_ONE_BY_COMMAND_ID_SQL = "SELECT * FROM %s WHERE aggregate_root_id = ? AND command_id = ?";

    public MySQLEventStore(@NotNull MySQLPool sqlClient, @NotNull EventStoreOptions options, @NotNull EventSerializer eventSerializer, @NotNull SerializeService serializeService) {
        Intrinsics.checkNotNullParameter((Object)sqlClient, (String)"sqlClient");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)eventSerializer, (String)"eventSerializer");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        this.sqlClient = sqlClient;
        this.options = options;
        this.eventSerializer = eventSerializer;
        this.serializeService = serializeService;
    }

    @NotNull
    public CompletableFuture<EventAppendResult> batchAppendAsync(@NotNull List<DomainEventStream> eventStreams) {
        Intrinsics.checkNotNullParameter(eventStreams, (String)"eventStreams");
        CompletableFuture<EventAppendResult> future = new CompletableFuture<EventAppendResult>();
        EventAppendResult appendResult = new EventAppendResult();
        if (eventStreams.isEmpty()) {
            future.complete(appendResult);
            return future;
        }
        Iterable $this$groupBy$iv = CollectionsKt.distinct((Iterable)eventStreams);
        boolean $i$f$groupBy = false;
        Iterable object3 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : object3) {
            Object object;
            DomainEventStream obj = (DomainEventStream)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = obj.getAggregateRootId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map eventStreamMap = destination$iv$iv;
        BatchAggregateEventAppendResult batchAggregateEventAppendResult = new BatchAggregateEventAppendResult(eventStreamMap.keySet().size());
        for (Map.Entry entry : eventStreamMap.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            this.batchAppendAggregateEventsAsync(key, value, batchAggregateEventAppendResult, 0);
        }
        return batchAggregateEventAppendResult.getTaskCompletionSource();
    }

    private final void batchAppendAggregateEventsAsync(String aggregateRootId, List<DomainEventStream> eventStreamList, BatchAggregateEventAppendResult batchAggregateEventAppendResult, int retryTimes) {
        IOHelper.tryAsyncActionRecursively((String)"BatchAppendAggregateEventsAsync", () -> MySQLEventStore.batchAppendAggregateEventsAsync$lambda$1(this, aggregateRootId, eventStreamList), arg_0 -> MySQLEventStore.batchAppendAggregateEventsAsync$lambda$2(batchAggregateEventAppendResult, aggregateRootId, arg_0), () -> MySQLEventStore.batchAppendAggregateEventsAsync$lambda$3(aggregateRootId, eventStreamList), null, (int)retryTimes, (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<AggregateEventAppendResult> batchAppendAggregateEvents(String aggregateRootId, List<DomainEventStream> eventStreamList) {
        void $this$mapTo$iv$iv;
        String string = INSERT_EVENT_SQL;
        Object[] objectArray = new Object[]{this.options.getEventTableName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String sql = string2;
        MySQLAddDomainEventsHandler handler = new MySQLAddDomainEventsHandler(this.options, aggregateRootId);
        Iterable $this$map$iv = eventStreamList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void domainEventStream;
            DomainEventStream domainEventStream2 = (DomainEventStream)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Tuple.of((Object)domainEventStream.getAggregateRootId(), (Object)domainEventStream.getAggregateRootTypeName(), (Object)domainEventStream.getCommandId(), (Object)domainEventStream.getVersion(), (Object)this.serializeService.serialize((Object)this.eventSerializer.serialize(domainEventStream.getEvents())), (Object)domainEventStream.getTimestamp().getTime()));
        }
        List tuples = (List)destination$iv$iv;
        this.sqlClient.withTransaction(arg_0 -> MySQLEventStore.batchAppendAggregateEvents$lambda$5(sql, tuples, handler, arg_0));
        return handler.getFuture();
    }

    @NotNull
    public CompletableFuture<List<DomainEventStream>> queryAggregateEventsAsync(@NotNull String aggregateRootId, @NotNull String aggregateRootTypeName, int minVersion, int maxVersion) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        return IOHelper.tryIOFuncAsync(() -> MySQLEventStore.queryAggregateEventsAsync$lambda$6(this, aggregateRootId, aggregateRootTypeName, minVersion, maxVersion), (String)"QueryAggregateEventsAsync");
    }

    private final CompletableFuture<List<DomainEventStream>> queryAggregateEvents(String aggregateRootId, String aggregateRootTypeName, int minVersion, int maxVersion) {
        MySQLFindDomainEventsHandler handler = new MySQLFindDomainEventsHandler(this.eventSerializer, this.serializeService, aggregateRootId + "#" + minVersion + "#" + maxVersion);
        String string = SELECT_MANY_BY_VERSION_SQL;
        Object[] objectArray = new Object[]{this.options.getEventTableName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String sql = string2;
        Future resultSet = this.sqlClient.preparedQuery(sql).execute(Tuple.of((Object)aggregateRootId, (Object)minVersion, (Object)maxVersion));
        resultSet.onComplete((Handler)handler);
        return handler.getFuture();
    }

    @NotNull
    public CompletableFuture<DomainEventStream> findAsync(@NotNull String aggregateRootId, int version) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        return IOHelper.tryIOFuncAsync(() -> MySQLEventStore.findAsync$lambda$7(this, aggregateRootId, version), (String)"FindEventByVersionAsync");
    }

    private final CompletableFuture<DomainEventStream> findByVersion(String aggregateRootId, int version) {
        MySQLFindDomainEventsHandler handler = new MySQLFindDomainEventsHandler(this.eventSerializer, this.serializeService, aggregateRootId + "#" + version);
        String string = SELECT_ONE_BY_VERSION_SQL;
        Object[] objectArray = new Object[]{this.options.getEventTableName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String sql = string2;
        this.sqlClient.preparedQuery(sql).execute(Tuple.of((Object)aggregateRootId, (Object)version)).onComplete((Handler)handler);
        CompletionStage completionStage = handler.getFuture().thenApply(arg_0 -> MySQLEventStore.findByVersion$lambda$8(findByVersion.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @NotNull
    public CompletableFuture<DomainEventStream> findAsync(@NotNull String aggregateRootId, @NotNull String commandId) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        return IOHelper.tryIOFuncAsync(() -> MySQLEventStore.findAsync$lambda$9(this, aggregateRootId, commandId), (String)"FindEventByCommandIdAsync");
    }

    private final CompletableFuture<DomainEventStream> findByCommandId(String aggregateRootId, String commandId) {
        MySQLFindDomainEventsHandler handler = new MySQLFindDomainEventsHandler(this.eventSerializer, this.serializeService, aggregateRootId + "#" + commandId);
        String string = SELECT_ONE_BY_COMMAND_ID_SQL;
        Object[] objectArray = new Object[]{this.options.getEventTableName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String sql = string2;
        this.sqlClient.preparedQuery(sql).execute(Tuple.of((Object)aggregateRootId, (Object)commandId)).onComplete((Handler)handler);
        CompletionStage completionStage = handler.getFuture().thenApply(arg_0 -> MySQLEventStore.findByCommandId$lambda$10(findByCommandId.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final CompletableFuture batchAppendAggregateEventsAsync$lambda$1(MySQLEventStore this$0, String $aggregateRootId, List $eventStreamList) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)$eventStreamList, (String)"$eventStreamList");
        return this$0.batchAppendAggregateEvents($aggregateRootId, $eventStreamList);
    }

    private static final void batchAppendAggregateEventsAsync$lambda$2(BatchAggregateEventAppendResult $batchAggregateEventAppendResult, String $aggregateRootId, AggregateEventAppendResult result) {
        Intrinsics.checkNotNullParameter((Object)$batchAggregateEventAppendResult, (String)"$batchAggregateEventAppendResult");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        $batchAggregateEventAppendResult.addCompleteAggregate($aggregateRootId, result);
    }

    private static final String batchAppendAggregateEventsAsync$lambda$3(String $aggregateRootId, List $eventStreamList) {
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)$eventStreamList, (String)"$eventStreamList");
        return "[aggregateRootId: " + $aggregateRootId + ", eventStreamCount: " + $eventStreamList.size() + "]";
    }

    private static final Future batchAppendAggregateEvents$lambda$5(String $sql, List $tuples, MySQLAddDomainEventsHandler $handler, SqlConnection client) {
        Intrinsics.checkNotNullParameter((Object)$sql, (String)"$sql");
        Intrinsics.checkNotNullParameter((Object)$tuples, (String)"$tuples");
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        return client.preparedQuery($sql).executeBatch($tuples).onComplete((Handler)$handler);
    }

    private static final CompletableFuture queryAggregateEventsAsync$lambda$6(MySQLEventStore this$0, String $aggregateRootId, String $aggregateRootTypeName, int $minVersion, int $maxVersion) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootTypeName, (String)"$aggregateRootTypeName");
        return this$0.queryAggregateEvents($aggregateRootId, $aggregateRootTypeName, $minVersion, $maxVersion);
    }

    private static final CompletableFuture findAsync$lambda$7(MySQLEventStore this$0, String $aggregateRootId, int $version) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        return this$0.findByVersion($aggregateRootId, $version);
    }

    private static final DomainEventStream findByVersion$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DomainEventStream)$tmp0.invoke(p0);
    }

    private static final CompletableFuture findAsync$lambda$9(MySQLEventStore this$0, String $aggregateRootId, String $commandId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)$commandId, (String)"$commandId");
        return this$0.findByCommandId($aggregateRootId, $commandId);
    }

    private static final DomainEventStream findByCommandId$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DomainEventStream)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/enodeframework/mysql/MySQLEventStore$Companion;", "", "()V", "INSERT_EVENT_SQL", "", "SELECT_MANY_BY_VERSION_SQL", "SELECT_ONE_BY_COMMAND_ID_SQL", "SELECT_ONE_BY_VERSION_SQL", "enode-mysql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

