/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.guice;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.embulk.guice.LifeCycleListener;
import org.embulk.guice.LifeCycleManager;

public class LoggingLifeCycleListener
implements LifeCycleListener {
    private final Logger log;

    public LoggingLifeCycleListener(Logger log) {
        this.log = log;
    }

    public LoggingLifeCycleListener() {
        this.log = Logger.getLogger(LifeCycleManager.class.getName());
    }

    @Override
    public void startingLifeCycle() {
        this.log.fine("Life cycle starting...");
    }

    @Override
    public void startedLifeCycle() {
        this.log.fine("Life cycle startup complete. System ready.");
    }

    @Override
    public void stoppingLifeCycle() {
        this.log.fine("Life cycle stopping...");
    }

    @Override
    public void stoppedLifeCycle() {
        this.log.fine("Life cycle stopped.");
    }

    @Override
    public void startingInstance(Object obj) {
        this.log.fine("Starting " + obj.getClass().getName());
    }

    @Override
    public void postConstructingInstance(Object obj, Method postConstruct) {
        this.log.fine("\t" + postConstruct.getName() + "()");
    }

    @Override
    public void stoppingInstance(Object obj) {
        this.log.fine("Stopping " + obj.getClass().getName());
    }

    @Override
    public void preDestroyingInstance(Object obj, Method preDestroy) {
        this.log.fine("\t" + preDestroy.getName() + "()");
    }
}

