/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.guice;

import com.google.inject.Injector;
import org.embulk.guice.CloseableInjector;
import org.embulk.guice.InjectorProxy;
import org.embulk.guice.LifeCycleInjector;
import org.embulk.guice.LifeCycleManager;

class LifeCycleInjectorProxy
extends InjectorProxy
implements LifeCycleInjector,
CloseableInjector {
    private final Injector injector;
    private final LifeCycleManager lifeCycleManager;

    public LifeCycleInjectorProxy(Injector injector, LifeCycleManager lifeCycleManager) {
        this.injector = injector;
        this.lifeCycleManager = lifeCycleManager;
    }

    @Override
    protected synchronized Injector injector() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("Injector already destroyed");
        }
        return this.injector;
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this.lifeCycleManager.isDestroyed();
    }

    @Override
    public synchronized void destroy() throws Exception {
        this.lifeCycleManager.destroy();
    }

    @Override
    public void close() throws Exception {
        this.destroy();
    }
}

