/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.guice;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.util.Modules;
import java.util.Collection;
import java.util.List;
import org.embulk.guice.CloseableInjector;
import org.embulk.guice.LifeCycleInjector;
import org.embulk.guice.LifeCycleInjectorProxy;
import org.embulk.guice.LifeCycleListener;
import org.embulk.guice.LifeCycleManager;
import org.embulk.guice.LifeCycleModule;

public class Bootstrap {
    private final List<Module> modules = Lists.newArrayList();
    private final List<Function<? super List<Module>, ? extends Iterable<? extends Module>>> moduleOverrides = Lists.newArrayList();
    private final List<LifeCycleListener> lifeCycleListeners = Lists.newArrayList();
    private boolean requireExplicitBindings = true;
    private boolean started;

    public Bootstrap(Module ... modules) {
        this((Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
    }

    public Bootstrap(Iterable<? extends Module> modules) {
        this.modules.addAll((Collection<Module>)ImmutableList.copyOf(modules));
    }

    public Bootstrap addLifeCycleListeners(LifeCycleListener ... listeners) {
        return this.addLifeCycleListeners((Iterable<? extends LifeCycleListener>)ImmutableList.copyOf((Object[])listeners));
    }

    public Bootstrap addLifeCycleListeners(Iterable<? extends LifeCycleListener> listeners) {
        this.lifeCycleListeners.addAll((Collection<LifeCycleListener>)ImmutableList.copyOf(listeners));
        return this;
    }

    public Bootstrap requireExplicitBindings(boolean requireExplicitBindings) {
        this.requireExplicitBindings = requireExplicitBindings;
        return this;
    }

    public Bootstrap addModules(Module ... additionalModules) {
        return this.addModules((Iterable<? extends Module>)ImmutableList.copyOf((Object[])additionalModules));
    }

    public Bootstrap addModules(Iterable<? extends Module> additionalModules) {
        this.modules.addAll((Collection<Module>)ImmutableList.copyOf(additionalModules));
        return this;
    }

    public Bootstrap overrideModulesWith(Module ... overridingModules) {
        return this.overrideModulesWith((Iterable<? extends Module>)ImmutableList.copyOf((Object[])overridingModules));
    }

    public Bootstrap overrideModulesWith(Iterable<? extends Module> overridingModules) {
        ImmutableList immutableCopy = ImmutableList.copyOf(overridingModules);
        return this.overrideModules((Function<? super List<Module>, ? extends Iterable<? extends Module>>)new Function<List<Module>, List<Module>>((List)immutableCopy){
            final /* synthetic */ List val$immutableCopy;
            {
                this.val$immutableCopy = list;
            }

            public List<Module> apply(List<Module> modules) {
                return ImmutableList.of((Object)Modules.override(modules).with((Iterable)this.val$immutableCopy));
            }
        });
    }

    public Bootstrap overrideModules(Function<? super List<Module>, ? extends Iterable<? extends Module>> function) {
        this.moduleOverrides.add(function);
        return this;
    }

    public LifeCycleInjector initialize() {
        return this.build(true);
    }

    public CloseableInjector initializeCloseable() {
        return this.build(false);
    }

    private LifeCycleInjectorProxy build(boolean destroyOnShutdownHook) {
        Injector injector = this.start();
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        if (destroyOnShutdownHook) {
            lifeCycleManager.destroyOnShutdownHook();
        }
        return new LifeCycleInjectorProxy(injector, lifeCycleManager);
    }

    private Injector start() {
        ImmutableList userModules = ImmutableList.copyOf(this.modules);
        for (Function<? super List<Module>, ? extends Iterable<? extends Module>> moduleOverride : this.moduleOverrides) {
            userModules = ImmutableList.copyOf((Iterable)((Iterable)moduleOverride.apply((Object)userModules)));
        }
        if (this.started) {
            throw new IllegalStateException("System already initialized");
        }
        this.started = true;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)userModules);
        builder.add((Object)new Module(){

            public void configure(Binder binder) {
                binder.disableCircularProxies();
                if (Bootstrap.this.requireExplicitBindings) {
                    binder.requireExplicitBindings();
                }
            }
        });
        builder.add((Object)new LifeCycleModule((List<LifeCycleListener>)ImmutableList.copyOf(this.lifeCycleListeners)));
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)builder.build());
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        if (lifeCycleManager.size() > 0) {
            lifeCycleManager.start();
        }
        return injector;
    }
}

