/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.timestamp;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import org.embulk.util.timestamp.JavaTimestampFormatter;
import org.embulk.util.timestamp.LegacyDateTimeZones;
import org.embulk.util.timestamp.LegacyTimestampFormatter;
import org.embulk.util.timestamp.RubyTimestampFormatter;

public abstract class TimestampFormatter {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("u-M-d", Locale.ROOT);

    TimestampFormatter() {
    }

    public static Builder builder(String pattern) {
        return TimestampFormatter.builder(pattern, false);
    }

    public static Builder builder(String pattern, boolean isLegacyEnabled) {
        return new Builder(pattern, isLegacyEnabled);
    }

    public static Builder builderWithJava(String pattern) {
        return new Builder(Prefix.JAVA, pattern, false);
    }

    public static Builder builderWithRuby(String pattern) {
        return new Builder(Prefix.RUBY, pattern, false);
    }

    public abstract String format(Instant var1);

    public abstract Instant parse(String var1);

    private static enum Prefix {
        RUBY,
        JAVA,
        NONE;

    }

    public static final class Builder {
        private final Prefix prefix;
        private final String pattern;
        private final boolean isLegacyEnabled;
        private Optional<ZoneOffset> defaultZoneOffset;
        private Optional<ZoneId> defaultZoneId;
        private int defaultYear;
        private int defaultMonthOfYear;
        private int defaultDayOfMonth;

        private Builder(Prefix prefix, String pattern, boolean isLegacyEnabled) {
            this.isLegacyEnabled = isLegacyEnabled;
            this.prefix = prefix;
            if (prefix == Prefix.NONE && !isLegacyEnabled) {
                throw new IllegalArgumentException("isLegacyEnabled must be true to specify a non-prefixed pattern.");
            }
            this.pattern = pattern;
            this.defaultZoneOffset = Optional.empty();
            this.defaultZoneId = Optional.empty();
            this.defaultYear = 1970;
            this.defaultMonthOfYear = 1;
            this.defaultDayOfMonth = 1;
        }

        private Builder(String pattern, boolean isLegacyEnabled) {
            this.isLegacyEnabled = isLegacyEnabled;
            if (pattern.startsWith("java:")) {
                this.prefix = Prefix.JAVA;
                this.pattern = pattern.substring(5);
            } else if (pattern.startsWith("ruby:")) {
                this.prefix = Prefix.RUBY;
                this.pattern = pattern.substring(5);
            } else if (isLegacyEnabled) {
                this.prefix = Prefix.NONE;
                this.pattern = pattern;
            } else {
                throw new IllegalArgumentException("isLegacyEnabled must be true to specify a non-prefixed pattern.");
            }
            this.defaultZoneOffset = Optional.empty();
            this.defaultZoneId = Optional.empty();
        }

        public Builder setDefaultZoneOffset(ZoneOffset defaultZoneOffset) {
            this.defaultZoneOffset = Optional.of(defaultZoneOffset);
            return this;
        }

        public Builder setDefaultZoneId(ZoneId defaultZoneId) {
            if (this.prefix != Prefix.NONE) {
                throw new IllegalArgumentException("Pattern must be legacy non-prefixed to set default ZoneId.");
            }
            this.defaultZoneId = Optional.of(defaultZoneId);
            return this;
        }

        public Builder setDefaultZoneFromString(String defaultZoneString) {
            if (this.prefix != Prefix.NONE) {
                return this.setDefaultZoneOffset(ZoneOffset.of(defaultZoneString));
            }
            return this.setDefaultZoneId(LegacyDateTimeZones.toZoneId(defaultZoneString));
        }

        public Builder setDefaultDate(int defaultYear, int defaultMonthOfYear, int defaultDayOfMonth) {
            if (this.prefix != Prefix.NONE) {
                if (defaultYear != 1970 || defaultMonthOfYear != 1 || defaultDayOfMonth != 1) {
                    throw new IllegalArgumentException("Pattern must be legacy non-prefixed to set default date.");
                }
            } else {
                this.defaultYear = defaultYear;
                this.defaultMonthOfYear = defaultMonthOfYear;
                this.defaultDayOfMonth = defaultDayOfMonth;
            }
            return this;
        }

        public Builder setDefaultDateFromString(String defaultDateString) {
            LocalDate date = LocalDate.from(DATE_FORMATTER.parse(defaultDateString));
            this.setDefaultDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
            return this;
        }

        public TimestampFormatter build() {
            if (this.prefix == Prefix.JAVA) {
                return new JavaTimestampFormatter(this.pattern, this.defaultZoneOffset.orElse(ZoneOffset.UTC));
            }
            if (this.prefix == Prefix.RUBY) {
                return new RubyTimestampFormatter(this.pattern, this.defaultZoneOffset.orElse(ZoneOffset.UTC));
            }
            if (this.isLegacyEnabled) {
                if (this.defaultZoneOffset.isPresent() && this.defaultZoneId.isPresent()) {
                    throw new IllegalArgumentException("Both default ZoneId and ZoneOffset are set.");
                }
                if (this.defaultZoneId.isPresent()) {
                    return new LegacyTimestampFormatter(this.pattern, this.defaultZoneId.get(), this.defaultYear, this.defaultMonthOfYear, this.defaultDayOfMonth);
                }
                return new LegacyTimestampFormatter(this.pattern, this.defaultZoneOffset.orElse(ZoneOffset.UTC), this.defaultYear, this.defaultMonthOfYear, this.defaultDayOfMonth);
            }
            throw new IllegalArgumentException("isLegacyEnabled must be true to specify a non-prefixed pattern.");
        }
    }
}

