/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.timestamp;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import org.embulk.util.rubytime.RubyDateTimeFormatter;
import org.embulk.util.rubytime.RubyDateTimeResolver;
import org.embulk.util.timestamp.LegacyRubyTimeResolver;
import org.embulk.util.timestamp.TimestampFormatter;

class LegacyTimestampFormatter
extends TimestampFormatter {
    private final RubyDateTimeFormatter rubyFormatter;
    private final ZoneId defaultZoneId;
    private final ZoneId normalizedDefaultZoneId;

    LegacyTimestampFormatter(String pattern, ZoneId defaultZoneId, int defaultYear, int defaultMonthOfYear, int defaultDayOfMonth) {
        LegacyRubyTimeResolver resolver = new LegacyRubyTimeResolver(defaultZoneId, defaultYear, defaultMonthOfYear, defaultDayOfMonth, 0, 0, 0, 0);
        this.rubyFormatter = RubyDateTimeFormatter.ofPattern((String)pattern).withResolver((RubyDateTimeResolver)resolver);
        this.defaultZoneId = defaultZoneId;
        this.normalizedDefaultZoneId = defaultZoneId.normalized();
    }

    LegacyTimestampFormatter(String pattern, ZoneId defaultZoneId) {
        this(pattern, defaultZoneId, 1970, 1, 1);
    }

    @Override
    public final String format(Instant instant) {
        if (instant == null) {
            throw new NullPointerException("instant is null.");
        }
        if (this.normalizedDefaultZoneId instanceof ZoneOffset) {
            return this.rubyFormatter.formatWithZoneNameStyle((TemporalAccessor)instant.atOffset((ZoneOffset)this.normalizedDefaultZoneId), RubyDateTimeFormatter.ZoneNameStyle.SHORT);
        }
        return this.rubyFormatter.formatWithZoneNameStyle((TemporalAccessor)instant.atZone(this.defaultZoneId), RubyDateTimeFormatter.ZoneNameStyle.SHORT);
    }

    @Override
    public final Instant parse(String text) {
        if (text == null) {
            throw new DateTimeParseException("text is null.", text, 0, new NullPointerException());
        }
        if (text.isEmpty()) {
            throw new DateTimeParseException("text is empty.", text, 0);
        }
        TemporalAccessor parsed = this.rubyFormatter.parse(text);
        return Instant.from(parsed);
    }
}

