/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.embulk.spi.FileInput;
import org.embulk.util.file.FileInputInputStream;
import org.embulk.util.text.LineDelimiter;
import org.embulk.util.text.LineReader;

public class LineDecoder
implements AutoCloseable,
Iterable<String> {
    private String nextLine;
    private final Charset charset;
    private final FileInputInputStream inputStream;
    private final BufferedReader reader;

    private LineDecoder(FileInputInputStream inputStream, Charset charset, BufferedReader reader) {
        this.inputStream = inputStream;
        this.charset = charset;
        this.reader = reader;
        this.nextLine = null;
    }

    public static LineDecoder of(FileInput in, Charset charset, LineDelimiter lineDelimiterRecognized) {
        FileInputInputStream inputStream = new FileInputInputStream(in);
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        return new LineDecoder(inputStream, charset, LineReader.of(new InputStreamReader((InputStream)inputStream, decoder), lineDelimiterRecognized, 256));
    }

    public boolean nextFile() {
        boolean has = this.inputStream.nextFile();
        if (has && this.charset.equals(StandardCharsets.UTF_8)) {
            this.skipBom();
        }
        return has;
    }

    public String poll() {
        try {
            return this.reader.readLine();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new Ite(this);
    }

    private void skipBom() {
        block13: {
            boolean skip = false;
            try {
                if (this.charset.equals(StandardCharsets.UTF_8)) {
                    this.reader.mark(3);
                    int firstChar = this.reader.read();
                    if (firstChar == 65279) {
                        skip = true;
                    }
                }
            }
            catch (IOException ex) {
                if (skip) break block13;
                try {
                    this.reader.reset();
                }
                catch (IOException ex2) {
                    throw new UncheckedIOException(ex2);
                }
            }
            finally {
                if (!skip) {
                    try {
                        this.reader.reset();
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
            }
        }
    }

    private static class Ite
    implements Iterator<String> {
        private LineDecoder self;

        public Ite(LineDecoder self) {
            this.self = self;
        }

        @Override
        public boolean hasNext() {
            if (this.self.nextLine != null) {
                return true;
            }
            this.self.nextLine = this.self.poll();
            return this.self.nextLine != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String l = this.self.nextLine;
            this.self.nextLine = null;
            return l;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

