/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.text;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.FileOutput;
import org.embulk.util.file.FileOutputOutputStream;
import org.embulk.util.text.Newline;

public class LineEncoder
implements AutoCloseable {
    private Writer writer;
    private final String newline;
    private final FileOutput underlyingFileOutput;
    private final FileOutputOutputStream outputStream;

    private LineEncoder(FileOutput fileOutput, FileOutputOutputStream outputStream, String newline, BufferedWriter writer) {
        this.underlyingFileOutput = fileOutput;
        this.outputStream = outputStream;
        this.newline = newline;
        this.writer = writer;
    }

    public static LineEncoder of(FileOutput fileOutput, Newline newline, Charset charset, BufferAllocator bufferAllocator) {
        FileOutputOutputStream outputStream = new FileOutputOutputStream(fileOutput, bufferAllocator, FileOutputOutputStream.CloseMode.FLUSH_FINISH);
        CharsetEncoder encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, encoder), 32768);
        return new LineEncoder(fileOutput, outputStream, newline.getString(), writer);
    }

    public void addNewLine() {
        try {
            this.writer.append(this.newline);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void addLine(String line) {
        try {
            this.writer.append(line);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.addNewLine();
    }

    public void addText(String text) {
        try {
            this.writer.append(text);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void nextFile() {
        try {
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.outputStream.nextFile();
    }

    public void finish() {
        try {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            this.underlyingFileOutput.close();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

