/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.embulk.util.rubytime.Format;
import org.embulk.util.rubytime.FormatDirective;
import org.embulk.util.rubytime.FormatToken;
import org.embulk.util.rubytime.Parsed;
import org.embulk.util.rubytime.RubyDateTimeParseException;

final class ParserWithContext {
    private static final Pattern ZONE_PARSE_REGEX = Pattern.compile("\\A((?:gmt|utc?)?[-+]\\d+(?:[,.:]\\d+(?::\\d+)?)?|(?-i:[[\\p{Alpha}].\\s]+)(?:standard|daylight)\\s+time\\b|(?-i:[[\\p{Alpha}]]+)(?:\\s+dst)?\\b)", 2);
    private static final String[] DAY_NAMES = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] MONTH_NAMES = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] MERID_NAMES = new String[]{"am", "pm", "a.m.", "p.m."};
    private static final long[] POW10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private final String text;
    private int pos;

    ParserWithContext(CharSequence text) {
        this.text = text.toString();
        this.pos = 0;
    }

    Parsed parse(Format format) {
        Parsed.Builder builder = Parsed.builder(this.text);
        for (Format.TokenWithNext tokenWithNext : format) {
            FormatToken token = tokenWithNext.getToken();
            if (token.onlyForFormatter()) {
                throw new RubyDateTimeParseException("Text '" + this.text + "' could not be parsed at index " + this.pos, this.text, this.pos);
            }
            if (token.isImmediate()) {
                this.consumeImmediateString(token.getImmediate().get());
                continue;
            }
            switch (token.getFormatDirective().get()) {
                case DAY_OF_WEEK_FULL_NAME: 
                case DAY_OF_WEEK_ABBREVIATED_NAME: {
                    this.consumeWeekName(builder);
                    break;
                }
                case MONTH_OF_YEAR_FULL_NAME: 
                case MONTH_OF_YEAR_ABBREVIATED_NAME: 
                case MONTH_OF_YEAR_ABBREVIATED_NAME_ALIAS_SMALL_H: {
                    this.consumeMonthOfYearName(builder);
                    break;
                }
                case CENTURY: {
                    this.consumeCentury(builder, tokenWithNext.getNextToken());
                    break;
                }
                case DAY_OF_MONTH_ZERO_PADDED: 
                case DAY_OF_MONTH_BLANK_PADDED: {
                    this.consumeDayOfMonth(builder);
                    break;
                }
                case WEEK_BASED_YEAR_WITH_CENTURY: {
                    this.consumeWeekBasedYearWithCentury(builder, tokenWithNext.getNextToken());
                    break;
                }
                case WEEK_BASED_YEAR_WITHOUT_CENTURY: {
                    this.consumeWeekBasedYearWithoutCentury(builder);
                    break;
                }
                case HOUR_OF_DAY_ZERO_PADDED: 
                case HOUR_OF_DAY_BLANK_PADDED: {
                    this.consumeHourOfDay(builder);
                    break;
                }
                case HOUR_OF_AMPM_ZERO_PADDED: 
                case HOUR_OF_AMPM_BLANK_PADDED: {
                    this.consumeHourOfAmPm(builder);
                    break;
                }
                case DAY_OF_YEAR: {
                    this.consumeDayOfYear(builder);
                    break;
                }
                case MILLI_OF_SECOND: 
                case NANO_OF_SECOND: {
                    this.consumeSubsecond(builder, token, tokenWithNext.getNextToken());
                    break;
                }
                case MINUTE_OF_HOUR: {
                    this.consumeMinuteOfHour(builder);
                    break;
                }
                case MONTH_OF_YEAR: {
                    this.consumeMonthOfYear(builder);
                    break;
                }
                case AMPM_OF_DAY_UPPER_CASE: 
                case AMPM_OF_DAY_LOWER_CASE: {
                    this.consumeAmPmOfDay(builder);
                    break;
                }
                case MILLISECONDS_SINCE_EPOCH: {
                    this.consumeMillisecondsSinceEpoch(builder);
                    break;
                }
                case SECOND_OF_MINUTE: {
                    this.consumeSecondOfMinute(builder);
                    break;
                }
                case SECONDS_SINCE_EPOCH: {
                    this.consumeSecondsSinceEpoch(builder);
                    break;
                }
                case WEEK_OF_YEAR_STARTING_WITH_SUNDAY: 
                case WEEK_OF_YEAR_STARTING_WITH_MONDAY: {
                    this.consumeWeekOfYear(builder, token);
                    break;
                }
                case DAY_OF_WEEK_STARTING_WITH_MONDAY_1: {
                    this.consumeDayOfWeekStartingWithMonday1(builder);
                    break;
                }
                case WEEK_OF_WEEK_BASED_YEAR: {
                    this.consumeWeekOfWeekBasedYear(builder);
                    break;
                }
                case DAY_OF_WEEK_STARTING_WITH_SUNDAY_0: {
                    this.consumeDayOfWeekStartingWithSunday0(builder);
                    break;
                }
                case YEAR_WITH_CENTURY: {
                    this.consumeYearWithCentury(builder, ParserWithContext.isNumberPattern(tokenWithNext.getNextToken()));
                    break;
                }
                case YEAR_WITHOUT_CENTURY: {
                    this.consumeYearWithoutCentury(builder);
                    break;
                }
                case TIME_ZONE_NAME: 
                case TIME_OFFSET: {
                    this.consumeTimeZone(builder);
                    break;
                }
                case IMMEDIATE_PERCENT: {
                    this.consumeImmediateString("%");
                    break;
                }
                case IMMEDIATE_NEWLINE: {
                    this.consumeImmediateString("\n");
                    break;
                }
                case IMMEDIATE_TAB: {
                    this.consumeImmediateString("\t");
                    break;
                }
                case RECURRED_LOWER_C: {
                    this.consumeWeekName(builder);
                    this.consumeImmediateString(" ");
                    this.consumeMonthOfYearName(builder);
                    this.consumeImmediateString(" ");
                    this.consumeDayOfMonth(builder);
                    this.consumeImmediateString(" ");
                    this.consumeHourOfDay(builder);
                    this.consumeImmediateString(":");
                    this.consumeMinuteOfHour(builder);
                    this.consumeImmediateString(":");
                    this.consumeSecondOfMinute(builder);
                    this.consumeImmediateString(" ");
                    this.consumeYearWithCentury(builder, ParserWithContext.isNumberPattern(tokenWithNext.getNextToken()));
                    break;
                }
                case RECURRED_UPPER_D: 
                case RECURRED_LOWER_X: {
                    this.consumeMonthOfYear(builder);
                    this.consumeImmediateString("/");
                    this.consumeDayOfMonth(builder);
                    this.consumeImmediateString("/");
                    this.consumeYearWithoutCentury(builder);
                    break;
                }
                case RECURRED_UPPER_F: {
                    this.consumeYearWithCentury(builder, false);
                    this.consumeImmediateString("-");
                    this.consumeMonthOfYear(builder);
                    this.consumeImmediateString("-");
                    this.consumeDayOfMonth(builder);
                    break;
                }
                case RECURRED_UPPER_R: {
                    this.consumeHourOfDay(builder);
                    this.consumeImmediateString(":");
                    this.consumeMinuteOfHour(builder);
                    break;
                }
                case RECURRED_LOWER_R: {
                    this.consumeHourOfAmPm(builder);
                    this.consumeImmediateString(":");
                    this.consumeMinuteOfHour(builder);
                    this.consumeImmediateString(":");
                    this.consumeSecondOfMinute(builder);
                    this.consumeImmediateString(" ");
                    this.consumeAmPmOfDay(builder);
                    break;
                }
                case RECURRED_UPPER_T: 
                case RECURRED_UPPER_X: {
                    this.consumeHourOfDay(builder);
                    this.consumeImmediateString(":");
                    this.consumeMinuteOfHour(builder);
                    this.consumeImmediateString(":");
                    this.consumeSecondOfMinute(builder);
                    break;
                }
                case RECURRED_LOWER_V: {
                    this.consumeDayOfMonth(builder);
                    this.consumeImmediateString("-");
                    this.consumeMonthOfYearName(builder);
                    this.consumeImmediateString("-");
                    this.consumeYearWithCentury(builder, ParserWithContext.isNumberPattern(tokenWithNext.getNextToken()));
                    break;
                }
                case RECURRED_PLUS: {
                    this.consumeWeekName(builder);
                    this.consumeImmediateString(" ");
                    this.consumeMonthOfYearName(builder);
                    this.consumeImmediateString(" ");
                    this.consumeDayOfMonth(builder);
                    this.consumeImmediateString(" ");
                    this.consumeHourOfDay(builder);
                    this.consumeImmediateString(":");
                    this.consumeMinuteOfHour(builder);
                    this.consumeImmediateString(":");
                    this.consumeSecondOfMinute(builder);
                    this.consumeImmediateString(" ");
                    this.consumeTimeZone(builder);
                    this.consumeImmediateString(" ");
                    this.consumeYearWithCentury(builder, ParserWithContext.isNumberPattern(tokenWithNext.getNextToken()));
                    break;
                }
            }
        }
        if (this.text.length() > this.pos) {
            builder.setLeftover(this.text.substring(this.pos, this.text.length()));
        }
        return builder.build();
    }

    private void consumeImmediateString(String immediateString) {
        for (int i = 0; i < immediateString.length(); ++i) {
            char c = immediateString.charAt(i);
            if (ParserWithContext.isSpace(c)) {
                while (!ParserWithContext.isEndOfText(this.text, this.pos) && ParserWithContext.isSpace(this.text.charAt(this.pos))) {
                    ++this.pos;
                }
                continue;
            }
            if (ParserWithContext.isEndOfText(this.text, this.pos) || c != this.text.charAt(this.pos)) {
                throw new RubyDateTimeParseException("Text '" + this.text + "' could not be parsed at index " + this.pos, this.text, this.pos);
            }
            ++this.pos;
        }
    }

    private void consumeWeekName(Parsed.Builder builder) {
        int dayIndex = this.findIndexInPatterns(DAY_NAMES);
        if (dayIndex < 0) {
            throw new RubyDateTimeParseException("Text '" + this.text + "' could not be parsed at index " + this.pos, this.text, this.pos);
        }
        builder.setDayOfWeekStartingWithSunday0(dayIndex % 7);
        this.pos += DAY_NAMES[dayIndex].length();
    }

    private void consumeMonthOfYearName(Parsed.Builder builder) {
        int monIndex = this.findIndexInPatterns(MONTH_NAMES);
        if (monIndex < 0) {
            throw new RubyDateTimeParseException("Text '" + this.text + "' could not be parsed at index " + this.pos, this.text, this.pos);
        }
        builder.setMonthOfYear(monIndex % 12 + 1);
        this.pos += MONTH_NAMES[monIndex].length();
    }

    private void consumeCentury(Parsed.Builder builder, FormatToken nextToken) {
        if (ParserWithContext.isNumberPattern(nextToken)) {
            builder.setCentury(this.consumeDigitsInInt(2, 0, 99, "invalid century"));
        } else {
            builder.setCentury(this.consumeDigitsInInt(Integer.MAX_VALUE, 0, 9999999, "invalid century"));
        }
    }

    private void consumeDayOfMonth(Parsed.Builder builder) {
        if (ParserWithContext.isBlank(this.text, this.pos)) {
            ++this.pos;
            builder.setDayOfMonth(this.consumeDigitsInInt(1, 1, 31, "invalid day of month"));
        } else {
            builder.setDayOfMonth(this.consumeDigitsInInt(2, 1, 31, "invalid day of month"));
        }
    }

    private void consumeWeekBasedYearWithCentury(Parsed.Builder builder, FormatToken nextToken) {
        if (ParserWithContext.isNumberPattern(nextToken)) {
            builder.setWeekBasedYear(this.consumeDigitsInInt(4, 0, 9999, "invalid year"));
        } else {
            builder.setWeekBasedYear(this.consumeDigitsInInt(Integer.MAX_VALUE, 0, 999999999, "invalid year"));
        }
    }

    private void consumeWeekBasedYearWithoutCentury(Parsed.Builder builder) {
        builder.setWeekBasedYearWithoutCentury(this.consumeDigitsInInt(2, 0, 99, "invalid year"));
    }

    private void consumeHourOfDay(Parsed.Builder builder) {
        if (ParserWithContext.isBlank(this.text, this.pos)) {
            ++this.pos;
            builder.setHour(this.consumeDigitsInInt(1, 0, 24, "invalid hour of day"));
        } else {
            builder.setHour(this.consumeDigitsInInt(2, 0, 24, "invalid hour of day"));
        }
    }

    private void consumeHourOfAmPm(Parsed.Builder builder) {
        if (ParserWithContext.isBlank(this.text, this.pos)) {
            ++this.pos;
            builder.setHour(this.consumeDigitsInInt(1, 1, 12, "invalid hour of am/pm"));
        } else {
            builder.setHour(this.consumeDigitsInInt(2, 1, 12, "invalid hour of am/pm"));
        }
    }

    private void consumeDayOfYear(Parsed.Builder builder) {
        builder.setDayOfYear(this.consumeDigitsInInt(3, 1, 366, "invalid day of year"));
    }

    private void consumeSubsecond(Parsed.Builder builder, FormatToken thisToken, FormatToken nextToken) {
        boolean negative;
        if (ParserWithContext.isSign(this.text, this.pos)) {
            negative = this.text.charAt(this.pos) == '-';
            ++this.pos;
        } else {
            negative = false;
        }
        long value = ParserWithContext.isNumberPattern(nextToken) ? (thisToken.getFormatDirective().get() == FormatDirective.MILLI_OF_SECOND ? (long)this.consumeFractionalPartInInt(3, 9, "invalid fraction part of second") : (long)this.consumeFractionalPartInInt(9, 9, "invalid fraction part of second")) : (long)this.consumeFractionalPartInInt(Integer.MAX_VALUE, 9, "invalid fraction part of second");
        builder.setNanoOfSecond((int)(!negative ? value : -value));
    }

    private void consumeMinuteOfHour(Parsed.Builder builder) {
        builder.setMinuteOfHour(this.consumeDigitsInInt(2, 0, 59, "invalid minute of hour"));
    }

    private void consumeMonthOfYear(Parsed.Builder builder) {
        builder.setMonthOfYear(this.consumeDigitsInInt(2, 1, 12, "invalid month of year"));
    }

    private void consumeAmPmOfDay(Parsed.Builder builder) {
        int meridIndex = this.findIndexInPatterns(MERID_NAMES);
        if (meridIndex < 0) {
            throw new RubyDateTimeParseException("Text '" + this.text + "' could not be parsed at index " + this.pos, this.text, this.pos);
        }
        builder.setAmPmOfDay(meridIndex % 2 == 0 ? 0 : 12);
        this.pos += MERID_NAMES[meridIndex].length();
    }

    private void consumeMillisecondsSinceEpoch(Parsed.Builder builder) {
        boolean negative;
        if (ParserWithContext.isMinus(this.text, this.pos)) {
            negative = true;
            ++this.pos;
        } else {
            negative = false;
        }
        long absoluteMillisecondsSinceEpoch = this.consumeDigitsInLong(Integer.MAX_VALUE, 0L, Long.MAX_VALUE, "invalid milliseconds since epoch");
        builder.setMillisecondsSinceEpoch(negative ? -absoluteMillisecondsSinceEpoch : absoluteMillisecondsSinceEpoch);
    }

    private void consumeSecondOfMinute(Parsed.Builder builder) {
        builder.setSecondOfMinute(this.consumeDigitsInInt(2, 0, 60, "invalid second of minute"));
    }

    private void consumeSecondsSinceEpoch(Parsed.Builder builder) {
        boolean negative;
        if (ParserWithContext.isMinus(this.text, this.pos)) {
            negative = true;
            ++this.pos;
        } else {
            negative = false;
        }
        long absoluteSecondsSinceEpoch = this.consumeDigitsInLong(Integer.MAX_VALUE, 0L, Instant.MAX.getEpochSecond(), "invalid second since epoch");
        builder.setSecondsSinceEpoch(negative ? -absoluteSecondsSinceEpoch : absoluteSecondsSinceEpoch);
    }

    private void consumeWeekOfYear(Parsed.Builder builder, FormatToken thisToken) {
        if (thisToken.getFormatDirective().get() == FormatDirective.WEEK_OF_YEAR_STARTING_WITH_SUNDAY) {
            builder.setWeekOfYearStartingWithSunday(this.consumeDigitsInInt(2, 0, 53, "invalid week of year"));
        } else {
            builder.setWeekOfYearStartingWithMonday(this.consumeDigitsInInt(2, 0, 53, "invalid week of year"));
        }
    }

    private void consumeDayOfWeekStartingWithMonday1(Parsed.Builder builder) {
        builder.setDayOfWeekStartingWithMonday1(this.consumeDigitsInInt(1, 1, 7, "invalid day of week"));
    }

    private void consumeWeekOfWeekBasedYear(Parsed.Builder builder) {
        builder.setWeekOfWeekBasedYear(this.consumeDigitsInInt(2, 1, 53, "invalid week of year"));
    }

    private void consumeDayOfWeekStartingWithSunday0(Parsed.Builder builder) {
        builder.setDayOfWeekStartingWithSunday0(this.consumeDigitsInInt(1, 0, 6, "invalid day of week"));
    }

    private void consumeYearWithCentury(Parsed.Builder builder, boolean isNextTokenNumber) {
        boolean negative;
        if (ParserWithContext.isSign(this.text, this.pos)) {
            negative = this.text.charAt(this.pos) == '-';
            ++this.pos;
        } else {
            negative = false;
        }
        int yearWithCentury = isNextTokenNumber ? this.consumeDigitsInInt(4, 0, 9999, "invalid year") : this.consumeDigitsInInt(Integer.MAX_VALUE, 0, 999999999, "invalid year");
        builder.setYear(!negative ? yearWithCentury : -yearWithCentury);
    }

    private void consumeYearWithoutCentury(Parsed.Builder builder) {
        builder.setYearWithoutCentury(this.consumeDigitsInInt(2, 0, 99, "invalid year"));
    }

    private void consumeTimeZone(Parsed.Builder builder) {
        if (ParserWithContext.isEndOfText(this.text, this.pos)) {
            throw new RubyDateTimeParseException("Text '" + this.text + "' could not be parsed at index " + this.pos, this.text, this.pos);
        }
        Matcher matcher = ZONE_PARSE_REGEX.matcher(this.text.substring(this.pos));
        if (!matcher.find()) {
            throw new RubyDateTimeParseException("Text '" + this.text + "' could not be parsed at index " + this.pos, this.text, this.pos);
        }
        String zone = this.text.substring(this.pos, this.pos + matcher.end());
        builder.setTimeOffset(zone);
        this.pos += zone.length();
    }

    private long consumeDigitsInternal(int digitsToConsume, boolean isFraction, int exponentInFraction, long lowerLimit, long upperLimit, String messageOutOfRange) {
        char digitChar;
        long result = 0L;
        int digitsConsumed = 0;
        for (digitsConsumed = 0; digitsConsumed < digitsToConsume && !ParserWithContext.isEndOfText(this.text, this.pos) && ParserWithContext.isDigit(digitChar = this.text.charAt(this.pos)); ++digitsConsumed) {
            int digit;
            if (isFraction) {
                if (digitsConsumed < exponentInFraction) {
                    digit = ParserWithContext.toInt(digitChar);
                    result = result * 10L + (long)digit;
                }
            } else {
                digit = ParserWithContext.toInt(digitChar);
                if (result > (Long.MAX_VALUE - (long)digit) / 10L) {
                    throw new RubyDateTimeParseException("Text '" + this.text + "' could not be parsed at index " + this.pos + ": " + messageOutOfRange, this.text, this.pos);
                }
                result = result * 10L + (long)digit;
            }
            ++this.pos;
        }
        if (digitsConsumed == 0) {
            throw new RubyDateTimeParseException("Text '" + this.text + "' could not be parsed at index " + this.pos + ": no digits", this.text, this.pos);
        }
        if (isFraction && exponentInFraction > digitsConsumed) {
            result *= POW10[exponentInFraction - digitsConsumed];
        }
        if (lowerLimit > result || result > upperLimit) {
            throw new RubyDateTimeParseException("Text '" + this.text + "' could not be parsed at index " + this.pos + ": " + messageOutOfRange, this.text, this.pos);
        }
        return result;
    }

    private int consumeDigitsInInt(int digitsToConsume, int lowerLimit, int upperLimit, String messageOutOfRange) {
        return (int)this.consumeDigitsInternal(digitsToConsume, false, 0, lowerLimit, upperLimit, messageOutOfRange);
    }

    private long consumeDigitsInLong(int digitsToConsume, long lowerLimit, long upperLimit, String messageOutOfRange) {
        return this.consumeDigitsInternal(digitsToConsume, false, 0, lowerLimit, upperLimit, messageOutOfRange);
    }

    private int consumeFractionalPartInInt(int digitsToConsume, int exponentInFraction, String messageOutOfRange) {
        return (int)this.consumeDigitsInternal(digitsToConsume, true, exponentInFraction, 0L, POW10[exponentInFraction] - 1L, messageOutOfRange);
    }

    private int findIndexInPatterns(String[] patterns) {
        if (ParserWithContext.isEndOfText(this.text, this.pos)) {
            return -1;
        }
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = patterns[i];
            int length = pattern.length();
            if (ParserWithContext.isEndOfText(this.text, this.pos + length - 1) || !pattern.equalsIgnoreCase(this.text.substring(this.pos, this.pos + length))) continue;
            return i;
        }
        return -1;
    }

    private static boolean isNumberPattern(FormatToken token) {
        if (token == null) {
            return false;
        }
        if (token.isImmediate() && ParserWithContext.isDigit(token.getImmediate().get().charAt(0))) {
            return true;
        }
        return token.isDirective() && token.getFormatDirective().get().isNumeric();
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r';
    }

    private static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static boolean isEndOfText(String text, int pos) {
        return pos >= text.length();
    }

    private static boolean isSign(String text, int pos) {
        return !ParserWithContext.isEndOfText(text, pos) && (text.charAt(pos) == '+' || text.charAt(pos) == '-');
    }

    private static boolean isMinus(String text, int pos) {
        return !ParserWithContext.isEndOfText(text, pos) && text.charAt(pos) == '-';
    }

    private static boolean isBlank(String text, int pos) {
        return !ParserWithContext.isEndOfText(text, pos) && text.charAt(pos) == ' ';
    }

    private static int toInt(char c) {
        return c - 48;
    }
}

