/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

import java.util.Objects;
import java.util.Optional;
import org.embulk.util.rubytime.FormatDirective;
import org.embulk.util.rubytime.FormatDirectiveOptions;

final class FormatToken {
    private final String immediate;
    private final FormatDirective directive;
    private final FormatDirectiveOptions options;

    private FormatToken(String immediate, FormatDirective directive, FormatDirectiveOptions options) {
        this.immediate = immediate;
        this.directive = directive;
        this.options = options;
    }

    static FormatToken directive(String immediate, FormatDirective directive, FormatDirectiveOptions options) {
        return new FormatToken(immediate, directive, options);
    }

    static FormatToken directive(String immediate, FormatDirective directive) {
        return new FormatToken(immediate, directive, FormatDirectiveOptions.EMPTY);
    }

    static FormatToken immediate(char character) {
        return new FormatToken("" + character, null, null);
    }

    static FormatToken immediate(String string) {
        return new FormatToken(string, null, null);
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof FormatToken)) {
            return false;
        }
        FormatToken other = (FormatToken)otherObject;
        return Objects.equals(this.immediate, other.immediate) && Objects.equals((Object)this.directive, (Object)other.directive) && Objects.equals(this.options, other.options);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.immediate, this.directive, this.options});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.directive != null) {
            builder.append("%");
            if (this.options != null) {
                builder.append(this.options.toString());
            }
            builder.append(this.directive.toString());
            if (this.immediate != null) {
                builder.append("[\"").append(this.immediate).append("\"]");
            }
        } else {
            builder.append("\"").append(this.immediate).append("\"");
        }
        return builder.toString();
    }

    boolean isImmediate() {
        return this.directive == null;
    }

    boolean isDirective() {
        return this.directive != null;
    }

    boolean onlyForFormatter() {
        if (this.isImmediate()) {
            return false;
        }
        return this.options.onlyForFormatter();
    }

    Optional<FormatDirective> getFormatDirective() {
        return Optional.ofNullable(this.directive);
    }

    Optional<String> getImmediate() {
        return Optional.ofNullable(this.immediate);
    }

    Optional<FormatDirectiveOptions> getDirectiveOptions() {
        return Optional.ofNullable(this.options);
    }
}

