/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import org.embulk.util.rubytime.RubyTemporalQueryResolver;

public final class RubyTemporalQueries {
    static final TemporalQuery<String> ORIGINAL_TEXT = new OriginalTextQuery();
    static final TemporalQuery<String> ZONE = new ZoneQuery();
    static final TemporalQuery<String> LEFTOVER = new LeftoverQuery();

    private RubyTemporalQueries() {
    }

    public static boolean isSpecificQuery(TemporalQuery<?> query) {
        return query == ORIGINAL_TEXT || query == ZONE || query == LEFTOVER;
    }

    public static TemporalQuery<String> originalText() {
        return ORIGINAL_TEXT;
    }

    public static TemporalQuery<String> zone() {
        return ZONE;
    }

    public static TemporalQuery<String> leftover() {
        return LEFTOVER;
    }

    private static class LeftoverQuery
    implements TemporalQuery<String> {
        private LeftoverQuery() {
        }

        @Override
        public final String queryFrom(TemporalAccessor temporal) {
            if (temporal instanceof RubyTemporalQueryResolver) {
                RubyTemporalQueryResolver resolver = (RubyTemporalQueryResolver)((Object)temporal);
                return resolver.getLeftover();
            }
            return null;
        }
    }

    private static class ZoneQuery
    implements TemporalQuery<String> {
        private ZoneQuery() {
        }

        @Override
        public final String queryFrom(TemporalAccessor temporal) {
            if (temporal instanceof RubyTemporalQueryResolver) {
                RubyTemporalQueryResolver resolver = (RubyTemporalQueryResolver)((Object)temporal);
                return resolver.getZone();
            }
            return null;
        }
    }

    private static class OriginalTextQuery
    implements TemporalQuery<String> {
        private OriginalTextQuery() {
        }

        @Override
        public final String queryFrom(TemporalAccessor temporal) {
            if (temporal instanceof RubyTemporalQueryResolver) {
                RubyTemporalQueryResolver resolver = (RubyTemporalQueryResolver)((Object)temporal);
                return resolver.getOriginalText();
            }
            return null;
        }
    }
}

