/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

public final class RubyDateTimeZones {
    private static final String SUFFIX_STANDARD_TIME = " STANDARD TIME";
    private static final int LENGTH_STANDARD_TIME = " STANDARD TIME".length();
    private static final String SUFFIX_DAYLIGHT_TIME = " DAYLIGHT TIME";
    private static final int LENGTH_DAYLIGHT_TIME = " DAYLIGHT TIME".length();
    private static final String SUFFIX_DST = " DST";
    private static final int LENGTH_DST = " DST".length();
    private static final int MAX_FRACTION = 596523;
    private static final int[] POW_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    private RubyDateTimeZones() {
    }

    public static int toOffsetInSeconds(String zoneName) {
        boolean isDaylightSaving;
        String zoneMain;
        if (zoneName == null) {
            return Integer.MIN_VALUE;
        }
        String normalizedZone = RubyDateTimeZones.normalize(zoneName);
        int normalizedLength = normalizedZone.length();
        if (normalizedZone.endsWith(SUFFIX_STANDARD_TIME)) {
            zoneMain = normalizedZone.substring(0, normalizedLength - LENGTH_STANDARD_TIME);
            isDaylightSaving = false;
        } else if (normalizedZone.endsWith(SUFFIX_DAYLIGHT_TIME)) {
            zoneMain = normalizedZone.substring(0, normalizedLength - LENGTH_DAYLIGHT_TIME);
            isDaylightSaving = true;
        } else if (normalizedZone.endsWith(SUFFIX_DST)) {
            zoneMain = normalizedZone.substring(0, normalizedLength - LENGTH_DST);
            isDaylightSaving = true;
        } else {
            zoneMain = normalizedZone;
            isDaylightSaving = false;
        }
        int offset = RubyDateTimeZones.mapZoneNameToOffsetInSeconds(zoneMain);
        if (offset != Integer.MIN_VALUE) {
            if (isDaylightSaving) {
                return offset + 3600;
            }
            return offset;
        }
        return RubyDateTimeZones.parseOffset(zoneMain);
    }

    static String normalizeForTesting(String zone) {
        return RubyDateTimeZones.normalize(zone);
    }

    static int parseOffsetForTesting(String zoneMain) {
        return RubyDateTimeZones.parseOffset(zoneMain);
    }

    static long parseUnsignedIntUntilNonDigitForTesting(String string, int beginIndex) {
        return RubyDateTimeZones.parseUnsignedIntUntilNonDigit(string, beginIndex);
    }

    static long parseUnsignedIntUntilNonDigitForTesting(String string, int beginIndex, int endIndex) {
        return RubyDateTimeZones.parseUnsignedIntUntilNonDigit(string, beginIndex, endIndex);
    }

    static int mapZoneNameToOffsetInSecondsForTesting(String zone) {
        return RubyDateTimeZones.mapZoneNameToOffsetInSeconds(zone);
    }

    private static String normalize(String original) {
        int originalLength = original.length();
        StringBuilder normalized = null;
        boolean isPreviousSpace = false;
        boolean hasLowerCase = false;
        int beginning = -1;
        int lastNonWhitespace = -1;
        block4: for (int i = 0; i < originalLength; ++i) {
            char c = original.charAt(i);
            switch (c) {
                case ' ': {
                    if (beginning >= 0 && isPreviousSpace) {
                        normalized = RubyDateTimeZones.addToken(normalized, original, originalLength, beginning, lastNonWhitespace);
                        beginning = -1;
                    }
                    isPreviousSpace = true;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': {
                    if (beginning >= 0) {
                        normalized = RubyDateTimeZones.addToken(normalized, original, originalLength, beginning, lastNonWhitespace);
                        beginning = -1;
                    }
                    isPreviousSpace = false;
                    continue block4;
                }
                default: {
                    if (beginning < 0) {
                        beginning = i;
                    }
                    if (Character.isLowerCase(c)) {
                        hasLowerCase = true;
                    }
                    lastNonWhitespace = i;
                    isPreviousSpace = false;
                }
            }
        }
        if (normalized == null) {
            if (beginning == 0 && lastNonWhitespace == originalLength - 1) {
                return RubyDateTimeZones.toUpperCaseIfHasLowerCase(original, hasLowerCase);
            }
            return RubyDateTimeZones.toUpperCaseIfHasLowerCase(original.substring(beginning, lastNonWhitespace + 1), hasLowerCase);
        }
        if (beginning >= 0) {
            normalized = RubyDateTimeZones.addToken(normalized, original, originalLength, beginning, lastNonWhitespace);
        }
        return RubyDateTimeZones.toUpperCaseIfHasLowerCase(normalized.toString(), hasLowerCase);
    }

    private static int parseOffset(String zoneMain) {
        int absoluteOffsetInSeconds;
        char charNextToHour;
        boolean isNegative;
        int length = zoneMain.length();
        int index = zoneMain.startsWith("GMT") || zoneMain.startsWith("UTC") ? 3 : 0;
        if (index >= length) {
            return 0;
        }
        char signCharacter = zoneMain.charAt(index);
        if (signCharacter == '+') {
            isNegative = false;
        } else if (signCharacter == '-') {
            isNegative = true;
        } else {
            return Integer.MIN_VALUE;
        }
        int indexOfHour = ++index;
        long hourResult = RubyDateTimeZones.parseUnsignedIntUntilNonDigit(zoneMain, index);
        int hour = (int)(hourResult & 0xFFFFFFFFL);
        index = (int)(hourResult >> 32);
        char c = charNextToHour = index < length ? zoneMain.charAt(index) : (char)'\u0000';
        if (charNextToHour == ':') {
            int second;
            char charNextToMinute;
            long minuteResult = RubyDateTimeZones.parseUnsignedIntUntilNonDigit(zoneMain, ++index);
            int minute = (int)(minuteResult & 0xFFFFFFFFL);
            index = (int)(minuteResult >> 32);
            char c2 = charNextToMinute = index < length ? zoneMain.charAt(index) : (char)'\u0000';
            if (charNextToMinute == ':') {
                long secondResult = RubyDateTimeZones.parseUnsignedIntUntilNonDigit(zoneMain, ++index);
                second = (int)(secondResult & 0xFFFFFFFFL);
                index = (int)(secondResult >> 32);
            } else {
                second = 0;
            }
            absoluteOffsetInSeconds = second + minute * 60 + hour * 3600;
        } else if (charNextToHour == ',' || charNextToHour == '.') {
            int beginIndex = ++index;
            long fractionResult = RubyDateTimeZones.parseUnsignedIntUntilNonDigit(zoneMain, index);
            int fraction = (int)(fractionResult & 0xFFFFFFFFL);
            index = (int)(fractionResult >> 32);
            int fractionDigits = index - beginIndex;
            if (fractionDigits >= POW_10.length || fraction >= 596523) {
                throw new NumberFormatException("Too long a fraction part in: \"" + zoneMain + "\"");
            }
            int fractionInSeconds = fraction * 3600 / POW_10[fractionDigits];
            absoluteOffsetInSeconds = fractionInSeconds + hour * 3600;
        } else {
            int digits = length - indexOfHour;
            if (digits > 2) {
                int indexOfMinute = indexOfHour + 2 - digits % 2;
                int indexOfSecond = indexOfHour + 4 - digits % 2;
                int endIndex = indexOfHour + 6 - digits % 2;
                long tempHourResult = RubyDateTimeZones.parseUnsignedIntUntilNonDigit(zoneMain, indexOfHour, indexOfMinute);
                int offset = (int)(tempHourResult & 0xFFFFFFFFL) * 3600;
                long tempMinuteResult = RubyDateTimeZones.parseUnsignedIntUntilNonDigit(zoneMain, indexOfMinute, indexOfSecond);
                offset += (int)(tempMinuteResult & 0xFFFFFFFFL) * 60;
                if (digits >= 5) {
                    long secondResult = RubyDateTimeZones.parseUnsignedIntUntilNonDigit(zoneMain, indexOfSecond, endIndex);
                    offset += (int)(secondResult & 0xFFFFFFFFL);
                }
                absoluteOffsetInSeconds = offset;
            } else {
                absoluteOffsetInSeconds = hour * 3600;
            }
        }
        return isNegative ? -absoluteOffsetInSeconds : absoluteOffsetInSeconds;
    }

    private static StringBuilder addToken(StringBuilder normalizedZoneBuilder, String original, int length, int beginning, int lastNonWhitespace) {
        if (normalizedZoneBuilder == null) {
            normalizedZoneBuilder = new StringBuilder(length);
        } else {
            normalizedZoneBuilder.append(' ');
        }
        normalizedZoneBuilder.append(original, beginning, lastNonWhitespace + 1);
        return normalizedZoneBuilder;
    }

    private static String toUpperCaseIfHasLowerCase(String string, boolean hasLowerCase) {
        if (hasLowerCase) {
            return string.toUpperCase();
        }
        return string;
    }

    private static long parseUnsignedIntUntilNonDigit(String string, int beginIndex) {
        return RubyDateTimeZones.parseUnsignedIntUntilNonDigit(string, beginIndex, string.length());
    }

    private static long parseUnsignedIntUntilNonDigit(String string, int beginIndex, int endIndex) {
        int digit;
        int index;
        int overflowThreshold = 0xCCCCCCC;
        int value = 0;
        for (index = beginIndex; index < endIndex && (digit = Character.digit(string.charAt(index), 10)) >= 0 && digit < 10; ++index) {
            int temporaryValue;
            if (value > 0xCCCCCCC) {
                throw new NumberFormatException("Overflown in parsing \"" + string.substring(beginIndex) + "\".");
            }
            value *= 10;
            if ((value += digit) >= (temporaryValue = value)) continue;
            throw new NumberFormatException("Overflown in parsing \"" + string.substring(beginIndex) + "\".");
        }
        return (long)index << 32 | (long)value;
    }

    private static int mapZoneNameToOffsetInSeconds(String zone) {
        switch (zone) {
            case "UT": {
                return 0;
            }
            case "GMT": {
                return 0;
            }
            case "EST": {
                return -18000;
            }
            case "EDT": {
                return -14400;
            }
            case "CST": {
                return -21600;
            }
            case "CDT": {
                return -18000;
            }
            case "MST": {
                return -25200;
            }
            case "MDT": {
                return -21600;
            }
            case "PST": {
                return -28800;
            }
            case "PDT": {
                return -25200;
            }
            case "A": {
                return 3600;
            }
            case "B": {
                return 7200;
            }
            case "C": {
                return 10800;
            }
            case "D": {
                return 14400;
            }
            case "E": {
                return 18000;
            }
            case "F": {
                return 21600;
            }
            case "G": {
                return 25200;
            }
            case "H": {
                return 28800;
            }
            case "I": {
                return 32400;
            }
            case "K": {
                return 36000;
            }
            case "L": {
                return 39600;
            }
            case "M": {
                return 43200;
            }
            case "N": {
                return -3600;
            }
            case "O": {
                return -7200;
            }
            case "P": {
                return -10800;
            }
            case "Q": {
                return -14400;
            }
            case "R": {
                return -18000;
            }
            case "S": {
                return -21600;
            }
            case "T": {
                return -25200;
            }
            case "U": {
                return -28800;
            }
            case "V": {
                return -32400;
            }
            case "W": {
                return -36000;
            }
            case "X": {
                return -39600;
            }
            case "Y": {
                return -43200;
            }
            case "Z": {
                return 0;
            }
            case "UTC": {
                return 0;
            }
            case "WET": {
                return 0;
            }
            case "AT": {
                return -7200;
            }
            case "BRST": {
                return -7200;
            }
            case "NDT": {
                return -9000;
            }
            case "ART": {
                return -10800;
            }
            case "ADT": {
                return -10800;
            }
            case "BRT": {
                return -10800;
            }
            case "CLST": {
                return -10800;
            }
            case "NST": {
                return -12600;
            }
            case "AST": {
                return -14400;
            }
            case "CLT": {
                return -14400;
            }
            case "AKDT": {
                return -28800;
            }
            case "YDT": {
                return -28800;
            }
            case "AKST": {
                return -32400;
            }
            case "HADT": {
                return -32400;
            }
            case "HDT": {
                return -32400;
            }
            case "YST": {
                return -32400;
            }
            case "AHST": {
                return -36000;
            }
            case "CAT": {
                return -36000;
            }
            case "HAST": {
                return -36000;
            }
            case "HST": {
                return -36000;
            }
            case "NT": {
                return -39600;
            }
            case "IDLW": {
                return -43200;
            }
            case "BST": {
                return 3600;
            }
            case "CET": {
                return 3600;
            }
            case "FWT": {
                return 3600;
            }
            case "MET": {
                return 3600;
            }
            case "MEWT": {
                return 3600;
            }
            case "MEZ": {
                return 3600;
            }
            case "SWT": {
                return 3600;
            }
            case "WAT": {
                return 3600;
            }
            case "WEST": {
                return 3600;
            }
            case "CEST": {
                return 7200;
            }
            case "EET": {
                return 7200;
            }
            case "FST": {
                return 7200;
            }
            case "MEST": {
                return 7200;
            }
            case "MESZ": {
                return 7200;
            }
            case "SAST": {
                return 7200;
            }
            case "SST": {
                return 7200;
            }
            case "BT": {
                return 10800;
            }
            case "EAT": {
                return 10800;
            }
            case "EEST": {
                return 10800;
            }
            case "MSK": {
                return 10800;
            }
            case "MSD": {
                return 14400;
            }
            case "ZP4": {
                return 14400;
            }
            case "ZP5": {
                return 18000;
            }
            case "IST": {
                return 19800;
            }
            case "ZP6": {
                return 21600;
            }
            case "WAST": {
                return 25200;
            }
            case "CCT": {
                return 28800;
            }
            case "SGT": {
                return 28800;
            }
            case "WADT": {
                return 28800;
            }
            case "JST": {
                return 32400;
            }
            case "KST": {
                return 32400;
            }
            case "EAST": {
                return 36000;
            }
            case "GST": {
                return 36000;
            }
            case "EADT": {
                return 39600;
            }
            case "IDLE": {
                return 43200;
            }
            case "NZST": {
                return 43200;
            }
            case "NZT": {
                return 43200;
            }
            case "NZDT": {
                return 46800;
            }
            case "AFGHANISTAN": {
                return 16200;
            }
            case "ALASKAN": {
                return -32400;
            }
            case "ARAB": {
                return 10800;
            }
            case "ARABIAN": {
                return 14400;
            }
            case "ARABIC": {
                return 10800;
            }
            case "ATLANTIC": {
                return -14400;
            }
            case "AUS CENTRAL": {
                return 34200;
            }
            case "AUS EASTERN": {
                return 36000;
            }
            case "AZORES": {
                return -3600;
            }
            case "CANADA CENTRAL": {
                return -21600;
            }
            case "CAPE VERDE": {
                return -3600;
            }
            case "CAUCASUS": {
                return 14400;
            }
            case "CEN. AUSTRALIA": {
                return 34200;
            }
            case "CENTRAL AMERICA": {
                return -21600;
            }
            case "CENTRAL ASIA": {
                return 21600;
            }
            case "CENTRAL EUROPE": {
                return 3600;
            }
            case "CENTRAL EUROPEAN": {
                return 3600;
            }
            case "CENTRAL PACIFIC": {
                return 39600;
            }
            case "CENTRAL": {
                return -21600;
            }
            case "CHINA": {
                return 28800;
            }
            case "DATELINE": {
                return -43200;
            }
            case "E. AFRICA": {
                return 10800;
            }
            case "E. AUSTRALIA": {
                return 36000;
            }
            case "E. EUROPE": {
                return 7200;
            }
            case "E. SOUTH AMERICA": {
                return -10800;
            }
            case "EASTERN": {
                return -18000;
            }
            case "EGYPT": {
                return 7200;
            }
            case "EKATERINBURG": {
                return 18000;
            }
            case "FIJI": {
                return 43200;
            }
            case "FLE": {
                return 7200;
            }
            case "GREENLAND": {
                return -10800;
            }
            case "GREENWICH": {
                return 0;
            }
            case "GTB": {
                return 7200;
            }
            case "HAWAIIAN": {
                return -36000;
            }
            case "INDIA": {
                return 19800;
            }
            case "IRAN": {
                return 12600;
            }
            case "JERUSALEM": {
                return 7200;
            }
            case "KOREA": {
                return 32400;
            }
            case "MEXICO": {
                return -21600;
            }
            case "MID-ATLANTIC": {
                return -7200;
            }
            case "MOUNTAIN": {
                return -25200;
            }
            case "MYANMAR": {
                return 23400;
            }
            case "N. CENTRAL ASIA": {
                return 21600;
            }
            case "NEPAL": {
                return 20700;
            }
            case "NEW ZEALAND": {
                return 43200;
            }
            case "NEWFOUNDLAND": {
                return -12600;
            }
            case "NORTH ASIA EAST": {
                return 28800;
            }
            case "NORTH ASIA": {
                return 25200;
            }
            case "PACIFIC SA": {
                return -14400;
            }
            case "PACIFIC": {
                return -28800;
            }
            case "ROMANCE": {
                return 3600;
            }
            case "RUSSIAN": {
                return 10800;
            }
            case "SA EASTERN": {
                return -10800;
            }
            case "SA PACIFIC": {
                return -18000;
            }
            case "SA WESTERN": {
                return -14400;
            }
            case "SAMOA": {
                return -39600;
            }
            case "SE ASIA": {
                return 25200;
            }
            case "MALAY PENINSULA": {
                return 28800;
            }
            case "SOUTH AFRICA": {
                return 7200;
            }
            case "SRI LANKA": {
                return 21600;
            }
            case "TAIPEI": {
                return 28800;
            }
            case "TASMANIA": {
                return 36000;
            }
            case "TOKYO": {
                return 32400;
            }
            case "TONGA": {
                return 46800;
            }
            case "US EASTERN": {
                return -18000;
            }
            case "US MOUNTAIN": {
                return -25200;
            }
            case "VLADIVOSTOK": {
                return 36000;
            }
            case "W. AUSTRALIA": {
                return 28800;
            }
            case "W. CENTRAL AFRICA": {
                return 3600;
            }
            case "W. EUROPE": {
                return 3600;
            }
            case "WEST ASIA": {
                return 18000;
            }
            case "WEST PACIFIC": {
                return 36000;
            }
            case "YAKUTSK": {
                return 32400;
            }
        }
        return Integer.MIN_VALUE;
    }
}

