/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

import java.math.BigDecimal;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.embulk.util.rubytime.RubyChronoFields;
import org.embulk.util.rubytime.RubyDateTimeZones;
import org.embulk.util.rubytime.RubyTemporalQueries;

public final class RubyDateTimeParsedElementsQuery<T>
implements TemporalQuery<Map<T, Object>> {
    private static final FractionalSecondToBigDecimalConverter FRACTIONAL_SECOND_TO_BIG_DECIMAL = new FractionalSecondToBigDecimalConverter();
    private static final MillisecondToBigDecimalConverter MILLISECOND_TO_BIG_DECIMAL = new MillisecondToBigDecimalConverter();
    private static final StringAsIs STRING_AS_IS = new StringAsIs();
    private final FractionalSecondConverter fractionalSecondConverter;
    private final MillisecondConverter millisecondConverter;
    private final MapKeyConverter<T> mapKeyConverter;

    private RubyDateTimeParsedElementsQuery(FractionalSecondConverter fractionalSecondConverter, MillisecondConverter millisecondConverter, MapKeyConverter<T> mapKeyConverter) {
        this.fractionalSecondConverter = fractionalSecondConverter;
        this.millisecondConverter = millisecondConverter;
        this.mapKeyConverter = mapKeyConverter;
    }

    public static RubyDateTimeParsedElementsQuery<String> withBigDecimal() {
        return new RubyDateTimeParsedElementsQuery<String>(FRACTIONAL_SECOND_TO_BIG_DECIMAL, MILLISECOND_TO_BIG_DECIMAL, STRING_AS_IS);
    }

    public static RubyDateTimeParsedElementsQuery<String> with(FractionalSecondConverter fractionalSecondConverter, MillisecondConverter millisecondConverter) {
        return new RubyDateTimeParsedElementsQuery<String>(fractionalSecondConverter, millisecondConverter, STRING_AS_IS);
    }

    public static <U> RubyDateTimeParsedElementsQuery<U> with(FractionalSecondConverter fractionalSecondConverter, MillisecondConverter millisecondConverter, MapKeyConverter<U> mapKeyConverter) {
        return new RubyDateTimeParsedElementsQuery<U>(fractionalSecondConverter, millisecondConverter, mapKeyConverter);
    }

    @Override
    public Map<T, Object> queryFrom(TemporalAccessor temporal) {
        Builder builder = new Builder(temporal, this.fractionalSecondConverter, this.millisecondConverter, this.mapKeyConverter);
        builder.put("mday", ChronoField.DAY_OF_MONTH);
        builder.put("cwyear", RubyChronoFields.WEEK_BASED_YEAR);
        builder.putHourOfDay();
        builder.put("yday", ChronoField.DAY_OF_YEAR);
        builder.putSecFraction();
        builder.put("min", ChronoField.MINUTE_OF_HOUR);
        builder.put("mon", ChronoField.MONTH_OF_YEAR);
        builder.putSinceEpoch();
        builder.putSecondOfMinute();
        builder.put("wnum0", RubyChronoFields.WEEK_OF_YEAR_STARTING_WITH_SUNDAY);
        builder.put("wnum1", RubyChronoFields.WEEK_OF_YEAR_STARTING_WITH_MONDAY);
        builder.put("cwday", RubyChronoFields.DAY_OF_WEEK_STARTING_WITH_MONDAY_1);
        builder.put("cweek", RubyChronoFields.WEEK_OF_WEEK_BASED_YEAR);
        builder.put("wday", RubyChronoFields.DAY_OF_WEEK_STARTING_WITH_SUNDAY_0);
        builder.put("year", ChronoField.YEAR);
        builder.putTimeZone();
        builder.putLeftover();
        return builder.build();
    }

    private static final class StringAsIs
    implements MapKeyConverter<String> {
        private StringAsIs() {
        }

        @Override
        public String convertMapKey(String mapKey) {
            return mapKey;
        }
    }

    private static final class MillisecondToBigDecimalConverter
    implements MillisecondConverter {
        private MillisecondToBigDecimalConverter() {
        }

        @Override
        public Object convertMillisecond(long millisecond) {
            return BigDecimal.valueOf(millisecond, 3);
        }
    }

    private static final class FractionalSecondToBigDecimalConverter
    implements FractionalSecondConverter {
        private FractionalSecondToBigDecimalConverter() {
        }

        @Override
        public Object convertFractionalSecond(long integer, int nano) {
            return BigDecimal.valueOf(integer).add(BigDecimal.valueOf(nano, 9));
        }
    }

    private static class Builder<T> {
        private final TemporalAccessor temporal;
        private final FractionalSecondConverter fractionalSecondConverterInner;
        private final MillisecondConverter millisecondConverterInner;
        private final MapKeyConverter<T> mapKeyConverter;
        private final HashMap<T, Object> built;

        private Builder(TemporalAccessor temporal, FractionalSecondConverter fractionalSecondConverterInner, MillisecondConverter millisecondConverterInner, MapKeyConverter<T> mapKeyConverter) {
            this.temporal = temporal;
            this.fractionalSecondConverterInner = fractionalSecondConverterInner;
            this.millisecondConverterInner = millisecondConverterInner;
            this.mapKeyConverter = mapKeyConverter;
            this.built = new HashMap();
        }

        private void put(String key, TemporalField field) {
            if (this.temporal.isSupported(field)) {
                this.built.put(this.mapKeyConverter.convertMapKey(key), this.temporal.get(field));
            }
        }

        private void putHourOfDay() {
            if (this.temporal.isSupported(ChronoField.HOUR_OF_DAY)) {
                Period parsedExcessDays = this.temporal.query(DateTimeFormatter.parsedExcessDays());
                if (parsedExcessDays == null || parsedExcessDays.isZero()) {
                    this.built.put(this.mapKeyConverter.convertMapKey("hour"), this.temporal.get(ChronoField.HOUR_OF_DAY));
                } else if (parsedExcessDays.getDays() == 1 && parsedExcessDays.getMonths() == 0 && parsedExcessDays.getYears() == 0) {
                    this.built.put(this.mapKeyConverter.convertMapKey("hour"), 24);
                }
            }
        }

        private void putSecondOfMinute() {
            if (this.temporal.isSupported(ChronoField.SECOND_OF_MINUTE)) {
                if (this.temporal.query(DateTimeFormatter.parsedLeapSecond()).booleanValue()) {
                    this.built.put(this.mapKeyConverter.convertMapKey("sec"), 60);
                } else {
                    this.built.put(this.mapKeyConverter.convertMapKey("sec"), this.temporal.get(ChronoField.SECOND_OF_MINUTE));
                }
            }
        }

        private void putSecFraction() {
            if (this.temporal.isSupported(ChronoField.NANO_OF_SECOND)) {
                this.built.put(this.mapKeyConverter.convertMapKey("sec_fraction"), this.fractionalSecondConverterInner.convertFractionalSecond(0L, this.temporal.get(ChronoField.NANO_OF_SECOND)));
            }
        }

        private void putSinceEpoch() {
            if (this.temporal.isSupported(RubyChronoFields.INSTANT_MILLIS)) {
                long instantMillis = this.temporal.getLong(RubyChronoFields.INSTANT_MILLIS);
                this.built.put(this.mapKeyConverter.convertMapKey("seconds"), this.millisecondConverterInner.convertMillisecond(instantMillis));
            } else if (this.temporal.isSupported(ChronoField.INSTANT_SECONDS)) {
                long instantSeconds = this.temporal.getLong(ChronoField.INSTANT_SECONDS);
                this.built.put(this.mapKeyConverter.convertMapKey("seconds"), instantSeconds);
            }
        }

        private void putTimeZone() {
            String zone = this.temporal.query(RubyTemporalQueries.zone());
            if (zone != null) {
                int offset = RubyDateTimeZones.toOffsetInSeconds(zone);
                if (offset != Integer.MIN_VALUE) {
                    this.built.put(this.mapKeyConverter.convertMapKey("offset"), offset);
                }
                this.built.put(this.mapKeyConverter.convertMapKey("zone"), zone);
            }
        }

        private void putLeftover() {
            String leftover = this.temporal.query(RubyTemporalQueries.leftover());
            if (leftover != null) {
                this.built.put(this.mapKeyConverter.convertMapKey("leftover"), leftover);
            }
        }

        private Map<T, Object> build() {
            return Collections.unmodifiableMap(this.built);
        }
    }

    public static interface MapKeyConverter<T> {
        public T convertMapKey(String var1);
    }

    public static interface MillisecondConverter {
        public Object convertMillisecond(long var1);
    }

    public static interface FractionalSecondConverter {
        public Object convertFractionalSecond(long var1, int var3);
    }
}

