/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.embulk.util.rubytime.RubyChronoFields;
import org.embulk.util.rubytime.RubyTemporalQueries;
import org.embulk.util.rubytime.RubyTemporalQueryResolver;

final class Parsed
implements TemporalAccessor,
RubyTemporalQueryResolver {
    private final String originalString;
    private final EnumMap<ChronoField, Long> chronoFieldValues;
    private final EnumMap<RubyChronoFields.Field, Long> rubyChronoFieldValues;
    private final String timeZoneName;
    private final String leftover;
    private final Period parsedExcessDays;
    private final boolean parsedLeapSecond;

    private Parsed(String originalString, int dayOfMonth, int weekBasedYear, int hour, int dayOfYear, int nanoOfSecond, int minuteOfHour, int monthOfYear, long secondsSinceEpoch, long millisecondsSinceEpoch, int secondOfMinute, int weekOfYearStartingWithSunday, int weekOfYearStartingWithMonday, int dayOfWeekStartingWithMonday1, int weekOfWeekBasedYear, int dayOfWeekStartingWithSunday0, int year, String timeZoneName, String leftover, Period parsedExcessDays, boolean parsedLeapSecond) {
        this.originalString = originalString;
        this.chronoFieldValues = new EnumMap(ChronoField.class);
        this.rubyChronoFieldValues = new EnumMap(RubyChronoFields.Field.class);
        if (dayOfMonth > Integer.MIN_VALUE) {
            this.chronoFieldValues.put(ChronoField.DAY_OF_MONTH, Long.valueOf(dayOfMonth));
        }
        if (weekBasedYear > Integer.MIN_VALUE) {
            this.rubyChronoFieldValues.put(RubyChronoFields.Field.WEEK_BASED_YEAR, Long.valueOf(weekBasedYear));
        }
        if (hour > Integer.MIN_VALUE) {
            this.chronoFieldValues.put(ChronoField.HOUR_OF_DAY, Long.valueOf(hour));
        }
        if (dayOfYear > Integer.MIN_VALUE) {
            this.chronoFieldValues.put(ChronoField.DAY_OF_YEAR, Long.valueOf(dayOfYear));
        }
        if (nanoOfSecond > Integer.MIN_VALUE) {
            this.chronoFieldValues.put(ChronoField.NANO_OF_SECOND, Long.valueOf(nanoOfSecond));
        }
        if (minuteOfHour > Integer.MIN_VALUE) {
            this.chronoFieldValues.put(ChronoField.MINUTE_OF_HOUR, Long.valueOf(minuteOfHour));
        }
        if (monthOfYear > Integer.MIN_VALUE) {
            this.chronoFieldValues.put(ChronoField.MONTH_OF_YEAR, Long.valueOf(monthOfYear));
        }
        if (secondsSinceEpoch > Long.MIN_VALUE) {
            this.chronoFieldValues.put(ChronoField.INSTANT_SECONDS, secondsSinceEpoch);
        }
        if (millisecondsSinceEpoch > Long.MIN_VALUE) {
            this.rubyChronoFieldValues.put(RubyChronoFields.Field.INSTANT_MILLIS, millisecondsSinceEpoch);
        }
        if (secondOfMinute > Integer.MIN_VALUE) {
            this.chronoFieldValues.put(ChronoField.SECOND_OF_MINUTE, Long.valueOf(secondOfMinute));
        }
        if (weekOfYearStartingWithSunday > Integer.MIN_VALUE) {
            this.rubyChronoFieldValues.put(RubyChronoFields.Field.WEEK_OF_YEAR_STARTING_WITH_SUNDAY, Long.valueOf(weekOfYearStartingWithSunday));
        }
        if (weekOfYearStartingWithMonday > Integer.MIN_VALUE) {
            this.rubyChronoFieldValues.put(RubyChronoFields.Field.WEEK_OF_YEAR_STARTING_WITH_MONDAY, Long.valueOf(weekOfYearStartingWithMonday));
        }
        if (dayOfWeekStartingWithMonday1 > Integer.MIN_VALUE) {
            this.rubyChronoFieldValues.put(RubyChronoFields.Field.DAY_OF_WEEK_STARTING_WITH_MONDAY_1, Long.valueOf(dayOfWeekStartingWithMonday1));
        }
        if (weekOfWeekBasedYear > Integer.MIN_VALUE) {
            this.rubyChronoFieldValues.put(RubyChronoFields.Field.WEEK_OF_WEEK_BASED_YEAR, Long.valueOf(weekOfWeekBasedYear));
        }
        if (dayOfWeekStartingWithSunday0 > Integer.MIN_VALUE) {
            this.rubyChronoFieldValues.put(RubyChronoFields.Field.DAY_OF_WEEK_STARTING_WITH_SUNDAY_0, Long.valueOf(dayOfWeekStartingWithSunday0));
        }
        if (year > Integer.MIN_VALUE) {
            this.chronoFieldValues.put(ChronoField.YEAR, Long.valueOf(year));
        }
        this.timeZoneName = timeZoneName;
        this.leftover = leftover;
        this.parsedExcessDays = parsedExcessDays;
        this.parsedLeapSecond = parsedLeapSecond;
    }

    static Builder builder(String originalString) {
        return new Builder(originalString);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            Long value = this.chronoFieldValues.get(field);
            if (value == null) {
                throw new UnsupportedTemporalTypeException("");
            }
            return value;
        }
        if (field instanceof RubyChronoFields.Field) {
            Long value = this.rubyChronoFieldValues.get(field);
            if (value == null) {
                throw new UnsupportedTemporalTypeException("");
            }
            return value;
        }
        throw new UnsupportedTemporalTypeException("");
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return this.chronoFieldValues.containsKey(field);
        }
        if (field instanceof RubyChronoFields.Field) {
            return this.rubyChronoFieldValues.containsKey(field);
        }
        throw new UnsupportedTemporalTypeException("");
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == DateTimeFormatter.parsedExcessDays()) {
            return (R)this.parsedExcessDays;
        }
        if (query == DateTimeFormatter.parsedLeapSecond()) {
            return (R)Boolean.valueOf(this.parsedLeapSecond);
        }
        if (RubyTemporalQueries.isSpecificQuery(query)) {
            return query.queryFrom(this);
        }
        return TemporalAccessor.super.query(query);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof RubyChronoFields.Field && this.isSupported(field)) {
            return field.range();
        }
        return TemporalAccessor.super.range(field);
    }

    @Override
    public String getOriginalText() {
        return this.originalString;
    }

    @Override
    public String getZone() {
        return this.timeZoneName;
    }

    @Override
    public String getLeftover() {
        return this.leftover;
    }

    static class Builder {
        private static final Map<String, Integer> DAY_OF_WEEK_NAMES;
        private static final Map<String, Integer> MONTH_OF_YEAR_NAMES;
        private static final String[] DAY_OF_WEEK_FULL_NAMES;
        private static final String[] DAY_OF_WEEK_ABBREVIATED_NAMES;
        private static final String[] MONTH_OF_YEAR_FULL_NAMES;
        private static final String[] MONTH_OF_YEAR_ABBREVIATED_NAMES;
        private final String originalString;
        private int century;
        private int dayOfMonth;
        private int weekBasedYear;
        private int hour;
        private int dayOfYear;
        private int nanoOfSecond;
        private int minuteOfHour;
        private int monthOfYear;
        private int ampmOfDay;
        private long secondsSinceEpoch;
        private long millisecondsSinceEpoch;
        private int secondOfMinute;
        private int weekOfYearStartingWithSunday;
        private int weekOfYearStartingWithMonday;
        private int dayOfWeekStartingWithMonday1;
        private int weekOfWeekBasedYear;
        private int dayOfWeekStartingWithSunday0;
        private int year;
        private String timeZoneName;
        private String leftover;
        private boolean fail;

        Builder(String originalString) {
            this.originalString = originalString;
            this.century = Integer.MIN_VALUE;
            this.dayOfMonth = Integer.MIN_VALUE;
            this.weekBasedYear = Integer.MIN_VALUE;
            this.hour = Integer.MIN_VALUE;
            this.dayOfYear = Integer.MIN_VALUE;
            this.nanoOfSecond = Integer.MIN_VALUE;
            this.minuteOfHour = Integer.MIN_VALUE;
            this.monthOfYear = Integer.MIN_VALUE;
            this.ampmOfDay = Integer.MIN_VALUE;
            this.secondsSinceEpoch = Long.MIN_VALUE;
            this.millisecondsSinceEpoch = Long.MIN_VALUE;
            this.secondOfMinute = Integer.MIN_VALUE;
            this.weekOfYearStartingWithSunday = Integer.MIN_VALUE;
            this.weekOfYearStartingWithMonday = Integer.MIN_VALUE;
            this.dayOfWeekStartingWithMonday1 = Integer.MIN_VALUE;
            this.weekOfWeekBasedYear = Integer.MIN_VALUE;
            this.dayOfWeekStartingWithSunday0 = Integer.MIN_VALUE;
            this.year = Integer.MIN_VALUE;
            this.timeZoneName = null;
            this.leftover = null;
            this.fail = false;
        }

        Parsed build() {
            Period parsedExcessDays;
            int hourWithAmPm;
            int weekBasedYearWithCentury = this.century != Integer.MIN_VALUE && this.weekBasedYear != Integer.MIN_VALUE ? this.century * 100 + this.weekBasedYear : this.weekBasedYear;
            int yearWithCentury = this.century != Integer.MIN_VALUE && this.year != Integer.MIN_VALUE ? this.century * 100 + this.year : this.year;
            if (this.hour != Integer.MIN_VALUE && this.ampmOfDay != Integer.MIN_VALUE) {
                hourWithAmPm = this.hour % 12 + this.ampmOfDay;
                parsedExcessDays = null;
            } else if (this.hour == 24) {
                hourWithAmPm = 0;
                parsedExcessDays = Period.ofDays(1);
            } else {
                hourWithAmPm = this.hour;
                parsedExcessDays = null;
            }
            return new Parsed(this.originalString, this.dayOfMonth, weekBasedYearWithCentury, hourWithAmPm, this.dayOfYear, this.nanoOfSecond, this.minuteOfHour, this.monthOfYear, this.secondsSinceEpoch, this.millisecondsSinceEpoch, this.secondOfMinute == 60 ? 59 : this.secondOfMinute, this.weekOfYearStartingWithSunday, this.weekOfYearStartingWithMonday, this.dayOfWeekStartingWithMonday1, this.weekOfWeekBasedYear, this.dayOfWeekStartingWithSunday0, yearWithCentury, this.timeZoneName, this.leftover, parsedExcessDays, this.secondOfMinute == 60);
        }

        Builder setDayOfWeekByName(String dayOfWeekByName) {
            Integer dayOfWeek = DAY_OF_WEEK_NAMES.get(dayOfWeekByName);
            if (dayOfWeek == null) {
                this.fail = true;
            } else {
                this.dayOfWeekStartingWithSunday0 = dayOfWeek;
            }
            return this;
        }

        Builder setMonthOfYearByName(String monthOfYearByName) {
            Integer monthOfYear = MONTH_OF_YEAR_NAMES.get(monthOfYearByName);
            if (monthOfYear == null) {
                this.fail = true;
            } else {
                this.monthOfYear = monthOfYear;
            }
            return this;
        }

        Builder setCentury(int century) {
            this.century = century;
            return this;
        }

        Builder setDayOfMonth(int dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        Builder setWeekBasedYear(int weekBasedYear) {
            this.weekBasedYear = weekBasedYear;
            return this;
        }

        Builder setWeekBasedYearWithoutCentury(int weekBasedYearWithoutCentury) {
            this.weekBasedYear = weekBasedYearWithoutCentury;
            if (this.century == Integer.MIN_VALUE) {
                this.century = weekBasedYearWithoutCentury >= 69 ? 19 : 20;
            }
            return this;
        }

        Builder setHour(int hour) {
            this.hour = hour;
            return this;
        }

        Builder setDayOfYear(int dayOfYear) {
            this.dayOfYear = dayOfYear;
            return this;
        }

        Builder setNanoOfSecond(int nanoOfSecond) {
            this.nanoOfSecond = nanoOfSecond;
            return this;
        }

        Builder setMinuteOfHour(int minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
            return this;
        }

        Builder setMonthOfYear(int monthOfYear) {
            this.monthOfYear = monthOfYear;
            return this;
        }

        Builder setAmPmOfDay(int ampmOfDay) {
            this.ampmOfDay = ampmOfDay;
            return this;
        }

        Builder setSecondsSinceEpoch(long secondsSinceEpoch) {
            this.secondsSinceEpoch = secondsSinceEpoch;
            this.millisecondsSinceEpoch = Long.MIN_VALUE;
            return this;
        }

        Builder setMillisecondsSinceEpoch(long millisecondsSinceEpoch) {
            this.secondsSinceEpoch = Math.floorDiv(millisecondsSinceEpoch, 1000L);
            this.millisecondsSinceEpoch = millisecondsSinceEpoch;
            return this;
        }

        Builder setSecondOfMinute(int secondOfMinute) {
            this.secondOfMinute = secondOfMinute;
            return this;
        }

        Builder setWeekOfYearStartingWithSunday(int weekOfYearStartingWithSunday) {
            this.weekOfYearStartingWithSunday = weekOfYearStartingWithSunday;
            return this;
        }

        Builder setWeekOfYearStartingWithMonday(int weekOfYearStartingWithMonday) {
            this.weekOfYearStartingWithMonday = weekOfYearStartingWithMonday;
            return this;
        }

        Builder setDayOfWeekStartingWithMonday1(int dayOfWeekStartingWithMonday1) {
            this.dayOfWeekStartingWithMonday1 = dayOfWeekStartingWithMonday1;
            return this;
        }

        Builder setWeekOfWeekBasedYear(int weekOfWeekBasedYear) {
            this.weekOfWeekBasedYear = weekOfWeekBasedYear;
            return this;
        }

        Builder setDayOfWeekStartingWithSunday0(int dayOfWeekStartingWithSunday0) {
            this.dayOfWeekStartingWithSunday0 = dayOfWeekStartingWithSunday0;
            return this;
        }

        Builder setYear(int year) {
            this.year = year;
            return this;
        }

        Builder setYearWithoutCentury(int yearWithoutCentury) {
            this.year = yearWithoutCentury;
            if (this.century == Integer.MIN_VALUE) {
                this.century = yearWithoutCentury >= 69 ? 19 : 20;
            }
            return this;
        }

        Builder setTimeOffset(String timeZoneName) {
            this.timeZoneName = timeZoneName;
            return this;
        }

        Builder setLeftover(String leftover) {
            this.leftover = leftover;
            return this;
        }

        static {
            int i;
            int i2;
            DAY_OF_WEEK_FULL_NAMES = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
            DAY_OF_WEEK_ABBREVIATED_NAMES = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
            MONTH_OF_YEAR_FULL_NAMES = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
            MONTH_OF_YEAR_ABBREVIATED_NAMES = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
            HashMap<String, Integer> dayOfWeekNamesBuilt = new HashMap<String, Integer>();
            for (i2 = 0; i2 < DAY_OF_WEEK_FULL_NAMES.length; ++i2) {
                dayOfWeekNamesBuilt.put(DAY_OF_WEEK_FULL_NAMES[i2], i2);
            }
            for (i2 = 0; i2 < DAY_OF_WEEK_ABBREVIATED_NAMES.length; ++i2) {
                dayOfWeekNamesBuilt.put(DAY_OF_WEEK_ABBREVIATED_NAMES[i2], i2);
            }
            DAY_OF_WEEK_NAMES = Collections.unmodifiableMap(dayOfWeekNamesBuilt);
            HashMap<String, Integer> monthOfYearNamesBuilt = new HashMap<String, Integer>();
            for (i = 0; i < MONTH_OF_YEAR_FULL_NAMES.length; ++i) {
                monthOfYearNamesBuilt.put(MONTH_OF_YEAR_FULL_NAMES[i], i + 1);
            }
            for (i = 0; i < MONTH_OF_YEAR_ABBREVIATED_NAMES.length; ++i) {
                monthOfYearNamesBuilt.put(MONTH_OF_YEAR_ABBREVIATED_NAMES[i], i + 1);
            }
            MONTH_OF_YEAR_NAMES = Collections.unmodifiableMap(monthOfYearNamesBuilt);
        }
    }
}

