/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.embulk.util.rubytime.FormatDirective;
import org.embulk.util.rubytime.FormatDirectiveOptions;
import org.embulk.util.rubytime.FormatToken;

final class Format
implements Iterable<TokenWithNext> {
    private final List<FormatToken> compiledPattern;
    private final boolean onlyForFormatter;

    private Format(List<FormatToken> compiledPattern) {
        this.compiledPattern = Collections.unmodifiableList(compiledPattern);
        boolean onlyForFormatter = false;
        for (FormatToken token : compiledPattern) {
            if (!token.onlyForFormatter()) continue;
            onlyForFormatter = true;
        }
        this.onlyForFormatter = onlyForFormatter;
    }

    public static Format compile(String formatString) {
        return new Format(Compiler.compile(formatString));
    }

    static Format createForTesting(List<FormatToken> compiledPattern) {
        return new Format(compiledPattern);
    }

    boolean onlyForFormatter() {
        return this.onlyForFormatter;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof Format)) {
            return false;
        }
        Format other = (Format)otherObject;
        return this.compiledPattern.equals(other.compiledPattern);
    }

    public int hashCode() {
        return Objects.hash(this.compiledPattern);
    }

    public String toString() {
        return this.compiledPattern.toString();
    }

    @Override
    public Iterator<TokenWithNext> iterator() {
        return new TokenIterator(this.compiledPattern.iterator());
    }

    private static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static class TokenIterator
    implements Iterator<TokenWithNext> {
        private final Iterator<FormatToken> internalIterator;
        private FormatToken next;

        private TokenIterator(Iterator<FormatToken> initialIterator) {
            this.internalIterator = initialIterator;
            this.next = initialIterator.hasNext() ? initialIterator.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public TokenWithNext next() {
            TokenWithNext tokenWithNext = this.internalIterator.hasNext() ? new TokenWithNext(this.next, this.internalIterator.next()) : new TokenWithNext(this.next, null);
            this.next = tokenWithNext.getNextToken();
            return tokenWithNext;
        }
    }

    private static class Compiler {
        private final String formatString;
        private int index;
        private List<FormatToken> resultTokens;
        private StringBuilder rawStringBuffer;

        private Compiler(String formatString) {
            this.formatString = formatString;
        }

        public static List<FormatToken> compile(String formatString) {
            return new Compiler(formatString).compileInitial();
        }

        private List<FormatToken> compileInitial() {
            this.index = 0;
            this.resultTokens = new ArrayList<FormatToken>();
            this.rawStringBuffer = new StringBuilder();
            block3: while (this.index < this.formatString.length()) {
                char cur = this.formatString.charAt(this.index);
                switch (cur) {
                    case '%': {
                        if (this.rawStringBuffer.length() > 0) {
                            this.resultTokens.add(FormatToken.immediate(this.rawStringBuffer.toString()));
                        }
                        this.rawStringBuffer = new StringBuilder();
                        ++this.index;
                        if (this.compileDirective(this.index)) continue block3;
                        this.rawStringBuffer.append(cur);
                        continue block3;
                    }
                }
                this.rawStringBuffer.append(cur);
                ++this.index;
            }
            if (this.rawStringBuffer.length() > 0) {
                this.resultTokens.add(FormatToken.immediate(this.rawStringBuffer.toString()));
            }
            return Collections.unmodifiableList(this.resultTokens);
        }

        private boolean compileDirective(int beginningIndex) {
            FormatDirectiveOptions.Builder optionsBuilder = FormatDirectiveOptions.builder();
            block12: for (int cursorIndex = beginningIndex; cursorIndex < this.formatString.length(); ++cursorIndex) {
                char cur = this.formatString.charAt(cursorIndex);
                switch (cur) {
                    case '%': 
                    case '+': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'g': 
                    case 'h': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'p': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.resultTokens.add(FormatToken.directive("%" + this.formatString.substring(beginningIndex, cursorIndex + 1), FormatDirective.of(cur), optionsBuilder.build()));
                        this.index = cursorIndex + 1;
                        return true;
                    }
                    case 'E': {
                        if (cursorIndex + 1 < this.formatString.length() && "cCxXyY".indexOf(this.formatString.charAt(cursorIndex + 1)) >= 0) continue block12;
                        return false;
                    }
                    case 'O': {
                        if (cursorIndex + 1 < this.formatString.length() && "deHImMSuUVwWy".indexOf(this.formatString.charAt(cursorIndex + 1)) >= 0) continue block12;
                        return false;
                    }
                    case '-': {
                        if (optionsBuilder.isPrecisionSpecified()) {
                            return false;
                        }
                        optionsBuilder.setLeft();
                        continue block12;
                    }
                    case '^': {
                        if (optionsBuilder.isPrecisionSpecified()) {
                            return false;
                        }
                        optionsBuilder.setUpper();
                        continue block12;
                    }
                    case '#': {
                        if (optionsBuilder.isPrecisionSpecified()) {
                            return false;
                        }
                        optionsBuilder.setChCase();
                        continue block12;
                    }
                    case '_': {
                        if (optionsBuilder.isPrecisionSpecified()) {
                            return false;
                        }
                        optionsBuilder.setPadding(' ');
                        continue block12;
                    }
                    case ':': {
                        int i = 1;
                        while (true) {
                            if (cursorIndex + i >= this.formatString.length()) {
                                return false;
                            }
                            if (this.formatString.charAt(cursorIndex + i) == 'z') {
                                optionsBuilder.setColons(i);
                                cursorIndex += i - 1;
                                continue block12;
                            }
                            if (this.formatString.charAt(cursorIndex + i) != ':') {
                                return false;
                            }
                            ++i;
                        }
                    }
                    case '0': {
                        optionsBuilder.setPadding('0');
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        String digits = this.consumeDigits(cursorIndex);
                        if (digits == null) {
                            return false;
                        }
                        optionsBuilder.setPrecision(Integer.parseInt(digits));
                        cursorIndex += digits.length() - 1;
                        continue block12;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }

        private String consumeDigits(int start) {
            long parsedLong;
            int endDigit;
            int startNonZero;
            for (startNonZero = start; startNonZero < this.formatString.length() && this.formatString.charAt(startNonZero) == '0'; ++startNonZero) {
            }
            for (endDigit = startNonZero; endDigit < this.formatString.length() && Format.isDigit(this.formatString.charAt(endDigit)); ++endDigit) {
            }
            if (endDigit - startNonZero > 10) {
                return null;
            }
            String digits = this.formatString.substring(startNonZero, endDigit);
            if (endDigit > startNonZero && (parsedLong = Long.parseLong(digits)) > Integer.MAX_VALUE) {
                return null;
            }
            return this.formatString.substring(start, endDigit);
        }
    }

    static class TokenWithNext {
        private final FormatToken token;
        private final FormatToken nextToken;

        private TokenWithNext(FormatToken token, FormatToken nextToken) {
            this.token = token;
            this.nextToken = nextToken;
        }

        FormatToken getToken() {
            return this.token;
        }

        FormatToken getNextToken() {
            return this.nextToken;
        }
    }
}

