/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.retryhelper;

import org.embulk.util.retryhelper.RetryGiveupException;
import org.embulk.util.retryhelper.Retryable;

public class RetryExecutor {
    private static final int DEFAULT_RETRY_LIMIT = 3;
    private static final int DEFAULT_INITIAL_RETRY_WAIT_MILLIS = 500;
    private static final int DEFAULT_MAX_RETRY_WAIT_MILLIS = 1800000;
    private final int retryLimit;
    private final int initialRetryWait;
    private final int maxRetryWait;

    private RetryExecutor(int retryLimit, int initialRetryWait, int maxRetryWait) {
        this.retryLimit = retryLimit;
        this.initialRetryWait = initialRetryWait;
        this.maxRetryWait = maxRetryWait;
    }

    public static RetryExecutor ofDefault() {
        return new RetryExecutor(3, 500, 1800000);
    }

    @Deprecated
    public static RetryExecutor retryExecutor() {
        return RetryExecutor.ofDefault();
    }

    @Deprecated
    public RetryExecutor withRetryLimit(int count) {
        return new RetryExecutor(count, this.initialRetryWait, this.maxRetryWait);
    }

    @Deprecated
    public RetryExecutor withInitialRetryWait(int msec) {
        return new RetryExecutor(this.retryLimit, msec, this.maxRetryWait);
    }

    @Deprecated
    public RetryExecutor withMaxRetryWait(int msec) {
        return new RetryExecutor(this.retryLimit, this.initialRetryWait, msec);
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T runInterruptible(Retryable<T> op) throws InterruptedException, RetryGiveupException {
        return this.run(op, true);
    }

    public <T> T run(Retryable<T> op) throws RetryGiveupException {
        try {
            return this.run(op, false);
        }
        catch (InterruptedException ex) {
            throw new RetryGiveupException("Unexpected interruption", ex);
        }
    }

    private <T> T run(Retryable<T> op, boolean interruptible) throws InterruptedException, RetryGiveupException {
        int retryWait = this.initialRetryWait;
        int retryCount = 0;
        Exception firstException = null;
        while (true) {
            try {
                return op.call();
            }
            catch (Exception exception) {
                block7: {
                    if (firstException == null) {
                        firstException = exception;
                    }
                    if (!op.isRetryableException(exception) || retryCount >= this.retryLimit) {
                        op.onGiveup(firstException, exception);
                        throw new RetryGiveupException(firstException);
                    }
                    op.onRetry(exception, ++retryCount, this.retryLimit, retryWait);
                    try {
                        Thread.sleep(retryWait);
                    }
                    catch (InterruptedException ex) {
                        if (!interruptible) break block7;
                        throw ex;
                    }
                }
                if ((retryWait *= 2) <= this.maxRetryWait) continue;
                retryWait = this.maxRetryWait;
                continue;
            }
            break;
        }
    }

    public static class Builder {
        private int retryLimit = 3;
        private int initialRetryWaitMillis = 500;
        private int maxRetryWaitMillis = 1800000;

        Builder() {
        }

        public Builder withRetryLimit(int retryLimit) {
            this.retryLimit = retryLimit;
            return this;
        }

        public Builder withInitialRetryWaitMillis(int initialRetryWaitMillis) {
            this.initialRetryWaitMillis = initialRetryWaitMillis;
            return this;
        }

        public Builder withMaxRetryWaitMillis(int maxRetryWaitMillis) {
            this.maxRetryWaitMillis = maxRetryWaitMillis;
            return this;
        }

        public RetryExecutor build() {
            return new RetryExecutor(this.retryLimit, this.initialRetryWaitMillis, this.maxRetryWaitMillis);
        }
    }
}

