/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.guess.timeformat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GuessZonePicker {
    private static final Pattern ZONE = Pattern.compile(String.format("(?<zoneSpace> )?(?<zone>(?<zoneOff>%s)|(?<zoneAbb>%s))", "(?:Z|[\\-\\+]\\d\\d(?::?\\d\\d)?)", "([A-Z]{1,3})"));
    private static final ZoneMatcher ZONE_MATCHER = new ZoneMatcher(ZONE);
    private final String zoneSpace;
    private final String zoneOff;

    private GuessZonePicker(String zoneSpace, String zoneOff) {
        this.zoneSpace = zoneSpace;
        this.zoneOff = zoneOff;
    }

    static GuessZonePicker from(String text) {
        return ZONE_MATCHER.match(text);
    }

    String getZoneSpace() {
        return this.zoneSpace;
    }

    String getZoneOff() {
        return this.zoneOff;
    }

    private static class ZoneMatcher {
        private final Pattern pattern;

        ZoneMatcher(Pattern pattern) {
            this.pattern = pattern;
        }

        GuessZonePicker match(String text) {
            Matcher matcher = this.pattern.matcher(text);
            if (matcher.matches()) {
                String zoneSpace = matcher.group("zoneSpace");
                String zoneOff = matcher.group("zoneOff");
                return new GuessZonePicker(zoneSpace != null ? zoneSpace : "", zoneOff != null ? zoneOff : "");
            }
            return null;
        }

        public String toString() {
            return this.pattern.toString();
        }
    }
}

