/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.guess;

import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigSource;
import org.embulk.config.DataSource;
import org.embulk.spi.Buffer;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.guess.CharsetGuess;

public final class NewlineGuess {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] CR = new byte[]{13};
    private static final byte[] LF = new byte[]{10};
    private final ConfigMapperFactory configMapperFactory;
    private final CharsetGuess charsetGuess;

    private NewlineGuess(ConfigMapperFactory configMapperFactory) {
        this.configMapperFactory = configMapperFactory;
        this.charsetGuess = CharsetGuess.of(configMapperFactory);
    }

    public static NewlineGuess of(ConfigMapperFactory configMapperFactory) {
        return new NewlineGuess(configMapperFactory);
    }

    public ConfigDiff guess(ConfigSource config, Buffer sample) {
        if (!config.getNestedOrGetEmpty("parser").has("charset")) {
            return this.charsetGuess.guess(sample);
        }
        int sampleLength = sample.limit();
        byte[] sampleArray = new byte[sampleLength];
        sample.getBytes(0, sampleArray, 0, sampleLength);
        int crCount = NewlineGuess.count(sampleArray, CR);
        int lfCount = NewlineGuess.count(sampleArray, LF);
        int crlfCount = NewlineGuess.count(sampleArray, CRLF);
        ConfigDiff newlineConfig = this.configMapperFactory.newConfigDiff();
        if (crlfCount > crCount / 2 && crlfCount > lfCount / 2) {
            newlineConfig.set("newline", (Object)"CRLF");
        } else if (crCount > lfCount / 2) {
            newlineConfig.set("newline", (Object)"CR");
        } else {
            newlineConfig.set("newline", (Object)"LF");
        }
        ConfigDiff parserConfig = this.configMapperFactory.newConfigDiff();
        parserConfig.setNested("parser", (DataSource)newlineConfig);
        return parserConfig;
    }

    static int countForTesting(byte[] array, byte[] target) {
        return NewlineGuess.count(array, target);
    }

    private static int count(byte[] array, byte[] target) {
        if (target.length == 0) {
            return 0;
        }
        int count = 0;
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            ++count;
        }
        return count;
    }
}

