/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.guess;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.embulk.config.ConfigSource;
import org.embulk.spi.Buffer;
import org.embulk.spi.FileInput;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.file.ListFileInput;
import org.embulk.util.guess.GuessUtil;
import org.embulk.util.text.LineDecoder;
import org.embulk.util.text.LineDelimiter;
import org.embulk.util.text.Newline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LineGuessHelper {
    private static final Logger logger = LoggerFactory.getLogger(LineGuessHelper.class);
    private final ConfigMapperFactory configMapperFactory;

    private LineGuessHelper(ConfigMapperFactory configMapperFactory) {
        this.configMapperFactory = configMapperFactory;
    }

    public static LineGuessHelper of(ConfigMapperFactory configMapperFactory) {
        return new LineGuessHelper(configMapperFactory);
    }

    public final List<String> toLines(ConfigSource config, Buffer sample) {
        Newline newline;
        LineDelimiter lineDelimiter;
        Charset charset;
        ConfigSource parserConfig = config.getNestedOrGetEmpty("parser");
        try {
            charset = GuessUtil.getCharset(parserConfig, this.configMapperFactory, sample);
        }
        catch (IllegalArgumentException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            return null;
        }
        try {
            lineDelimiter = GuessUtil.getLineDelimiter(parserConfig);
        }
        catch (IllegalArgumentException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            return null;
        }
        try {
            newline = GuessUtil.getNewline(parserConfig);
        }
        catch (IllegalArgumentException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            return null;
        }
        ArrayList<Buffer> listBuffer = new ArrayList<Buffer>();
        listBuffer.add(sample);
        ArrayList<ArrayList<Buffer>> listListBuffer = new ArrayList<ArrayList<Buffer>>();
        listListBuffer.add(listBuffer);
        LineDecoder decoder = LineDecoder.of((FileInput)new ListFileInput(listListBuffer), (Charset)charset, (LineDelimiter)lineDelimiter);
        boolean endsWithNewline = GuessUtil.endsWith(sample, newline);
        ArrayList<String> sampleLines = new ArrayList<String>();
        while (decoder.nextFile()) {
            String line;
            while ((line = decoder.poll()) != null) {
                sampleLines.add(line);
            }
            if (endsWithNewline || sampleLines.isEmpty()) continue;
            sampleLines.remove(sampleLines.size() - 1);
        }
        return Collections.unmodifiableList(sampleLines);
    }
}

