/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.file;

import java.io.OutputStream;
import org.embulk.spi.Buffer;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.FileOutput;
import org.embulk.util.file.EmptyBuffer;

public class FileOutputOutputStream
extends OutputStream {
    private int pos = 0;
    private Buffer buffer;
    private final FileOutput out;
    private final BufferAllocator allocator;
    private final CloseMode closeMode;

    public FileOutputOutputStream(FileOutput out, BufferAllocator allocator, CloseMode closeMode) {
        this.buffer = allocator.allocate();
        this.out = out;
        this.allocator = allocator;
        this.closeMode = closeMode;
    }

    public void nextFile() {
        this.out.nextFile();
    }

    public void finish() {
        this.doFlush();
        this.out.finish();
    }

    @Override
    public void write(int b) {
        this.buffer.array()[this.buffer.offset() + this.pos] = (byte)b;
        ++this.pos;
        if (this.pos >= this.buffer.capacity()) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        block1: {
            int available;
            int cursor = off;
            int lengthRemaining = len;
            while ((available = this.buffer.capacity() - this.pos) < lengthRemaining) {
                this.buffer.setBytes(this.pos, b, cursor, available);
                this.pos += available;
                lengthRemaining -= available;
                cursor += available;
                this.flush();
            }
            this.buffer.setBytes(this.pos, b, cursor, lengthRemaining);
            this.pos += lengthRemaining;
            if (available > lengthRemaining) break block1;
            this.flush();
        }
    }

    private boolean doFlush() {
        if (this.pos > 0) {
            this.buffer.limit(this.pos);
            this.out.add(this.buffer);
            this.buffer = EmptyBuffer.getInstance();
            this.pos = 0;
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
        if (this.doFlush()) {
            this.buffer = this.allocator.allocate();
        }
    }

    @Override
    public void close() {
        switch (this.closeMode) {
            case FLUSH: {
                this.doFlush();
                break;
            }
            case FLUSH_FINISH: {
                this.doFlush();
                this.out.finish();
                break;
            }
            case FLUSH_FINISH_CLOSE: {
                this.doFlush();
                this.out.finish();
                this.out.close();
                break;
            }
            case CLOSE: {
                this.out.close();
                break;
            }
        }
        this.buffer.release();
        this.buffer = EmptyBuffer.getInstance();
        this.pos = 0;
    }

    public static enum CloseMode {
        FLUSH,
        FLUSH_FINISH,
        FLUSH_FINISH_CLOSE,
        CLOSE;

    }
}

