/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.file;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Optional;
import org.embulk.spi.Buffer;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.FileInput;

public class InputStreamFileInput
implements FileInput {
    private InputStreamWithHints current = null;
    private final BufferAllocator allocator;
    private final Provider provider;

    public InputStreamFileInput(BufferAllocator allocator, Provider provider) {
        this.allocator = allocator;
        this.provider = provider;
    }

    public InputStreamFileInput(BufferAllocator allocator, Opener opener) {
        this(allocator, new OpenerProvider(opener));
    }

    public InputStreamFileInput(BufferAllocator allocator, InputStream openedStream) {
        this(allocator, new InputStreamProvider(openedStream));
    }

    public boolean nextFile() {
        try {
            if (this.current != null && this.current.getInputStream() != null) {
                this.current.getInputStream().close();
                this.current = null;
            }
            this.current = this.provider.openNextWithHints();
            return this.current != null && this.current.getInputStream() != null;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public Buffer poll() {
        if (this.current == null || this.current.getInputStream() == null) {
            throw new IllegalStateException("InputStreamFileInput#nextFile() must be called before poll().");
        }
        Buffer buffer = this.allocator.allocate();
        try {
            int n = this.current.getInputStream().read(buffer.array(), buffer.offset(), buffer.capacity());
            if (n < 0) {
                Buffer buffer2 = null;
                return buffer2;
            }
            buffer.limit(n);
            Buffer b = buffer;
            buffer = null;
            Buffer buffer3 = b;
            return buffer3;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            if (buffer != null) {
                buffer.release();
                buffer = null;
            }
        }
    }

    public void close() {
        try {
            try {
                if (this.current != null && this.current.getInputStream() != null) {
                    this.current.getInputStream().close();
                    this.current = null;
                }
            }
            finally {
                this.provider.close();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public Optional<String> hintOfCurrentInputFileNameForLogging() {
        return this.getHintOfCurrentInputFileNameForLogging();
    }

    protected final Optional<String> getHintOfCurrentInputFileNameForLogging() {
        if (this.current != null) {
            return this.current.getHintOfCurrentInputFileNameForLogging();
        }
        return Optional.empty();
    }

    private static class InputStreamProvider
    implements Provider {
        private InputStream input;

        public InputStreamProvider(InputStream input) {
            this.input = input;
        }

        @Override
        public InputStream openNext() throws IOException {
            if (this.input == null) {
                return null;
            }
            InputStream ret = this.input;
            this.input = null;
            return ret;
        }

        @Override
        public void close() throws IOException {
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
        }
    }

    private static class OpenerProvider
    implements Provider {
        private Opener opener;

        public OpenerProvider(Opener opener) {
            this.opener = opener;
        }

        @Override
        public InputStream openNext() throws IOException {
            if (this.opener == null) {
                return null;
            }
            InputStream stream = this.opener.open();
            this.opener = null;
            return stream;
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class InputStreamWithHints {
        private final InputStream inputStream;
        private final Optional<String> hintOfCurrentInputFileNameForLogging;

        public InputStreamWithHints(InputStream inputStream, String hintOfCurrentInputFileNameForLogging) {
            this.inputStream = inputStream;
            this.hintOfCurrentInputFileNameForLogging = Optional.ofNullable(hintOfCurrentInputFileNameForLogging);
        }

        public InputStreamWithHints(InputStream inputStream) {
            this.inputStream = inputStream;
            this.hintOfCurrentInputFileNameForLogging = Optional.empty();
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public Optional<String> getHintOfCurrentInputFileNameForLogging() {
            return this.hintOfCurrentInputFileNameForLogging;
        }
    }

    public static class IteratorProvider
    implements Provider {
        private final Iterator<InputStream> iterator;

        public IteratorProvider(Iterable<InputStream> iterable) {
            this.iterator = iterable.iterator();
        }

        public IteratorProvider(Iterator<InputStream> iterator) {
            this.iterator = iterator;
        }

        @Override
        public InputStream openNext() throws IOException {
            if (!this.iterator.hasNext()) {
                return null;
            }
            return this.iterator.next();
        }

        @Override
        public void close() throws IOException {
            while (this.iterator.hasNext()) {
                this.iterator.next().close();
            }
        }
    }

    public static interface Opener {
        public InputStream open() throws IOException;
    }

    public static interface Provider
    extends Closeable {
        default public InputStreamWithHints openNextWithHints() throws IOException {
            return new InputStreamWithHints(this.openNext());
        }

        default public InputStream openNext() throws IOException {
            throw new UnsupportedOperationException("InputStreamFileInput.Provider#openNext must be implemented unless InputStreamFileInput.Provider#openNextWithHints is implemented.");
        }

        @Override
        public void close() throws IOException;
    }
}

