/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.dynamic;

import java.time.Instant;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.util.dynamic.AbstractDynamicColumnSetter;
import org.embulk.util.dynamic.DefaultValueSetter;
import org.embulk.util.timestamp.TimestampFormatter;
import org.msgpack.value.Value;

public class StringColumnSetter
extends AbstractDynamicColumnSetter {
    private final TimestampFormatter timestampFormatter;

    public StringColumnSetter(PageBuilder pageBuilder, Column column, DefaultValueSetter defaultValueSetter, TimestampFormatter timestampFormatter) {
        super(pageBuilder, column, defaultValueSetter);
        this.timestampFormatter = timestampFormatter;
    }

    @Override
    public void setNull() {
        this.pageBuilder.setNull(this.column);
    }

    @Override
    public void set(boolean v) {
        this.pageBuilder.setString(this.column, Boolean.toString(v));
    }

    @Override
    public void set(long v) {
        this.pageBuilder.setString(this.column, Long.toString(v));
    }

    @Override
    public void set(double v) {
        this.pageBuilder.setString(this.column, Double.toString(v));
    }

    @Override
    public void set(String v) {
        this.pageBuilder.setString(this.column, v);
    }

    @Override
    public void set(Instant v) {
        this.pageBuilder.setString(this.column, this.timestampFormatter.format(v));
    }

    @Override
    public void set(Value v) {
        this.pageBuilder.setString(this.column, v.toJson());
    }
}

