/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.dynamic;

import java.time.Instant;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.util.dynamic.AbstractDynamicColumnSetter;
import org.embulk.util.dynamic.DefaultValueSetter;
import org.msgpack.value.Value;

public class LongColumnSetter
extends AbstractDynamicColumnSetter {
    public LongColumnSetter(PageBuilder pageBuilder, Column column, DefaultValueSetter defaultValueSetter) {
        super(pageBuilder, column, defaultValueSetter);
    }

    @Override
    public void setNull() {
        this.pageBuilder.setNull(this.column);
    }

    @Override
    public void set(boolean v) {
        this.pageBuilder.setLong(this.column, v ? 1L : 0L);
    }

    @Override
    public void set(long v) {
        this.pageBuilder.setLong(this.column, v);
    }

    @Override
    public void set(double v) {
        long lv;
        try {
            double roundedDouble = Math.rint(v);
            double diff = v - roundedDouble;
            lv = Math.abs(diff) == 0.5 ? (long)(v + Math.copySign(0.5, v)) : (long)roundedDouble;
        }
        catch (ArithmeticException ex) {
            this.defaultValueSetter.setLong(this.pageBuilder, this.column);
            return;
        }
        this.pageBuilder.setLong(this.column, lv);
    }

    @Override
    public void set(String v) {
        long lv;
        try {
            lv = Long.parseLong(v);
        }
        catch (NumberFormatException ex) {
            this.defaultValueSetter.setLong(this.pageBuilder, this.column);
            return;
        }
        this.pageBuilder.setLong(this.column, lv);
    }

    @Override
    public void set(Instant v) {
        this.pageBuilder.setLong(this.column, v.getEpochSecond());
    }

    @Override
    public void set(Value v) {
        this.defaultValueSetter.setLong(this.pageBuilder, this.column);
    }
}

