/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config.units;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.embulk.spi.Column;
import org.embulk.spi.Schema;
import org.embulk.spi.SchemaConfigException;
import org.embulk.spi.type.Type;
import org.embulk.util.config.units.ColumnConfig;

public class SchemaConfig {
    private final List<ColumnConfig> columns;

    @JsonCreator
    public SchemaConfig(List<ColumnConfig> columns) {
        this.columns = columns;
    }

    @JsonValue
    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public int size() {
        return this.columns.size();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public ColumnConfig getColumn(int index) {
        return this.columns.get(index);
    }

    public String getColumnName(int index) {
        return this.getColumn(index).getName();
    }

    public Type getColumnType(int index) {
        return this.getColumn(index).getType();
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public ColumnConfig lookupColumn(String name) {
        for (ColumnConfig column : this.columns) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        throw new SchemaConfigException(String.format("Column '%s' is not found", name));
    }

    public Schema toSchema() {
        ArrayList<Column> builder = new ArrayList<Column>();
        for (int i = 0; i < this.columns.size(); ++i) {
            builder.add(this.columns.get(i).toColumn(i));
        }
        return new Schema(builder);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof SchemaConfig)) {
            return false;
        }
        SchemaConfig other = (SchemaConfig)otherObject;
        return Objects.equals(this.columns, other.columns);
    }

    public int hashCode() {
        return Objects.hashCode(this.columns);
    }
}

