/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config.modules;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.embulk.spi.type.Type;
import org.embulk.spi.type.Types;

public final class TypeModule
extends SimpleModule {
    public TypeModule() {
        this.addSerializer(Type.class, new TypeSerializer());
        this.addDeserializer(Type.class, (JsonDeserializer)new TypeDeserializer());
    }

    private static class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private static final Map<String, Type> STRING_TO_TYPE;

        public TypeDeserializer() {
            super(Type.class);
        }

        protected Type _deserialize(String value, DeserializationContext context) throws IOException {
            Type type = STRING_TO_TYPE.get(value);
            if (type == null) {
                throw new JsonMappingException(String.format("Unknown type name '%s'. Supported types are: %s", value, String.join((CharSequence)", ", STRING_TO_TYPE.keySet())));
            }
            return type;
        }

        static {
            HashMap<String, Object> builder = new HashMap<String, Object>();
            builder.put(Types.BOOLEAN.getName(), Types.BOOLEAN);
            builder.put(Types.LONG.getName(), Types.LONG);
            builder.put(Types.DOUBLE.getName(), Types.DOUBLE);
            builder.put(Types.STRING.getName(), Types.STRING);
            builder.put(Types.TIMESTAMP.getName(), Types.TIMESTAMP);
            builder.put(Types.JSON.getName(), Types.JSON);
            STRING_TO_TYPE = Collections.unmodifiableMap(builder);
        }
    }

    private static class TypeSerializer
    extends JsonSerializer<Type> {
        private TypeSerializer() {
        }

        public void serialize(Type value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeString(value.getName());
        }
    }
}

