/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config.rebuild;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.embulk.util.config.rebuild.ArrayNodeRebuilder;
import org.embulk.util.config.rebuild.BigIntegerNodeRebuilder;
import org.embulk.util.config.rebuild.BooleanNodeRebuilder;
import org.embulk.util.config.rebuild.DecimalNodeRebuilder;
import org.embulk.util.config.rebuild.DoubleNodeRebuilder;
import org.embulk.util.config.rebuild.FloatNodeRebuilder;
import org.embulk.util.config.rebuild.IntNodeRebuilder;
import org.embulk.util.config.rebuild.LongNodeRebuilder;
import org.embulk.util.config.rebuild.NullNodeRebuilder;
import org.embulk.util.config.rebuild.ObjectNodeRebuilder;
import org.embulk.util.config.rebuild.ShortNodeRebuilder;
import org.embulk.util.config.rebuild.TextNodeRebuilder;

final class Util {
    private Util() {
    }

    static JsonNode rebuildPerType(Class clazz, Object node, ObjectMapper mapper) {
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.ArrayNode")) {
            return ArrayNodeRebuilder.rebuild(node, mapper);
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.BigIntegerNode")) {
            return BigIntegerNodeRebuilder.rebuild(node);
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.BinaryNode")) {
            throw new UnsupportedOperationException("com.fasterxml.jackson.databind.node.BinaryNode is not supported.");
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.BooleanNode")) {
            return BooleanNodeRebuilder.rebuild(node);
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.DecimalNode")) {
            return DecimalNodeRebuilder.rebuild(node);
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.DoubleNode")) {
            return DoubleNodeRebuilder.rebuild(node);
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.FloatNode")) {
            return FloatNodeRebuilder.rebuild(node);
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.IntNode")) {
            return IntNodeRebuilder.rebuild(node);
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.LongNode")) {
            return LongNodeRebuilder.rebuild(node);
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.MissingNode")) {
            throw new IllegalStateException("com.fasterxml.jackson.databind.node.MissingNode should not be there.");
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.NullNode")) {
            return NullNodeRebuilder.rebuild(node);
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.ObjectNode")) {
            return ObjectNodeRebuilder.rebuild(node, mapper);
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.POJONode")) {
            throw new UnsupportedOperationException("com.fasterxml.jackson.databind.node.POJONode is not supported.");
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.ShortNode")) {
            return ShortNodeRebuilder.rebuild(node);
        }
        if (Util.isSubclassOf(clazz, "com.fasterxml.jackson.databind.node.TextNode")) {
            return TextNodeRebuilder.rebuild(node);
        }
        throw new IllegalStateException("Unknown Jackson JsonNode type: " + clazz.toString());
    }

    static Class<?> getClassUnder(Object from, String expectedAncestor, Class<?> callerClass) {
        if (from == null) {
            throw new NullPointerException(callerClass.getSimpleName() + " received null.");
        }
        Class<?> fromClass = from.getClass();
        if (!Util.isSubclassOf(fromClass, expectedAncestor)) {
            throw new ClassCastException("Expected " + expectedAncestor + " is actually not " + expectedAncestor + ".");
        }
        return fromClass;
    }

    static <T> T getThroughGetter(Object from, String expectedAncestor, String getterMethodName, Class<T> expectedResultClass, Class<?> callerClass) {
        Object object;
        Method getterMethod;
        Class<?> fromClass = Util.getClassUnder(from, expectedAncestor, callerClass);
        try {
            getterMethod = fromClass.getMethod(getterMethodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(fromClass.getCanonicalName() + " (" + expectedAncestor + ") does not have " + getterMethodName + "() : " + ex.getMessage(), ex);
        }
        try {
            object = getterMethod.invoke(from, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new IllegalStateException(fromClass.getCanonicalName() + "#" + getterMethodName + " threw unexpected Exception.", targetException);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(fromClass.getCanonicalName() + "#" + getterMethodName + " is not accessible.", ex);
        }
        if (object == null) {
            throw new NullPointerException(fromClass.getCanonicalName() + "#" + getterMethodName + "() returned null.");
        }
        if (!expectedResultClass.isInstance(object)) {
            throw new ClassCastException(fromClass.getCanonicalName() + "#" + getterMethodName + "() did not return " + expectedResultClass.getCanonicalName() + ", but: " + object.getClass().getCanonicalName());
        }
        return expectedResultClass.cast(object);
    }

    private static boolean isSubclassOf(Class<?> target, String expectedAncestor) {
        for (Class<?> klazz = target; klazz != null; klazz = klazz.getSuperclass()) {
            if (!klazz.getCanonicalName().equals(expectedAncestor)) continue;
            return true;
        }
        return false;
    }
}

