/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Set;
import javax.validation.Validator;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigSource;
import org.embulk.config.DataSource;
import org.embulk.util.config.Compat;
import org.embulk.util.config.Task;
import org.embulk.util.config.TaskValidationException;

public final class ConfigMapper {
    private final ObjectMapper objectMapper;
    private final Validator validator;

    ConfigMapper(ObjectMapper objectMapper, Validator validator) {
        this.objectMapper = objectMapper;
        this.validator = validator;
    }

    public <T extends Task> T map(ConfigSource config, Class<T> taskType) {
        Set violations;
        Task value;
        ObjectNode objectNode;
        try {
            objectNode = Compat.rebuildObjectNode((DataSource)config);
        }
        catch (IOException ex) {
            throw new ConfigException("org.embulk.config.ConfigSource#toJson() returned an invalid JSON.", (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw new ConfigException("Unexpected failure in reinterpreting ObjectNode from org.embulk.config.ConfigSource.", (Throwable)ex);
        }
        try {
            value = (Task)this.objectMapper.readValue(objectNode.traverse(), taskType);
        }
        catch (JsonMappingException ex) {
            throw new ConfigException("Failed to map a JSON value into some object.", (Throwable)ex);
        }
        catch (JsonParseException ex) {
            throw new ConfigException("Unexpected failure in parsing ObjectNode rebuilt from org.embulk.config.ConfigSource.", (Throwable)ex);
        }
        catch (JsonProcessingException ex) {
            throw new ConfigException("Unexpected failure in processing ObjectNode rebuilt from org.embulk.config.ConfigSource.", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ConfigException("Unexpected I/O error in ObjectNode rebuilt from org.embulk.config.ConfigSource.", (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw new ConfigException("Unexpected failure in ObjectNode rebuilt from org.embulk.config.ConfigSource.", (Throwable)ex);
        }
        if (this.validator != null && !(violations = this.validator.validate((Object)value, new Class[0])).isEmpty()) {
            throw new TaskValidationException(violations);
        }
        return (T)value;
    }
}

