/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.embulk.config.DataSource;
import org.embulk.util.config.rebuild.ObjectNodeRebuilder;

final class Compat {
    private static final ObjectMapper SIMPLE_MAPPER = new ObjectMapper();

    private Compat() {
    }

    static String toJson(DataSource source) throws IOException {
        Optional<String> jsonString = Compat.callToJsonIfAvailable(source);
        if (jsonString.isPresent()) {
            return jsonString.get();
        }
        ObjectNode objectNode = Compat.callGetObjectNodeAndRebuildIfAvailable(source, SIMPLE_MAPPER);
        return SIMPLE_MAPPER.writeValueAsString((Object)objectNode);
    }

    static ObjectNode rebuildObjectNode(DataSource source) throws IOException {
        Optional<String> jsonString = Compat.callToJsonIfAvailable(source);
        if (jsonString.isPresent()) {
            JsonNode jsonNode = SIMPLE_MAPPER.readTree(jsonString.get());
            if (jsonNode == null) {
                throw new NullPointerException("DataSource#toJson() returned null.");
            }
            if (!jsonNode.isObject()) {
                throw new ClassCastException("DataSource#toJson() returned not a JSON object: " + jsonNode.getClass().getCanonicalName());
            }
            return (ObjectNode)jsonNode;
        }
        return Compat.callGetObjectNodeAndRebuildIfAvailable(source, SIMPLE_MAPPER);
    }

    private static Optional<String> callToJsonIfAvailable(DataSource source) {
        Object jsonStringObject;
        Method toJson = Compat.getToJsonMethod(source.getClass());
        if (toJson == null) {
            return Optional.empty();
        }
        try {
            jsonStringObject = toJson.invoke((Object)source, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new IllegalStateException("DataSource#toJson() threw unexpected Exception.", targetException);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("DataSource#toJson() is not accessible.", ex);
        }
        if (jsonStringObject == null) {
            throw new NullPointerException("org.embulk.config.DataSource#toJson() returned null.");
        }
        if (!(jsonStringObject instanceof String)) {
            throw new ClassCastException("org.embulk.config.DataSource#toJson() returned not a String: " + jsonStringObject.getClass().getCanonicalName());
        }
        return Optional.of((String)jsonStringObject);
    }

    private static ObjectNode callGetObjectNodeAndRebuildIfAvailable(DataSource source, ObjectMapper mapper) {
        Object coreObjectNode;
        Class<?> coreDataSourceImplClass = source.getClass();
        if (!coreDataSourceImplClass.getCanonicalName().equals("org.embulk.config.DataSourceImpl")) {
            throw new ClassCastException("DataSource specified is not org.embulk.config.DataSourceImpl.");
        }
        Method getObjectNode = Compat.getGetObjectNodeMethod(coreDataSourceImplClass);
        if (getObjectNode == null) {
            throw new IllegalStateException("org.embulk.config.DataSourceImpl does not implement getObjectNode().");
        }
        try {
            coreObjectNode = getObjectNode.invoke((Object)source, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new IllegalStateException("DataSourceImpl#getObjectNode() threw unexpected Exception.", targetException);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("DataSourceImpl#getObjectNode() is not accessible.", ex);
        }
        return ObjectNodeRebuilder.rebuild(coreObjectNode, mapper);
    }

    private static Method getToJsonMethod(Class<? extends DataSource> coreDataSourceImplClass) {
        try {
            return coreDataSourceImplClass.getMethod("toJson", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Method getGetObjectNodeMethod(Class<? extends DataSource> coreDataSourceImplClass) {
        try {
            return coreDataSourceImplClass.getMethod("getObjectNode", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }
}

