/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi.json;

import java.util.Objects;
import org.embulk.spi.json.JsonValue;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableStringValueImpl;

public final class JsonString
implements JsonValue {
    private final ImmutableStringValueImpl value;
    private final String literal;

    private JsonString(String value, String literal) {
        if (value == null) {
            throw new NullPointerException("string is null.");
        }
        this.value = new ImmutableStringValueImpl(value);
        this.literal = literal;
    }

    private JsonString(ImmutableStringValueImpl msgpackValue) {
        this.value = msgpackValue;
        this.literal = null;
    }

    static JsonString fromMsgpack(StringValue msgpackValue) {
        return new JsonString((ImmutableStringValueImpl)msgpackValue.immutableValue());
    }

    public static JsonString of(String value) {
        return new JsonString(value, null);
    }

    public static JsonString withLiteral(String value, String literal) {
        return new JsonString(value, literal);
    }

    @Override
    public JsonValue.EntityType getEntityType() {
        return JsonValue.EntityType.STRING;
    }

    @Override
    public JsonString asJsonString() {
        return this;
    }

    @Override
    public int presumeReferenceSizeInBytes() {
        if (this.literal == null) {
            return this.value.asString().length() * 2 + 4;
        }
        return this.value.asString().length() * 2 + this.literal.length() * 2 + 4;
    }

    public String getString() {
        return this.value.asString();
    }

    public CharSequence getChars() {
        return this.value.asString();
    }

    @Override
    public String toJson() {
        if (this.literal != null) {
            return this.literal;
        }
        return JsonString.escapeStringForJsonLiteral(this.value.asString());
    }

    @Override
    @Deprecated
    public Value toMsgpack() {
        return this.value;
    }

    public String toString() {
        return JsonString.escapeStringForJsonLiteral(this.value.asString());
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof JsonString)) {
            return false;
        }
        JsonString other = (JsonString)otherObject;
        return Objects.equals(this.value.asString(), other.value.asString());
    }

    public int hashCode() {
        return Objects.hashCode(this.value.asString());
    }

    static void appendEscapedStringForJsonLiteral(String original, StringBuilder builder) {
        if (original == null) {
            return;
        }
        if (original.isEmpty()) {
            builder.append("\"\"");
            return;
        }
        builder.append("\"");
        int length = original.length();
        block10: for (int i = 0; i < length; ++i) {
            char current = original.charAt(i);
            switch (current) {
                case '\\': {
                    builder.append("\\\\");
                    continue block10;
                }
                case '\"': {
                    builder.append("\\\"");
                    continue block10;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block10;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    builder.append("\\u00");
                    String hex = Integer.toHexString(current);
                    builder.append("00", 0, 2 - hex.length());
                    builder.append(hex);
                    continue block10;
                }
                default: {
                    builder.append(current);
                }
            }
        }
        builder.append("\"");
    }

    static String escapeStringForJsonLiteral(String original) {
        StringBuilder builder = new StringBuilder();
        JsonString.appendEscapedStringForJsonLiteral(original, builder);
        return builder.toString();
    }
}

