/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi;

import java.time.Instant;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.ExecSession;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.PageOutput;
import org.embulk.spi.PageReader;
import org.embulk.spi.Schema;
import org.embulk.spi.TempFileSpace;
import org.embulk.spi.time.Timestamp;
import org.slf4j.Logger;

public class Exec {
    private static final InheritableThreadLocal<ExecSession> session = new InheritableThreadLocal();

    private Exec() {
    }

    static void setThreadLocalSession(ExecSession session) {
        Exec.session.set(session);
    }

    @Deprecated
    public static ExecSession session() {
        return Exec.sessionForInside();
    }

    private static ExecSession sessionForInside() {
        ExecSession session = (ExecSession)Exec.session.get();
        if (session == null) {
            throw new NullPointerException("Exec is used outside of ExecInternal.doWith.");
        }
        return session;
    }

    @Deprecated
    public static Timestamp getTransactionTime() {
        return Timestamp.ofInstant(Exec.sessionForInside().getTransactionTimeInstant());
    }

    public static Instant getTransactionTimeInstant() {
        return Exec.sessionForInside().getTransactionTimeInstant();
    }

    @Deprecated
    public static Logger getLogger(String name) {
        return Exec.sessionForInside().getLogger(name);
    }

    @Deprecated
    public static Logger getLogger(Class<?> clazz) {
        return Exec.sessionForInside().getLogger(clazz);
    }

    public static BufferAllocator getBufferAllocator() {
        return Exec.sessionForInside().getBufferAllocator();
    }

    public static PageBuilder getPageBuilder(BufferAllocator allocator, Schema schema, PageOutput output) {
        return Exec.sessionForInside().getPageBuilder(allocator, schema, output);
    }

    public static PageReader getPageReader(Schema schema) {
        return Exec.sessionForInside().getPageReader(schema);
    }

    @Deprecated
    public static TaskReport newTaskReport() {
        return Exec.sessionForInside().newTaskReport();
    }

    @Deprecated
    public static ConfigDiff newConfigDiff() {
        return Exec.sessionForInside().newConfigDiff();
    }

    @Deprecated
    public static ConfigSource newConfigSource() {
        return Exec.sessionForInside().newConfigSource();
    }

    @Deprecated
    public static TaskSource newTaskSource() {
        return Exec.sessionForInside().newTaskSource();
    }

    public static TempFileSpace getTempFileSpace() {
        return Exec.sessionForInside().getTempFileSpace();
    }

    public static boolean isPreview() {
        return Exec.sessionForInside().isPreview();
    }
}

