/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.parser.csv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskSource;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.Column;
import org.embulk.spi.ColumnVisitor;
import org.embulk.spi.DataException;
import org.embulk.spi.Exec;
import org.embulk.spi.FileInput;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.PageOutput;
import org.embulk.spi.ParserPlugin;
import org.embulk.spi.Schema;
import org.embulk.spi.time.Timestamp;
import org.embulk.spi.type.TimestampType;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.config.Task;
import org.embulk.util.config.units.ColumnConfig;
import org.embulk.util.config.units.SchemaConfig;
import org.embulk.util.csv.CsvTokenizer;
import org.embulk.util.csv.InvalidCsvFormatException;
import org.embulk.util.csv.RecordHasUnexpectedTrailingColumnException;
import org.embulk.util.json.JsonParseException;
import org.embulk.util.json.JsonParser;
import org.embulk.util.text.LineDecoder;
import org.embulk.util.text.LineDelimiter;
import org.embulk.util.text.Newline;
import org.embulk.util.timestamp.TimestampFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvParserPlugin
implements ParserPlugin {
    private static final Set<String> TRUE_STRINGS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("true", "True", "TRUE", "yes", "Yes", "YES", "t", "T", "y", "Y", "on", "On", "ON", "1")));
    private static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().build();
    private static final Logger logger = LoggerFactory.getLogger(CsvParserPlugin.class);

    public void transaction(ConfigSource config, ParserPlugin.Control control) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createConfigMapper().map(config, PluginTask.class);
        if (task.getHeaderLine().isPresent()) {
            if (task.getSkipHeaderLines() > 0) {
                throw new ConfigException("'header_line' option is invalid if 'skip_header_lines' is set.");
            }
            if (task.getHeaderLine().get().booleanValue()) {
                task.setSkipHeaderLines(1);
            } else {
                task.setSkipHeaderLines(0);
            }
        }
        control.run(task.dump(), task.getSchemaConfig().toSchema());
    }

    public void run(TaskSource taskSource, Schema schema, FileInput input, PageOutput output) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createTaskMapper().map(taskSource, PluginTask.class);
        final TimestampFormatter[] timestampFormatters = CsvParserPlugin.newTimestampColumnFormatters(task, task.getSchemaConfig());
        final JsonParser jsonParser = new JsonParser();
        CsvTokenizer.Builder tokenizerBuilder = CsvParserPlugin.buildCsvTokenizerBuilder(task);
        final boolean allowOptionalColumns = task.getAllowOptionalColumns();
        boolean allowExtraColumns = task.getAllowExtraColumns();
        boolean stopOnInvalidRecord = task.getStopOnInvalidRecord();
        int skipHeaderLines = task.getSkipHeaderLines();
        try (final PageBuilder pageBuilder = CsvParserPlugin.getPageBuilder(Exec.getBufferAllocator(), schema, output);){
            while (input.nextFile()) {
                boolean hasNextRecord;
                final CsvTokenizer tokenizer = tokenizerBuilder.build(LineDecoder.of((FileInput)input, (Charset)task.getCharset(), (LineDelimiter)task.getLineDelimiterRecognized().orElse(null)).iterator());
                String fileName = input.hintOfCurrentInputFileNameForLogging().orElse("-");
                for (int skipHeaderLineNumber = skipHeaderLines; skipHeaderLineNumber > 0 && tokenizer.skipHeaderLine(); --skipHeaderLineNumber) {
                }
                try {
                    if (!tokenizer.nextRecord()) {
                        continue;
                    }
                }
                catch (InvalidCsvFormatException ex) {
                    throw new DataException((Throwable)ex);
                }
                do {
                    try {
                        schema.visitColumns(new ColumnVisitor(){

                            public void booleanColumn(Column column) {
                                String v = this.nextColumn();
                                if (v == null) {
                                    pageBuilder.setNull(column);
                                } else {
                                    pageBuilder.setBoolean(column, TRUE_STRINGS.contains(v));
                                }
                            }

                            public void longColumn(Column column) {
                                String v = this.nextColumn();
                                if (v == null) {
                                    pageBuilder.setNull(column);
                                } else {
                                    try {
                                        pageBuilder.setLong(column, Long.parseLong(v));
                                    }
                                    catch (NumberFormatException e) {
                                        throw new CsvRecordValidateException(e);
                                    }
                                }
                            }

                            public void doubleColumn(Column column) {
                                String v = this.nextColumn();
                                if (v == null) {
                                    pageBuilder.setNull(column);
                                } else {
                                    try {
                                        pageBuilder.setDouble(column, Double.parseDouble(v));
                                    }
                                    catch (NumberFormatException e) {
                                        throw new CsvRecordValidateException(e);
                                    }
                                }
                            }

                            public void stringColumn(Column column) {
                                String v = this.nextColumn();
                                if (v == null) {
                                    pageBuilder.setNull(column);
                                } else {
                                    pageBuilder.setString(column, v);
                                }
                            }

                            public void timestampColumn(Column column) {
                                String v = this.nextColumn();
                                if (v == null) {
                                    pageBuilder.setNull(column);
                                } else {
                                    Instant instant;
                                    try {
                                        instant = timestampFormatters[column.getIndex()].parse(v);
                                    }
                                    catch (DateTimeParseException e) {
                                        throw new CsvRecordValidateException(e);
                                    }
                                    CsvParserPlugin.setTimestamp(pageBuilder, column, instant);
                                }
                            }

                            public void jsonColumn(Column column) {
                                String v = this.nextColumn();
                                if (v == null) {
                                    pageBuilder.setNull(column);
                                } else {
                                    try {
                                        pageBuilder.setJson(column, jsonParser.parse(v));
                                    }
                                    catch (JsonParseException e) {
                                        throw new CsvRecordValidateException(e);
                                    }
                                }
                            }

                            private String nextColumn() {
                                if (allowOptionalColumns && !tokenizer.hasNextColumn()) {
                                    return null;
                                }
                                return tokenizer.nextColumnOrNull();
                            }
                        });
                        try {
                            hasNextRecord = tokenizer.nextRecord();
                        }
                        catch (RecordHasUnexpectedTrailingColumnException ex) {
                            if (allowExtraColumns) {
                                String tooManyColumnsLine = tokenizer.skipCurrentLine();
                                hasNextRecord = tokenizer.nextRecord();
                            }
                            throw ex;
                        }
                        pageBuilder.addRecord();
                    }
                    catch (CsvRecordValidateException | InvalidCsvFormatException e) {
                        String skippedLine = tokenizer.skipCurrentLine();
                        long lineNumber = tokenizer.getCurrentLineNumber();
                        if (stopOnInvalidRecord) {
                            throw new DataException(String.format("Invalid record at %s:%d: %s", fileName, lineNumber, skippedLine), (Throwable)e);
                        }
                        logger.warn(String.format("Skipped line %s:%d (%s): %s", fileName, lineNumber, ((Throwable)e).getMessage(), skippedLine));
                        hasNextRecord = tokenizer.nextRecord();
                    }
                } while (hasNextRecord);
            }
            pageBuilder.finish();
        }
    }

    private static CsvTokenizer.Builder buildCsvTokenizerBuilder(PluginTask task) {
        try {
            CsvTokenizer.Builder builder = CsvTokenizer.builder((String)task.getDelimiter());
            task.getQuoteChar().ifPresent(q -> builder.setQuote(q.getCharacter()));
            task.getEscapeChar().ifPresent(e -> builder.setEscape(e.getCharacter()));
            builder.setNewline(task.getNewline().getString());
            if (task.getTrimIfNotQuoted()) {
                builder.enableTrimIfNotQuoted();
            }
            if (task.getQuotesInQuotedFields() == QuotesInQuotedFields.ACCEPT_STRAY_QUOTES_ASSUMING_NO_DELIMITERS_IN_FIELDS) {
                builder.acceptStrayQuotesAssumingNoDelimitersInFields();
            }
            builder.setMaxQuotedFieldLength(task.getMaxQuotedSizeLimit());
            task.getCommentLineMarker().ifPresent(m -> builder.setCommentLineMarker(m));
            task.getNullString().ifPresent(n -> builder.setNullString(n));
            return builder;
        }
        catch (RuntimeException ex) {
            throw new ConfigException((Throwable)ex);
        }
    }

    private static PageBuilder getPageBuilder(BufferAllocator allocator, Schema schema, PageOutput output) {
        try {
            return Exec.getPageBuilder((BufferAllocator)allocator, (Schema)schema, (PageOutput)output);
        }
        catch (NoSuchMethodError ex) {
            logger.warn("embulk-parser-csv is expected to work with Embulk v0.10.17+.", (Throwable)ex);
            return new PageBuilder(allocator, schema, output);
        }
    }

    private static TimestampFormatter[] newTimestampColumnFormatters(PluginTask task, SchemaConfig schema) {
        TimestampFormatter[] formatters = new TimestampFormatter[schema.getColumnCount()];
        int i = 0;
        for (ColumnConfig column : schema.getColumns()) {
            if (column.getType() instanceof TimestampType) {
                TimestampColumnOption columnOption = (TimestampColumnOption)CONFIG_MAPPER_FACTORY.createConfigMapper().map(column.getOption(), TimestampColumnOption.class);
                String pattern = columnOption.getFormat().orElse(task.getDefaultTimestampFormat());
                formatters[i] = TimestampFormatter.builder((String)pattern, (boolean)true).setDefaultZoneFromString(columnOption.getTimeZoneId().orElse(task.getDefaultTimeZoneId())).setDefaultDateFromString(columnOption.getDate().orElse(task.getDefaultDate())).build();
            }
            ++i;
        }
        return formatters;
    }

    private static void setTimestamp(PageBuilder pageBuilder, Column column, Instant instant) {
        try {
            pageBuilder.setTimestamp(column, instant);
        }
        catch (NoSuchMethodError ex) {
            logger.warn("embulk-parser-csv is expected to work with Embulk v0.10.17+.", (Throwable)ex);
            pageBuilder.setTimestamp(column, Timestamp.ofInstant((Instant)instant));
        }
    }

    static class CsvRecordValidateException
    extends DataException {
        CsvRecordValidateException(Throwable cause) {
            super(cause);
        }
    }

    private static interface TimestampColumnOption
    extends Task {
        @Config(value="timezone")
        @ConfigDefault(value="null")
        public Optional<String> getTimeZoneId();

        @Config(value="format")
        @ConfigDefault(value="null")
        public Optional<String> getFormat();

        @Config(value="date")
        @ConfigDefault(value="null")
        public Optional<String> getDate();
    }

    public static class EscapeCharacter {
        private final char character;

        public EscapeCharacter(char character) {
            this.character = character;
        }

        public static EscapeCharacter noEscape() {
            return new EscapeCharacter('\u0000');
        }

        @JsonCreator
        public static EscapeCharacter ofString(String str) {
            if (str.length() >= 2) {
                throw new ConfigException("\"escape\" option accepts only 1 character.");
            }
            if (str.isEmpty()) {
                logger.warn("Setting '' (empty string) to \"escape\" option is obsoleted. Currently it becomes null automatically but this behavior will be removed. Please set \"escape: null\" explicitly.");
                return EscapeCharacter.noEscape();
            }
            return new EscapeCharacter(str.charAt(0));
        }

        @JsonIgnore
        public char getCharacter() {
            return this.character;
        }

        @JsonValue
        public String getOptionalString() {
            return new String(new char[]{this.character});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EscapeCharacter)) {
                return false;
            }
            EscapeCharacter o = (EscapeCharacter)obj;
            return this.character == o.character;
        }

        public int hashCode() {
            return Objects.hash(Character.valueOf(this.character));
        }
    }

    public static class QuoteCharacter {
        private final char character;

        public QuoteCharacter(char character) {
            this.character = character;
        }

        public static QuoteCharacter noQuote() {
            return new QuoteCharacter('\u0000');
        }

        @JsonCreator
        public static QuoteCharacter ofString(String str) {
            if (str.length() >= 2) {
                throw new ConfigException("\"quote\" option accepts only 1 character.");
            }
            if (str.isEmpty()) {
                logger.warn("Setting '' (empty string) to \"quote\" option is obsoleted. Currently it becomes '\"' automatically but this behavior will be removed. Please set '\"' explicitly.");
                return new QuoteCharacter('\"');
            }
            return new QuoteCharacter(str.charAt(0));
        }

        @JsonIgnore
        public char getCharacter() {
            return this.character;
        }

        @JsonValue
        public String getOptionalString() {
            return new String(new char[]{this.character});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof QuoteCharacter)) {
                return false;
            }
            QuoteCharacter o = (QuoteCharacter)obj;
            return this.character == o.character;
        }

        public int hashCode() {
            return Objects.hash(Character.valueOf(this.character));
        }
    }

    public static enum QuotesInQuotedFields {
        ACCEPT_ONLY_RFC4180_ESCAPED,
        ACCEPT_STRAY_QUOTES_ASSUMING_NO_DELIMITERS_IN_FIELDS;


        @JsonCreator
        public static QuotesInQuotedFields ofString(String string) {
            for (QuotesInQuotedFields value : QuotesInQuotedFields.values()) {
                if (!string.equals(value.toString())) continue;
                return value;
            }
            throw new ConfigException("\"quotes_in_quoted_fields\" must be one of [ACCEPT_ONLY_RFC4180_ESCAPED, ACCEPT_STRAY_QUOTES_ASSUMING_NO_DELIMITERS_IN_FIELDS].");
        }
    }

    public static interface PluginTask
    extends Task {
        @Config(value="columns")
        public SchemaConfig getSchemaConfig();

        @Config(value="header_line")
        @ConfigDefault(value="null")
        public Optional<Boolean> getHeaderLine();

        @Config(value="skip_header_lines")
        @ConfigDefault(value="0")
        public int getSkipHeaderLines();

        public void setSkipHeaderLines(int var1);

        @Config(value="delimiter")
        @ConfigDefault(value="\",\"")
        public String getDelimiter();

        @Config(value="quote")
        @ConfigDefault(value="\"\\\"\"")
        public Optional<QuoteCharacter> getQuoteChar();

        @Config(value="escape")
        @ConfigDefault(value="\"\\\\\"")
        public Optional<EscapeCharacter> getEscapeChar();

        @Config(value="null_string")
        @ConfigDefault(value="null")
        public Optional<String> getNullString();

        @Config(value="trim_if_not_quoted")
        @ConfigDefault(value="false")
        public boolean getTrimIfNotQuoted();

        @Config(value="quotes_in_quoted_fields")
        @ConfigDefault(value="\"ACCEPT_ONLY_RFC4180_ESCAPED\"")
        public QuotesInQuotedFields getQuotesInQuotedFields();

        @Config(value="max_quoted_size_limit")
        @ConfigDefault(value="131072")
        public long getMaxQuotedSizeLimit();

        @Config(value="comment_line_marker")
        @ConfigDefault(value="null")
        public Optional<String> getCommentLineMarker();

        @Config(value="allow_optional_columns")
        @ConfigDefault(value="false")
        public boolean getAllowOptionalColumns();

        @Config(value="allow_extra_columns")
        @ConfigDefault(value="false")
        public boolean getAllowExtraColumns();

        @Config(value="stop_on_invalid_record")
        @ConfigDefault(value="false")
        public boolean getStopOnInvalidRecord();

        @Config(value="charset")
        @ConfigDefault(value="\"utf-8\"")
        public Charset getCharset();

        @Config(value="newline")
        @ConfigDefault(value="\"CRLF\"")
        public Newline getNewline();

        @Config(value="line_delimiter_recognized")
        @ConfigDefault(value="null")
        public Optional<LineDelimiter> getLineDelimiterRecognized();

        @Config(value="default_timezone")
        @ConfigDefault(value="\"UTC\"")
        public String getDefaultTimeZoneId();

        @Config(value="default_timestamp_format")
        @ConfigDefault(value="\"%Y-%m-%d %H:%M:%S.%N %z\"")
        public String getDefaultTimestampFormat();

        @Config(value="default_date")
        @ConfigDefault(value="\"1970-01-01\"")
        public String getDefaultDate();
    }
}

