/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi;

import java.util.ArrayList;
import java.util.List;
import org.embulk.config.ConfigSource;
import org.embulk.config.Task;
import org.embulk.config.TaskSource;
import org.embulk.spi.Column;
import org.embulk.spi.ColumnVisitor;
import org.embulk.spi.FileOutput;
import org.embulk.spi.FormatterPlugin;
import org.embulk.spi.Page;
import org.embulk.spi.PageOutput;
import org.embulk.spi.PageReader;
import org.embulk.spi.Schema;

public class MockFormatterPlugin
implements FormatterPlugin {
    public static List<List<Object>> records;

    public void transaction(ConfigSource config, Schema schema, FormatterPlugin.Control control) {
        PluginTask task = (PluginTask)config.loadConfig(PluginTask.class);
        control.run(task.dump());
    }

    public PageOutput open(TaskSource taskSource, final Schema schema, FileOutput output) {
        return new PageOutput(){

            public void add(Page page) {
                records = MockFormatterPlugin.readPage(schema, page);
            }

            public void finish() {
            }

            public void close() {
            }
        };
    }

    public static List<List<Object>> readPage(Schema schema, Page page) {
        ArrayList<List<Object>> records = new ArrayList<List<Object>>();
        try (final PageReader pageReader = new PageReader(schema);){
            pageReader.setPage(page);
            while (pageReader.nextRecord()) {
                final ArrayList record = new ArrayList();
                schema.visitColumns(new ColumnVisitor(){

                    public void booleanColumn(Column column) {
                        if (!pageReader.isNull(column)) {
                            record.add(pageReader.getBoolean(column));
                        }
                    }

                    public void longColumn(Column column) {
                        if (!pageReader.isNull(column)) {
                            record.add(pageReader.getLong(column));
                        }
                    }

                    public void doubleColumn(Column column) {
                        if (!pageReader.isNull(column)) {
                            record.add(pageReader.getDouble(column));
                        }
                    }

                    public void stringColumn(Column column) {
                        if (!pageReader.isNull(column)) {
                            record.add(pageReader.getString(column));
                        }
                    }

                    public void timestampColumn(Column column) {
                        if (!pageReader.isNull(column)) {
                            record.add(pageReader.getTimestampInstant(column));
                        }
                    }

                    public void jsonColumn(Column column) {
                        if (!pageReader.isNull(column)) {
                            record.add(pageReader.getJson(column));
                        }
                    }
                });
                records.add(record);
            }
        }
        return records;
    }

    public static interface PluginTask
    extends Task {
    }
}

